/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class GroupStarting
extends SystemFunction {
    public Sequence<ArrayItem> call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence input = arguments[0];
        Function function = (Function)arguments[1].head();
        return new LazySequence<ArrayItem>(new GroupStartingFunctionIterator(input.iterate(), function, context));
    }

    private static class GroupStartingFunctionIterator
    implements SequenceIterator<ArrayItem> {
        private SequenceIterator<?> baseIterator;
        private Function function;
        private XPathContext context;
        private Item pending = null;
        private boolean finished = false;

        public GroupStartingFunctionIterator(SequenceIterator<?> in, Function f, XPathContext context) {
            this.baseIterator = in;
            this.function = f;
            this.context = context;
        }

        @Override
        public ArrayItem next() throws XPathException {
            Object item;
            if (this.finished) {
                return null;
            }
            ArrayList group = new ArrayList();
            if (this.pending != null) {
                group.add(this.pending);
            }
            while ((item = this.baseIterator.next()) != null) {
                Sequence<?> test = this.function.call(this.context, (Sequence[])SequenceTool.fromItems(new Item[]{item}));
                boolean match = ExpressionTool.effectiveBooleanValue(test.head());
                if (match) {
                    this.pending = item;
                    return this.makeSimpleArray(group);
                }
                group.add((Item<?>)item);
            }
            this.pending = null;
            this.finished = true;
            return this.makeSimpleArray(group);
        }

        private SimpleArrayItem makeSimpleArray(List<Item<?>> group) {
            try {
                return SimpleArrayItem.makeSimpleArrayItem(new ListIterator(group));
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void close() {
            this.baseIterator.close();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

