/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ActivityNode;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Helpers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pin
extends ActivityNode {
    private BridgeParameter parameter;

    public Pin(BridgeParameter parameter, Helpers helpers) {
        super(parameter.getName(), helpers);
        this.parameter = parameter;
    }

    @Override
    protected String getXMIElementName() {
        return "argument";
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        Element xmiExtension = ownerDocument.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
        xmiExtension.setAttribute("extender", "MagicDraw UML 16.9");
        xmiExtension.setAttribute("extenderID", "MagicDraw UML 16.9");
        Element modelExtension = ownerDocument.createElement("modelExtension");
        if (this.checkModule(this.parameter.getModule())) {
            modelExtension.setAttribute("parameter", this.parameter.getXmiID());
        } else {
            Element parameterElement = this.createModuleLink(this.parameter, "parameter", ownerDocument, xmiIDFactory);
            modelExtension.appendChild(parameterElement);
        }
        xmiExtension.appendChild(modelExtension);
        result.appendChild(xmiExtension);
        BridgeClass type = this.parameter.getTypeClass();
        if (type != null) {
            if (this.checkModule(type.getModule())) {
                result.setAttribute("type", type.getXmiID());
            } else {
                Element typeElement = this.createModuleLink(type, "type", ownerDocument, xmiIDFactory);
                result.appendChild(typeElement);
            }
        }
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    public boolean isInputPin() {
        return false;
    }

    public boolean isOutputPin() {
        return false;
    }
}

