/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.TypedElement;

public class LocalVariable
implements TypedElement {
    private String name;
    private BridgeClass type;
    private boolean isArray;
    private Helpers helpers;

    public LocalVariable(String name, BridgeClass type, boolean isArray, Helpers helpers) {
        this.name = name;
        this.type = type;
        this.isArray = isArray;
        this.helpers = helpers;
    }

    public LocalVariable(String name, TypedElement type) {
        this.name = name;
        this.isArray = type.isArray();
        try {
            this.type = this.isArray ? type.getArrayElementType() : type.getTypeClass();
        }
        catch (ArrayAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public BridgeClass getTypeClass() {
        return this.isArray() ? this.helpers.getElementHelper().findType("Base Types/Array") : this.type;
    }

    @Override
    public void setTypeClass(BridgeClass type) {
        this.type = type;
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        if (!this.isArray()) {
            throw new ArrayAccessException();
        }
        return this.type;
    }

    @Override
    public String getSignature() {
        String signature = this.getName() + (this.type == null ? " : [no type]" : this.type.getSignature());
        return this.isArray() ? signature + "[]" : signature;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

