/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeInstance;
import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ChildAddedEvent;
import ch.e2e.builder.compiler.uml.ChildListener;
import ch.e2e.builder.compiler.uml.ChildRemovedEvent;
import ch.e2e.builder.compiler.uml.ComponentDiagram;
import ch.e2e.builder.compiler.uml.DependencyClient;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DependencyList;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.LeftListElement;
import ch.e2e.builder.compiler.uml.NodeContainer;
import ch.e2e.builder.compiler.uml.NodeContainerDescription;
import ch.e2e.builder.compiler.uml.ServiceNotFoundException;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.event.EventController;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DeploymentDiagram
extends DeploymentElement
implements ChildListener {
    private NodeContainer backendNodes;
    private NodeContainer proxyNodes;
    private ArrayList<DeploymentElement> existingCompilables;
    private BridgeNodeInstance compilableNode;
    private BridgeInstance compilableObject;
    private HashMap<String, BridgeNodeInstance> nodeMap;
    private ComponentDiagram componentDiagram;

    public DeploymentDiagram(ArrayList<DeploymentElement> existingCompilables, NodeContainerDescription backendServerDescription, NodeContainerDescription proxyServerDescription, Helpers helpers) {
        super(helpers.getStereotypeFactory().getStereotype("DeploymentDiagram"), helpers);
        this.existingCompilables = existingCompilables;
        this.nodeMap = new HashMap();
        this.backendNodes = new NodeContainer(backendServerDescription, this, helpers);
        this.backendNodes.setChildListener(this);
        this.backendNodes.setSelectable(false);
        this.proxyNodes = new NodeContainer(proxyServerDescription, this, helpers);
        this.proxyNodes.setChildListener(this);
        this.proxyNodes.setSelectable(false);
        this.setChildListener(this);
    }

    public void prepareForImport() {
        if (this.getOwningPackage() == null) {
            BridgePackage deploymentPackage = this.getHelpers().getPackagesFactory().getInternalDeploymentDiagramPackage();
            BridgePackage diagramPackage = this.getHelpers().getPackagesFactory().getPackage(deploymentPackage, this.getName(), this.getHelpers().getStereotypeFactory().getStereotype("Deployment"));
            this.setOwningPackage(diagramPackage);
        }
        this.getOwningPackage().setPropertyValueQuietly("components", this.compilableObject == null ? "" : this.compilableObject.getClassifierArtifact().getXmiID());
        if (this.compilableNode != null) {
            this.addNode(this.compilableNode);
        }
        this.addNodes(this.backendNodes.getChildren());
        this.addNodes(this.proxyNodes.getChildren());
    }

    private void addNodes(List<UmlElement> nodes) {
        for (UmlElement umlElement : nodes) {
            this.addNode(umlElement);
        }
    }

    private void addNode(UmlElement umlElement) {
        BridgeNodeInstance node = this.nodeMap.get(umlElement.getName());
        if (node == null) {
            node = new BridgeNodeInstance(umlElement.getStereotype(), this.getHelpers());
            node.setName(umlElement.getName());
            node.setParent(this);
            node.setClassifier(((BridgeNodeInstance)umlElement).getClassifier());
            this.nodeMap.put(umlElement.getName(), node);
        } else {
            node.addStereotype(umlElement.getStereotype());
        }
        for (UmlElement child : umlElement.getChildren()) {
            node.addChild(child);
        }
    }

    public ArrayList<UmlElement> getNodes(BridgeStereotype stereotype) {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (UmlElement umlElement : this.nodeMap.values()) {
            if (!umlElement.getStereotype().equals(stereotype)) continue;
            result.add(umlElement);
        }
        return result;
    }

    public ArrayList<UmlElement> getAllNodes() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (UmlElement umlElement : this.nodeMap.values()) {
            if (result.contains(umlElement)) continue;
            result.add(umlElement);
        }
        return result;
    }

    public ArrayList<DeploymentElement> getExistingCompilables() {
        return this.existingCompilables;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public boolean canSkip() {
        return false;
    }

    @Override
    public void childAdded(ChildAddedEvent event) {
        this.checkSelectable();
        EventController.fire((EventObject)event);
    }

    private void findComponentDiagram() {
        if (this.componentDiagram == null) {
            this.componentDiagram = this.getHelpers().getElementHelper().findDefiningComponentDiagram(this.compilableObject.getClassifierArtifact());
        }
    }

    public void setComponentDiagram(ComponentDiagram componentDiagram) {
        this.componentDiagram = componentDiagram;
    }

    @Override
    public void childRemoved(ChildRemovedEvent event) {
        BridgeInstance child;
        if (event.getChild() instanceof BridgeInstance && (child = (BridgeInstance)event.getChild()).getClassifierArtifact().getStereotype().equals(this.getHelpers().getStereotypeFactory().getStereotype("E2ECompositeDeployment"))) {
            this.compilableObject = null;
            this.componentDiagram = null;
        }
        this.checkSelectable();
        EventController.fire((EventObject)event);
    }

    public BridgeInstance getCompilableObject() {
        return this.compilableObject;
    }

    public void setCompilableObject(BridgeInstance compilableObject) {
        this.componentDiagram = null;
        this.internalSetCompilableObject(compilableObject);
        compilableObject.setParent(this);
        if (compilableObject.getClassifierArtifact().getStereotype().getName().equals("E2ELibraryDeployment")) {
            this.childAdded(new ChildAddedEvent(this, compilableObject));
        }
    }

    public NodeContainer getBackendNodes() {
        return this.backendNodes;
    }

    public NodeContainer getProxyNodes() {
        return this.proxyNodes;
    }

    protected ArrayList<UmlElement> findAllChildren() {
        return new ArrayList<UmlElement>();
    }

    @Override
    public String getBaseclass() {
        return "DeploymentDiagram";
    }

    @Override
    public UmlElement getChild(int index) {
        DeploymentElement result = null;
        switch (index) {
            case 0: {
                if (this.compilableNode == null) {
                    result = this.compilableObject;
                    break;
                }
                result = this.compilableNode;
                break;
            }
            case 1: {
                result = this.backendNodes.isSelectable() ? this.backendNodes : this.proxyNodes;
                break;
            }
            case 2: {
                result = this.proxyNodes;
            }
        }
        return result;
    }

    @Override
    public int getChildCount() {
        int result = this.compilableObject == null ? 0 : (this.compilableNode == null ? (this.compilableObject.getClassifierArtifact().getStereotype().getName().equals("E2ELibraryDeployment") ? (this.backendNodes.isSelectable() ? 2 : 1) : 0) : (this.backendNodes.isSelectable() ^ this.proxyNodes.isSelectable() ? 2 : (this.backendNodes.isSelectable() && this.proxyNodes.isSelectable() ? 3 : 1)));
        return result;
    }

    @Override
    public int getIndexOfChild(Object child) {
        int result = child.equals(this.compilableNode) ? 0 : (child.equals(this.backendNodes) ? 1 : 2);
        return result;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public ArrayList<? extends LeftListElement> getExistingNodes() {
        ArrayList<LeftListElement> result = new ArrayList<LeftListElement>();
        ArrayList<String> nodeNames = new ArrayList<String>();
        if (this.compilableNode != null) {
            this.addNode(this.compilableNode, result, nodeNames);
        }
        this.addNodes(this.backendNodes, result, nodeNames);
        this.addNodes(this.proxyNodes, result, nodeNames);
        return result;
    }

    public ArrayList<UmlElement> getAllConfigurations() {
        return new ArrayList<UmlElement>(this.componentDiagram.getCustomizedDeployables().getChildren());
    }

    public ArrayList<UmlElement> getAllBackendServices() throws ServiceNotFoundException {
        return this.getAllBackendServices(this.compilableObject.getClassifierArtifact());
    }

    public ArrayList<UmlElement> getAllBackendServices(DeploymentElement compilableObject) throws ServiceNotFoundException {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        ArrayList<BridgeDependency> dependencies = new ArrayList<BridgeDependency>();
        this.addBridgeDependencies(compilableObject, dependencies);
        for (BridgeDependency dependency : dependencies) {
            ArrayList<BridgeStereotype> nodeTypes = ((DependencyCustomization)dependency.getStereotype().getCustomization()).getSupplierNodeTypes();
            if (!nodeTypes.contains(this.backendNodes.getStereotype())) continue;
            this.addBackendService(dependency.getSupplier(), result, this.backendNodes.getStereotype());
        }
        return result;
    }

    public BridgeNodeInstance getCompilableNode() {
        return this.compilableNode;
    }

    public void setCompilableNode(BridgeNodeInstance compilableNode) {
        BridgeNodeInstance oldNode = this.compilableNode;
        this.compilableNode = compilableNode;
        if (compilableNode == null) {
            if (this.getChildListener() != null) {
                this.getChildListener().childRemoved(new ChildRemovedEvent(this, oldNode, this));
            }
        } else {
            compilableNode.addChild(this.compilableObject);
            compilableNode.setParent(this);
            this.childAdded(new ChildAddedEvent(this, compilableNode));
        }
    }

    public void setCompleteCompilableNode(BridgeNodeInstance compilableNode) {
        this.compilableNode = compilableNode;
        Iterator<UmlElement> allChildren = compilableNode.getAllChildren().iterator();
        while (allChildren.hasNext() && this.compilableObject == null) {
            BridgeInstance child = (BridgeInstance)allChildren.next();
            DeploymentElement artifact = child.getClassifierArtifact();
            if (!artifact.getStereotype().getName().equals("E2ECompositeDeployment") && !artifact.getStereotype().getName().equals("E2ELibraryDeployment")) continue;
            this.internalSetCompilableObject(child);
            this.checkSelectable();
        }
    }

    private void internalSetCompilableObject(BridgeInstance compilableObject) {
        if (this.compilableNode != null) {
            this.compilableNode.removeChild(this.compilableObject);
            if (compilableObject.getClassifierArtifact().getStereotype().getName().equals("E2ELibraryDeployment")) {
                this.compilableNode.setParent(null);
                this.compilableNode = null;
            } else {
                this.compilableNode.addChild(compilableObject);
            }
        }
        this.compilableObject = compilableObject;
        compilableObject.setSelectable(true);
        this.findComponentDiagram();
    }

    private void addBridgeDependencies(DeploymentElement dependencyClient, ArrayList<BridgeDependency> bridgeDependencies) {
        DependencyList dependencies = dependencyClient.getBridgeDependencies();
        for (BridgeDependency dependency : dependencies) {
            if (dependency.getStereotype().getName().equals("E2ELibraryDependency")) continue;
            bridgeDependencies.add(dependency);
        }
        for (UmlElement child : dependencyClient.getChildren()) {
            this.addBridgeDependencies((DeploymentElement)child, bridgeDependencies);
        }
    }

    private void addBackendService(UmlElement supplier, ArrayList<UmlElement> backendServices, BridgeStereotype nodeType) throws ServiceNotFoundException {
        UmlElement backendService = null;
        for (UmlElement parent = supplier; parent != null && backendService == null; parent = parent.getParent()) {
            if (parent.getStereotype() == null || !nodeType.getCustomization().getChildren().contains(parent.getStereotype().getClassifierType())) continue;
            backendService = parent;
        }
        if (backendService == null) {
            throw new ServiceNotFoundException(supplier);
        }
        if (!backendServices.contains(backendService)) {
            backendServices.add(backendService);
        }
    }

    public ArrayList<UmlElement> getAllProxyServices() {
        return new ArrayList<UmlElement>(this.componentDiagram.getCustomizedProxyServices().getChildren());
    }

    private void addNodes(NodeContainer nodes, ArrayList<LeftListElement> result, ArrayList<String> nodeNames) {
        for (UmlElement umlElement : nodes.getChildren()) {
            this.addNode(umlElement, result, nodeNames);
        }
    }

    private void addNode(UmlElement umlElement, ArrayList<LeftListElement> result, ArrayList<String> nodeNames) {
        if (!nodeNames.contains(umlElement.getName())) {
            nodeNames.add(umlElement.getName());
            result.add(umlElement);
        }
    }

    private void checkSelectable() {
        int backendDependencies = 0;
        int proxyDependencies = 0;
        if (this.componentDiagram != null) {
            TreeSet<DependencyClient> dependencyClients = this.componentDiagram.getDependencyClients().getDependencyClients();
            ArrayList<BridgeDependency> dependencies = new ArrayList<BridgeDependency>();
            for (DependencyClient client : dependencyClients) {
                dependencies.addAll(client.getBridgeDependencies());
                BridgeStereotype type = client.getStereotype().getClassifierType();
                if (this.backendNodes.getStereotype().getCustomization().getChildren().contains(type)) {
                    ++backendDependencies;
                    continue;
                }
                if (!this.proxyNodes.getStereotype().getCustomization().getChildren().contains(type)) continue;
                ++proxyDependencies;
            }
            for (BridgeDependency dependency : dependencies) {
                if (dependency.getStereotype() == null) continue;
                ArrayList<BridgeStereotype> nodeTypes = ((DependencyCustomization)dependency.getStereotype().getCustomization()).getSupplierNodeTypes();
                if (nodeTypes.contains(this.backendNodes.getStereotype())) {
                    ++backendDependencies;
                    continue;
                }
                if (!nodeTypes.contains(this.proxyNodes.getStereotype())) continue;
                ++proxyDependencies;
            }
        }
        if (this.compilableObject != null && this.compilableObject.getClassifierArtifact().getStereotype().getName().equals("E2ELibraryDeployment")) {
            this.backendNodes.setSelectable(this.backendNodes.getChildCount() > 0 && backendDependencies > 0);
        } else {
            this.backendNodes.setSelectable(backendDependencies > 0);
            this.proxyNodes.setSelectable(proxyDependencies > 0);
        }
    }
}

