/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.UmlElement;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeDependency
extends DeploymentElement {
    private UmlElement client;
    private UmlElement supplier;
    private boolean useClientPackage = false;

    public BridgeDependency(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
    }

    public BridgeDependency(BridgeStereotype stereotype, Helpers helpers) {
        super("", new Comment("", helpers), stereotype, helpers);
        if (stereotype == null) {
            this.setBaseclass("Dependency");
        }
    }

    public UmlElement getClient() {
        return this.client;
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getElementHelper().createDependency(this);
    }

    public void setClient(UmlElement client) {
        this.client = client;
    }

    public UmlElement getSupplier() {
        return this.supplier;
    }

    public void setSupplier(UmlElement supplier) {
        this.supplier = supplier;
    }

    @Override
    public String toDisplayText() {
        String result;
        block2: {
            try {
                result = this.getProperty("alias").getValue().toString();
            }
            catch (NoSuchPropertyException e) {
                result = super.toString();
                if (result.trim().length() != 0) break block2;
                result = this.supplier == null ? "&lt;&lt;" + this.getStereotype().getName() + "&gt;&gt;" : "&lt;&lt;" + this.getStereotype().getName() + "&gt;&gt;" + this.supplier.getName();
            }
        }
        return result;
    }

    @Override
    public Icon getIcon() {
        Icon result;
        try {
            DeploymentElement alias = (DeploymentElement)this.getProperty("alias").getValue();
            result = alias.getIcon();
        }
        catch (NoSuchPropertyException e) {
            result = super.getIcon();
        }
        return result;
    }

    @Override
    public String toString() {
        String result;
        block2: {
            try {
                result = this.getProperty("alias").getValue().toString();
            }
            catch (NoSuchPropertyException e) {
                result = super.toString();
                if (result.trim().length() != 0) break block2;
                String stereotype = this.getStereotype() == null ? "UNTYPED" : this.getStereotype().getName();
                result = this.supplier == null ? "<<" + stereotype + ">>" : "<<" + stereotype + ">>" + this.supplier.getName();
            }
        }
        return result;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element client;
        Element supplier;
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        if (this.checkModule(this.supplier.getModule())) {
            supplier = ownerDocument.createElement("supplier");
            supplier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.supplier.getXmiID());
        } else {
            supplier = this.createModuleLink(this.supplier, "supplier", ownerDocument, xmiIDFactory);
        }
        result.appendChild(supplier);
        if (this.checkModule(this.client.getModule())) {
            client = ownerDocument.createElement("client");
            client.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.client.getXmiID());
        } else {
            client = this.createModuleLink(this.client, "client", ownerDocument, xmiIDFactory);
        }
        result.appendChild(client);
        return result;
    }

    public boolean isSupplierOnNodeTypeAllowed(BridgeStereotype nodeType) {
        return ((DependencyCustomization)this.getStereotype().getCustomization()).getSupplierNodeTypes().contains(nodeType);
    }

    public boolean hasAlias(DeploymentElement alias) {
        boolean result;
        try {
            result = this.getProperty("alias").getValue().equals(alias);
        }
        catch (NoSuchPropertyException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return this.getStereotype().getCustomizationProperty("multipleInstancesAllowed") != null && (Boolean)this.getStereotype().getCustomizationProperty("multipleInstancesAllowed") != false;
    }

    @Override
    public BridgePackage getOwningPackage() {
        BridgePackage result = super.getOwningPackage();
        if (result == null && this.getStereotype() == null) {
            result = this.useClientPackage ? (this.client == null ? null : this.client.getOwningPackage()) : (this.supplier == null ? null : this.supplier.getOwningPackage());
        }
        return result;
    }

    public void setUseClientPackage(boolean useClientPackage) {
        this.useClientPackage = useClientPackage;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof BridgeDependency) {
            UmlElement objClient = ((BridgeDependency)obj).client;
            UmlElement objSupplier = ((BridgeDependency)obj).supplier;
            result = (objClient == null && this.client == null || objClient != null && objClient.equals(this.client)) && (objSupplier == null && this.supplier == null || objSupplier != null && objSupplier.equals(this.supplier));
        }
        return result;
    }

    @Override
    protected void addClassifierDependency(Document ownerDocument, Element xmiElement, XmiIDFactory xmiIDFactory) {
    }
}

