/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.resource.ImageLoader;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ArtifactList
extends DeploymentElement {
    private static final int TYPE_OFFSET = 150000;
    public static final int CONFIGURATION_DELOYMENTS = 150000;
    public static final int BACKEND_SERVICE_DEPLOYMENTS = 150001;
    public static final int PROXY_SERVICE_DEPLOYMENTS = 150002;
    private boolean selectable;
    private int treeType;

    public ArtifactList(ClassifierElement classifier, int treeType, UmlElement parent, String name, Helpers helpers) {
        super(name, classifier, helpers);
        this.setParent(parent);
        this.treeType = treeType;
    }

    private ArtifactList(Helpers helpers) {
        super("empty", new Comment("empty", helpers), helpers);
    }

    @Override
    public int getType() {
        return this.treeType;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ArtifactList) {
            result = this.equals((ArtifactList)o);
        }
        return result;
    }

    @Override
    public Icon getIcon() {
        ImageIcon result = null;
        switch (this.treeType) {
            case 150001: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.backendservices.icon.gif", (boolean)true);
                break;
            }
            case 150000: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/ui.deployment.icon.gif", (boolean)true);
                break;
            }
            case 150002: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.proxyservices.icon.gif", (boolean)true);
            }
        }
        return result;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public boolean isChildRequired() {
        boolean result = this.treeType == 150000 ? super.isChildRequired() : false;
        return result;
    }

    public DeploymentElement findArtifact(UmlElement classifier) {
        DeploymentElement result = null;
        int length = this.getChildren().size();
        for (int i = 0; i < length && result == null; ++i) {
            DeploymentElement child = (DeploymentElement)this.getChildren().get(i);
            if (!child.getClassifier().equals(classifier)) continue;
            result = child;
        }
        return result;
    }

    private boolean equals(ArtifactList other) {
        return other.treeType == this.treeType && other.getName().equals(this.getName());
    }

    public static class EmptyArtifactList
    extends ArtifactList {
        public EmptyArtifactList(Helpers helpers) {
            super(helpers);
        }
    }
}

