/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.execute;

import ch.e2e.builder.compiler.build.types.AbstractBreakpoint;
import ch.e2e.builder.compiler.build.types.Breakpoint;
import ch.e2e.builder.compiler.build.types.ExceptionBreakpoint;
import ch.e2e.builder.compiler.execute.DebuggerRequestEvent;
import ch.e2e.builder.compiler.execute.DebuggerRequestFailedEvent;
import ch.e2e.builder.compiler.execute.DebuggerRequestListener;
import ch.e2e.builder.compiler.execute.DebuggerRequestRejectedEvent;
import ch.e2e.builder.compiler.execute.DebuggerResponse;
import ch.e2e.builder.compiler.execute.DebuggerResponseEvent;
import ch.e2e.builder.compiler.execute.Logging;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.net.NetworkTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DebuggerRequest
implements Logging {
    private static final HashMap<String, String> REQUEST_PROPERTIES = new HashMap();
    private static final int HTTP_READ_TIMEOUT = 5000;
    private static final int HTTP_NO_READ_TIMEOUT = -1;
    private final EventListenerList listeners = new EventListenerList();
    private final Document request;
    private final boolean returnsImmediately;

    public static DebuggerRequest newSwitchOnRequest() {
        return new DebuggerRequest("SwitchOn", true);
    }

    public static DebuggerRequest newSwitchOffRequest() {
        return new DebuggerRequest("SwitchOff", true);
    }

    public static DebuggerRequest newStatusRequest() {
        return new DebuggerRequest("Status", true);
    }

    public static DebuggerRequest newAddBreakpointRequest(AbstractBreakpoint breakpoint) {
        if (breakpoint instanceof Breakpoint) {
            return DebuggerRequest.newAddBreakpointRequest((Breakpoint)breakpoint);
        }
        return DebuggerRequest.newAddBreakpointRequest((ExceptionBreakpoint)breakpoint);
    }

    public static DebuggerRequest newRemoveBreakpointRequest(AbstractBreakpoint breakpoint) {
        if (breakpoint instanceof Breakpoint) {
            return DebuggerRequest.newRemoveBreakpointRequest((Breakpoint)breakpoint);
        }
        return DebuggerRequest.newRemoveBreakpointRequest((ExceptionBreakpoint)breakpoint);
    }

    public static DebuggerRequest newAddBreakpointRequest(Breakpoint breakpoint) {
        DebuggerRequest r = new DebuggerRequest(true);
        Document d = r.getRequest();
        Element element = d.createElement("AddBreakpoint");
        element.setTextContent(breakpoint.getId());
        d.getDocumentElement().appendChild(element);
        return r;
    }

    public static DebuggerRequest newRemoveBreakpointRequest(Breakpoint breakpoint) {
        DebuggerRequest r = new DebuggerRequest(true);
        Document d = r.getRequest();
        Element element = d.createElement("RemoveBreakpoint");
        element.setTextContent(breakpoint.getId());
        d.getDocumentElement().appendChild(element);
        return r;
    }

    public static DebuggerRequest newGetBreakpointsRequest() {
        return new DebuggerRequest("GetBreakpoints", true);
    }

    public static DebuggerRequest newClearBreakpointsRequest() {
        return new DebuggerRequest("ClearBreakpoints", true);
    }

    public static DebuggerRequest newNextBreakpointRequest() {
        return new DebuggerRequest("NextBreakpoint", false);
    }

    public static DebuggerRequest newStepOverRequest() {
        return new DebuggerRequest("GoOver", false);
    }

    public static DebuggerRequest newStepIntoRequest() {
        return new DebuggerRequest("NextStep", false);
    }

    public static DebuggerRequest newGoUpRequest() {
        return new DebuggerRequest("GoUp", false);
    }

    public static DebuggerRequest newCancelRequest() {
        return new DebuggerRequest("Cancel", true);
    }

    public static DebuggerRequest newAddBreakpointRequest(ExceptionBreakpoint breakpoint) {
        DebuggerRequest r = new DebuggerRequest(true);
        Document d = r.getRequest();
        Element element = d.createElement("AddException");
        element.setAttribute("domain", breakpoint.getDomain());
        element.setAttribute("code", breakpoint.getCode());
        d.getDocumentElement().appendChild(element);
        return r;
    }

    public static DebuggerRequest newRemoveBreakpointRequest(ExceptionBreakpoint breakpoint) {
        DebuggerRequest r = new DebuggerRequest(true);
        Document d = r.getRequest();
        Element element = d.createElement("RemoveException");
        element.setAttribute("domain", breakpoint.getDomain());
        element.setAttribute("code", breakpoint.getCode());
        d.getDocumentElement().appendChild(element);
        return r;
    }

    public static DebuggerRequest newGetExceptionBreakpointsRequest() {
        return new DebuggerRequest("GetExceptions", true);
    }

    public static DebuggerRequest newClearExceptionBreakpointsRequest() {
        return new DebuggerRequest("ClearExceptions", true);
    }

    public static boolean isRequestAccepted(DebuggerResponse response) {
        return DebuggerRequest.isRequestAccepted(response.getResponseDocument());
    }

    public static boolean isRequestAccepted(Document response) {
        if (response == null) {
            throw new IllegalArgumentException("Argument 'response' must not be null");
        }
        return response.getDocumentElement().getElementsByTagName("Accepted").getLength() == 1;
    }

    public static boolean isInDebugMode(DebuggerResponse response) {
        return DebuggerRequest.isInDebugMode(response.getResponseDocument());
    }

    public static boolean isInDebugMode(Document response) {
        if (response == null) {
            throw new IllegalArgumentException("Argument 'response' must not be null");
        }
        return "On".equals(DomUtilities.getTextValue((Element)response.getDocumentElement(), (String)"Status", (String)"Off"));
    }

    public static boolean isCanceled(DebuggerResponse response) {
        return DebuggerRequest.isCanceled(response.getResponseDocument());
    }

    public static boolean isCanceled(Document response) {
        if (response == null) {
            throw new IllegalArgumentException("Argument 'response' must not be null");
        }
        Object node = null;
        try {
            node = DomUtilities.selectNode((Node)response, (String)"//Canceled");
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return node != null;
    }

    public static boolean isRunFinished(DebuggerResponse response) {
        return DebuggerRequest.isRunFinished(response.getResponseDocument());
    }

    public static boolean isRunFinished(Document response) {
        if (response == null) {
            throw new IllegalArgumentException("Argument 'response' must not be null");
        }
        boolean finished = false;
        try {
            finished = DomUtilities.selectNode((Node)response, (String)"bla") != null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return finished;
    }

    public boolean returnsImmediately() {
        return this.returnsImmediately;
    }

    public DebuggerResponse sendRequest(URL requestUrl) throws IOException {
        DebuggerResponse response = null;
        if (Boolean.parseBoolean(System.getProperty("ch.e2e.builder.development"))) {
            String msg = "Sending '" + DomUtilities.show((Node)this.request) + "' to " + requestUrl;
            logger.info(msg);
        }
        if (this.returnsImmediately()) {
            response = this.sendSynchronousRequest(requestUrl);
        } else {
            this.sendAsynchronousRequest(requestUrl);
        }
        return response;
    }

    private DebuggerResponse sendSynchronousRequest(URL requestUrl) throws IOException {
        DebuggerResponse response;
        this.fireSendingRequest(requestUrl);
        try {
            byte[] bytes = DomUtilities.show((Node)this.getRequest(), (boolean)false).getBytes("utf-8");
            response = this.sendRequest(requestUrl, bytes);
            this.fireResponseRecieved(response, requestUrl);
        }
        catch (IOException e) {
            if (Boolean.parseBoolean(System.getProperty("ch.e2e.builder.development"))) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                logger.info(writer.toString());
            }
            this.fireRequestFailed(e, requestUrl);
            throw e;
        }
        return response;
    }

    private void sendAsynchronousRequest(URL requestUrl) {
        new DebuggerRequestTask(this, requestUrl).execute();
    }

    private DebuggerResponse sendRequest(URL requestUrl, byte[] bytes) throws IOException {
        try {
            return new DebuggerResponse(NetworkTools.httpRequest((URL)requestUrl, (NetworkTools.RequestMethod)NetworkTools.RequestMethod.POST, REQUEST_PROPERTIES, (byte[])bytes, (int)this.getReadTimeout()));
        }
        catch (SocketTimeoutException e) {
            logger.severe("Debugger request timed out: " + requestUrl + ": " + DomUtilities.show((Node)this.request));
            throw e;
        }
    }

    public EventListenerList getListeners() {
        return this.listeners;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t) {
        return this.getListeners().getListeners(t);
    }

    public DebuggerRequestListener[] getDebuggerRequestListeners() {
        return (DebuggerRequestListener[])this.getListeners(DebuggerRequestListener.class);
    }

    public void addDebuggerRequestListener(DebuggerRequestListener listener) {
        this.listeners.add(DebuggerRequestListener.class, listener);
    }

    public void removeDebuggerRequestListener(DebuggerRequestListener listener) {
        this.listeners.remove(DebuggerRequestListener.class, listener);
    }

    protected void fireSendingRequest(URL requetsUrl) {
        DebuggerRequestEvent event = null;
        for (DebuggerRequestListener listener : this.getDebuggerRequestListeners()) {
            if (event == null) {
                event = new DebuggerRequestEvent(this, requetsUrl);
            }
            listener.sendingRequest(event);
        }
    }

    protected void fireResponseRecieved(DebuggerResponse response, URL requetsUrl) {
        DebuggerResponseEvent event = null;
        for (DebuggerRequestListener listener : this.getDebuggerRequestListeners()) {
            if (event == null) {
                event = new DebuggerResponseEvent(this, response, requetsUrl);
            }
            listener.responseRecieved(event);
        }
    }

    public void fireRequestFailed(Exception exception, URL requetsUrl) {
        DebuggerRequestFailedEvent event = null;
        for (DebuggerRequestListener listener : this.getDebuggerRequestListeners()) {
            if (event == null) {
                event = new DebuggerRequestFailedEvent(this, exception, requetsUrl);
            }
            listener.requestFailed(event);
        }
    }

    public String getName() {
        return this.request.getDocumentElement().getFirstChild().getNodeName();
    }

    protected Document getRequest() {
        return this.request;
    }

    private int getReadTimeout() {
        return this.returnsImmediately ? 5000 : -1;
    }

    protected DebuggerRequest(String action, boolean returnsImmediately) {
        this(returnsImmediately);
        Element element = this.request.createElement(action);
        this.request.getDocumentElement().appendChild(element);
    }

    protected DebuggerRequest(boolean returnsImmediately) {
        this.returnsImmediately = returnsImmediately;
        this.request = DomUtilities.newDocument((String)"Debugger");
    }

    static {
        REQUEST_PROPERTIES.put("Content-Type", "text/xml;charset=utf-8");
    }

    public static class DebuggerRequestTask
    extends FutureTask<DebuggerResponse> {
        private static final Map<URL, ExecutorService> executorServices = new HashMap<URL, ExecutorService>();
        private final DebuggerRequest request;
        private final URL url;

        public DebuggerRequestTask(DebuggerRequest request, URL url) {
            super(DebuggerRequestTask.newCallable(request, url));
            this.request = request;
            this.url = url;
        }

        private static Callable<DebuggerResponse> newCallable(final DebuggerRequest request, final URL url) {
            return new Callable<DebuggerResponse>(){

                @Override
                public DebuggerResponse call() throws Exception {
                    byte[] bytes = DomUtilities.show((Node)request.getRequest(), (boolean)false).getBytes("utf-8");
                    return request.sendRequest(url, bytes);
                }
            };
        }

        public void execute() {
            try {
                this.request.fireSendingRequest(this.url);
                this.getExecutorService().execute(this);
            }
            catch (RejectedExecutionException e) {
                EventController.fire((EventObject)new DebuggerRequestRejectedEvent(this.request, this.url));
            }
        }

        private void doDone() {
            if (!this.isCancelled()) {
                try {
                    DebuggerResponse response = (DebuggerResponse)this.get();
                    this.request.fireResponseRecieved(response, this.url);
                }
                catch (Exception e) {
                    if (Boolean.parseBoolean(System.getProperty("ch.e2e.builder.development"))) {
                        e.printStackTrace();
                    }
                    this.request.fireRequestFailed(e, this.url);
                }
            }
        }

        @Override
        protected void done() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doDone();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.doDone();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExecutorService getExecutorService() {
            ExecutorService executorService = executorServices.get(this.url);
            if (executorService == null) {
                Map<URL, ExecutorService> map = executorServices;
                synchronized (map) {
                    executorService = executorServices.get(this.url);
                    if (executorService == null) {
                        executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
                        executorServices.put(this.url, executorService);
                    }
                }
            }
            return executorService;
        }
    }
}

