/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.JavaTypeNotSupportedException;
import ch.e2e.builder.compiler.document.importer.java.Logging;
import ch.e2e.builder.compiler.document.importer.java.Operation;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.document.importer.java.UserAbortedClassSearchException;
import ch.e2e.builder.compiler.uml.Helpers;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaService
extends JavaClass {
    public JavaService(Class clazz, Helpers helpers) {
        super(clazz, helpers.getStereotypeFactory().getStereotype("JavaCallbackService"), helpers);
    }

    protected void findAttributes(Class clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
    }

    protected void findOperations(Class clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        try {
            Method[] methods = clazz.getDeclaredMethods();
            if (this.hasPublicDefaultConstructor()) {
                for (Method method : methods) {
                    if (Modifier.isPublic(method.getModifiers()) && method.getName().equals("initialize") && method.getParameterTypes().length == 1 && TypeInfo.isJavaCallback(method.getParameterTypes()[0])) {
                        try {
                            this.addOperation(new Operation(method, this.getName(), classLoader, this.getHelpers()));
                        }
                        catch (JavaTypeNotSupportedException e) {
                            XSLTErrorHandler.getInstance().error((Throwable)e);
                            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        continue;
                    }
                    if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
                    try {
                        this.addOperation(new Operation(method, this.getName(), classLoader, this.getHelpers()));
                    }
                    catch (JavaTypeNotSupportedException e) {
                        XSLTErrorHandler.getInstance().error((Throwable)e);
                        Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if (classLoader.getAbortException() != null) {
                throw classLoader.getAbortException();
            }
            Logging.logger.warning("Could not load one or more parameter class of a operation in class '" + this.getFullName() + "'.");
        }
        catch (Throwable e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

