/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ImporterJarfile;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassLoaderJarfile
extends ImporterJarfile {
    private static final String[] JAVADOC_PATH_PREFIXES = new String[]{"javadoc", "doc"};
    private static HashMap<String, ClassLoaderJarfile> jarfiles = new HashMap();
    private HashMap<String, String> classnames = new HashMap();
    private HashMap<String, String> internalClassnames = new HashMap();
    private ZipFile jarfile;

    protected ClassLoaderJarfile(File originalFile) throws IOException {
        super(originalFile);
        this.init(originalFile);
    }

    protected void init(File originalFile) throws IOException {
        this.jarfile = new ZipFile(originalFile);
        Enumeration<? extends ZipEntry> entries = this.jarfile.entries();
        while (entries.hasMoreElements()) {
            String classname;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(classname = entry.getName()).endsWith(".class")) continue;
            classname = classname.substring(0, classname.length() - 6);
            classname = classname.replace('\\', '.');
            if ((classname = classname.replace('/', '.')).indexOf(36) == -1) {
                this.classnames.put(classname, entry.getName());
                continue;
            }
            this.internalClassnames.put(classname, entry.getName());
        }
    }

    public static ClassLoaderJarfile getJarfile(File originalFile) throws IOException {
        String absolutePath = FileUtilities.getAbsolutePath((File)originalFile);
        ClassLoaderJarfile jarfile = jarfiles.get(absolutePath);
        if (jarfile == null) {
            jarfile = new ClassLoaderJarfile(originalFile);
            jarfiles.put(absolutePath, jarfile);
        }
        return jarfile;
    }

    public Reader getJavaDocReader(String classname) {
        InputStreamReader reader = null;
        String entryName = this.classnames.get(classname);
        if (entryName != null) {
            for (String prefix : JAVADOC_PATH_PREFIXES) {
                String javaDocEntryName = prefix + "/" + entryName.replaceFirst("\\Qclass\\E$", "html");
                try {
                    InputStream inputStream = this.jarfile.getInputStream(new ZipEntry(javaDocEntryName));
                    if (inputStream == null) continue;
                    reader = new InputStreamReader(inputStream);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return reader;
    }

    public InputStream getClassInputStream(String classname) throws IOException {
        InputStream result = null;
        if (this.classnames.containsKey(classname)) {
            String entryName = this.classnames.get(classname);
            result = this.jarfile.getInputStream(new ZipEntry(entryName));
        } else if (this.internalClassnames.containsKey(classname)) {
            String entryName = this.internalClassnames.get(classname);
            result = this.jarfile.getInputStream(new ZipEntry(entryName));
        }
        return result;
    }

    public boolean containsClass(String classname) {
        return this.classnames.containsKey(classname);
    }

    public String[] getClassnames() {
        String[] classes = new String[this.classnames.size()];
        this.classnames.keySet().toArray(classes);
        return classes;
    }

    public void close() throws IOException {
        this.jarfile.close();
        jarfiles.remove(FileUtilities.getAbsolutePath((File)this.getOriginalFile()));
    }
}

