/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.Attribute;
import ch.e2e.builder.compiler.document.importer.idoc.Field;
import ch.e2e.builder.compiler.document.importer.idoc.Group;
import ch.e2e.builder.compiler.document.importer.idoc.IDoc;
import ch.e2e.builder.compiler.document.importer.idoc.IDocContainerObject;
import ch.e2e.builder.compiler.document.importer.idoc.IDocObject;
import ch.e2e.builder.compiler.document.importer.idoc.Segment;
import ch.e2e.builder.compiler.document.importer.idoc.StringConstants;
import ch.e2e.builder.compiler.document.importer.idoc.TypeMapper;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.Logging;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaBuilder
implements Logging,
StringConstants {
    private static final String DCS_BASE = "ch/e2e/builder/compiler/xml/dcs_v";
    private static final String DCS_EXT = ".emd";

    public static Document buildSchema(IDoc idoc, int version) {
        Document document = DomUtilities.newDocument((String)"e2emetadata");
        Element root = document.getDocumentElement();
        Element packageElement = document.createElement("package");
        packageElement.setAttribute("name", idoc.getPackageName());
        root.appendChild(packageElement);
        Node dcsFrag = SchemaBuilder.getDataControlSchema(document, version);
        packageElement.appendChild(dcsFrag);
        Element clazz = SchemaBuilder.appendClassElement(idoc, packageElement, document);
        String controlRecordName = version == 3 ? "EDI_DC" : "EDI_DC40";
        root.setAttribute("targetNamespace", idoc.getPackageName());
        Element parent = document.createElement("parent");
        parent.setAttribute("name", controlRecordName);
        clazz.appendChild(parent);
        return document;
    }

    private static void appendChildren(IDocContainerObject container, Element clazz, Element packageElement, Document document) {
        Element attributes = document.createElement("attributes");
        Element elements = document.createElement("elements");
        ArrayList<IDocObject> children = container.getChildren();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            IDocObject child = children.get(i);
            if (child instanceof Segment || child instanceof Group) {
                SchemaBuilder.appendComplexType((IDocContainerObject)child, elements, i + 1, document);
                SchemaBuilder.appendClassElement((IDocContainerObject)child, packageElement, document);
                continue;
            }
            if (child instanceof Attribute) {
                SchemaBuilder.appendAttribute((Attribute)child, attributes, document);
                continue;
            }
            if (!(child instanceof Field)) continue;
            SchemaBuilder.appendFieldElement((Field)child, attributes, i + 1, document);
        }
        if (attributes.getChildNodes().getLength() > 0) {
            clazz.appendChild(attributes);
        }
        if (elements.getChildNodes().getLength() > 0) {
            clazz.appendChild(elements);
        }
    }

    private static void appendComplexType(IDocContainerObject container, Element parent, int order, Document document) {
        Element complexType = document.createElement("complexType");
        complexType.setAttribute("name", container.getName());
        complexType.setAttribute("type", container.getName());
        complexType.setAttribute("isReference", "false");
        complexType.setAttribute("form", "qualified");
        complexType.setAttribute("ordered", "true");
        complexType.setAttribute("stereotypeID", "XMLElement");
        complexType.setAttribute("order", String.valueOf(order));
        complexType.setAttribute("minOccurs", String.valueOf(container.getMinOccurs()));
        complexType.setAttribute("maxOccurs", String.valueOf(container.getMaxOccurs()));
        Element applicationInfo = document.createElement("applicationInfo");
        complexType.appendChild(applicationInfo);
        SchemaBuilder.appendTaggedValue("externalName", container.getType().replace("/", "_-"), applicationInfo, document);
        parent.appendChild(complexType);
    }

    private static Element appendClassElement(IDocContainerObject container, Element parent, Document document) {
        Element clazz = document.createElement("class");
        clazz.setAttribute("className", container.getName());
        clazz.setAttribute("isOrdered", "true");
        clazz.setAttribute("isMixed", "false");
        SchemaBuilder.appendApplicationInfo(container, clazz, document);
        parent.appendChild(clazz);
        SchemaBuilder.appendChildren(container, clazz, parent, document);
        SchemaBuilder.appendDocumentation(container.getDocumentation(), clazz, document);
        return clazz;
    }

    private static void appendAttribute(Attribute attribute, Element parent, Document document) {
        Element attr = document.createElement("simpleType");
        attr.setAttribute("name", attribute.getName());
        attr.setAttribute("default", attribute.getDefaultValue());
        attr.setAttribute("type", attribute.getType());
        attr.setAttribute("namespace", "http://www.w3.org/2001/XMLSchema");
        attr.setAttribute("isReference", "false");
        attr.setAttribute("stereotypeID", "XMLAttribute");
        attr.setAttribute("form", "unqualified");
        SchemaBuilder.appendApplicationInfo(attribute, attr, document);
        SchemaBuilder.appendDocumentation(attribute.getDocumentation(), attr, document);
        parent.appendChild(attr);
    }

    private static void appendFieldElement(Field field, Element parent, int order, Document document) {
        Element element = document.createElement("simpleType");
        element.setAttribute("name", field.getName());
        element.setAttribute("type", TypeMapper.mapType(field.getNativeType()));
        element.setAttribute("order", String.valueOf(order));
        element.setAttribute("namespace", "http://www.w3.org/2001/XMLSchema");
        element.setAttribute("stereotypeID", "XMLElement");
        element.setAttribute("form", "qualified");
        element.setAttribute("isReference", "false");
        element.setAttribute("ordered", "true");
        SchemaBuilder.appendApplicationInfo(field, element, document);
        SchemaBuilder.appendDocumentation(field.getDocumentation(), element, document);
        parent.appendChild(element);
    }

    private static void appendApplicationInfo(IDocObject object, Element parent, Document document) {
        if (object.getTaggedValues().size() > 0 || object.getStereotype() != null) {
            Element applicationInfo = document.createElement("applicationInfo");
            parent.appendChild(applicationInfo);
            HashMap<String, Object> taggedValues = object.getTaggedValues();
            if (taggedValues != null) {
                for (String name : taggedValues.keySet()) {
                    SchemaBuilder.appendTaggedValue(name, (String)taggedValues.get(name), applicationInfo, document);
                }
            }
            if (object.getStereotype() != null) {
                Element stereotypeElement = document.createElement("stereotype");
                stereotypeElement.appendChild(document.createElement(object.getStereotype()));
                applicationInfo.appendChild(stereotypeElement);
            }
        }
    }

    private static void appendTaggedValue(String name, String value, Element parent, Document doc) {
        Element taggedValue = doc.createElement("taggedValue");
        Element valueNode = doc.createElement(name.replace("/", "_-"));
        valueNode.appendChild(doc.createTextNode(value));
        taggedValue.appendChild(valueNode);
        parent.appendChild(taggedValue);
    }

    private static void appendDocumentation(String documentation, Element annotation, Document doc) {
        if (documentation != null) {
            Element commentNode = doc.createElement("documentation");
            commentNode.appendChild(doc.createTextNode(documentation));
            annotation.appendChild(commentNode);
        }
    }

    private static Node getDataControlSchema(Document document, int version) {
        Node result = null;
        String dcsName = DCS_BASE + version + DCS_EXT;
        try {
            Document fragment = DomUtilities.parseFromClasspath((String)dcsName, (boolean)false, (boolean)false);
            Element root = fragment.getDocumentElement();
            DomUtilities.removeAllNotElementEmptyNodes((Element)root);
            result = document.importNode(root, true);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(SchemaBuilder.class.getName(), "getDataControlSchema", e);
        }
        return result;
    }
}

