/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idl;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderException;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.IDLImportTransaction;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportTools;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.event.SendErrorEvent;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class IDLTransformImportTransaction
extends IDLImportTransaction {
    public static final String IDL_IMPORT_PARAMETERS = "idl.import.parameters";
    private ArrayList<IDLImportSource> importSources;

    public IDLTransformImportTransaction(Helpers helpers) {
        super(helpers);
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        try {
            Document idlDocument;
            String source;
            Object parameters = importerData.getSource(IDL_IMPORT_PARAMETERS);
            if (parameters instanceof Map) {
                for (Iterator<String> key : ((Map)parameters).keySet()) {
                    this.putTransformParameter(key.toString(), ((Map)parameters).get(key));
                }
            }
            Map<String, Object> defaultExtensionsParameters = this.getDefaultExtensionParameters();
            for (String key : defaultExtensionsParameters.keySet()) {
                if (this.getTransformParameter(key.toString()) != null) continue;
                this.putTransformParameter(key.toString(), defaultExtensionsParameters.get(key));
            }
            String sourceKey = this.getSourceKey();
            String script = this.getScript();
            XSLTInput.setImportSource(importerData.getSource(sourceKey).toString());
            if (importerData.getSource(sourceKey) instanceof URL) {
                URL sourceUrl = (URL)importerData.getSource(sourceKey);
                source = sourceUrl.getFile().replace('?', '.');
                idlDocument = this.transform(sourceUrl, script, importerData.getFilename() + ".idl");
            } else if (importerData.getSource(sourceKey) instanceof File) {
                File srcFile = (File)importerData.getSource(sourceKey);
                source = srcFile.getName();
                idlDocument = this.transform(srcFile, script, importerData.getFilename() + ".idl");
            } else {
                idlDocument = this.transform((Document)importerData.getSource(sourceKey), script, importerData.getFilename() + ".idl");
                source = idlDocument.getDocumentElement().getAttribute("sourceLocation");
            }
            if (idlDocument != null) {
                String name = idlDocument.getDocumentElement().getAttribute("name");
                name = name.length() == 0 ? importerData.getFilename() : name + this.findExtension(source, this.getSourceType(idlDocument));
                boolean changed = false;
                File destination = ImportModel.getDestinationFile(name);
                if (destination.exists()) {
                    Map<String, Object> extensionsParameters = this.readExtensionsParameters(destination);
                    for (String key : extensionsParameters.keySet()) {
                        if (this.getTransformParameter(key.toString()).equals(extensionsParameters.get(key.toString()))) continue;
                        this.putTransformParameter(key.toString(), extensionsParameters.get(key));
                        changed = true;
                    }
                }
                if (changed) {
                    this.doTransaction(importerData);
                } else {
                    this.importSources = this.readImportSources(idlDocument, name, this.isCreateTestModel(importerData));
                    importerData.addSource(this.getImportSourcesKey(), this.importSources);
                    super.doTransaction(importerData);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BuilderException error = new BuilderException((Throwable)e);
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)error);
            EventController.fire((EventObject)((Object)new SendErrorEvent((Object)this, (BuilderError)error)));
        }
    }

    @Override
    protected abstract String getScript();

    protected String getSourceType(Document edmx2idl) {
        return edmx2idl.getDocumentElement().getAttribute("sourceType");
    }

    protected abstract String getSourceKey();

    protected abstract String getImportSourcesKey();

    @Override
    protected ArrayList<IDLImportSource> getIDLSources(ImporterData importerData) {
        return this.importSources;
    }

    protected abstract IDLImportSource createImportSource(String var1, Element var2);

    private ArrayList<IDLImportSource> readImportSources(Document idlDocument, String name, boolean createTestModel) {
        HashMap<String, IDLImportSource> importMap = new HashMap<String, IDLImportSource>();
        HashMap<String, String> location2Namespace = new HashMap<String, String>();
        HashMap<String, String> namespace2name = new HashMap<String, String>();
        NodeList imports = idlDocument.getElementsByTagName("Import");
        if (imports != null && imports.getLength() == 1) {
            Element importElement = (Element)imports.item(0);
            importElement.getParentNode().removeChild(importElement);
            this.addImportedIDLs(importElement.getElementsByTagName("IDL"), importMap, location2Namespace, namespace2name);
        }
        IDLImportSource importSource = this.createImportSource(name, idlDocument.getDocumentElement());
        importSource.setCreateTestModel(createTestModel);
        for (String string : importSource.getImportedModels()) {
            IDLImportSource iDLImportSource = this.findImportSource(string, importMap, location2Namespace, namespace2name);
            importSource.addImportedElement(iDLImportSource);
        }
        ArrayList<Object> importSources = new ArrayList(importMap.values());
        for (IDLImportSource iDLImportSource : importSources) {
            for (String location : iDLImportSource.getImportedModels()) {
                IDLImportSource importedSource = this.findImportSource(location, importMap, location2Namespace, namespace2name);
                if (importedSource == null) continue;
                iDLImportSource.addImportedElement(importedSource);
            }
        }
        HashMap<String, IDLImportSource> hashMap = new HashMap<String, IDLImportSource>();
        for (IDLImportSource source : importMap.values()) {
            hashMap.put(source.getName(), source);
        }
        importSources = ImportTools.getInstance().sortImportedElements(hashMap);
        importSources.add(0, importSource);
        return importSources;
    }

    private IDLImportSource findImportSource(String location, HashMap<String, IDLImportSource> importMap, HashMap<String, String> location2Namespace, HashMap<String, String> namespace2name) {
        IDLImportSource source = importMap.get(location);
        if (source == null) {
            String namespace = location2Namespace.get(location);
            String sourceLocation = namespace2name.get(namespace);
            source = importMap.get(sourceLocation);
        }
        return source;
    }

    private void addImportedIDLs(NodeList idlList, HashMap<String, IDLImportSource> importedIdls, HashMap<String, String> location2Namespace, HashMap<String, String> namespace2name) {
        int length = idlList.getLength();
        for (int i = 0; i < length; ++i) {
            Element idl = (Element)idlList.item(i);
            boolean alreadyImported = DomUtilities.getBoolean((Element)idl, (String)"alreadyImported", (boolean)false);
            String sourceLocation = idl.getAttribute("sourceLocation");
            String sourceNamespace = idl.getAttribute("sourceNamespace");
            String type = idl.getAttribute("sourceType");
            if (alreadyImported) continue;
            location2Namespace.put(sourceLocation, sourceNamespace + this.findExtension(sourceLocation, type));
            Document importedIDL = DomUtilities.newDocument();
            idl = (Element)importedIDL.importNode(idl, true);
            importedIDL.appendChild(idl);
            String importName = importedIDL.getDocumentElement().getAttribute("name") + this.findExtension(sourceLocation, type);
            namespace2name.put(sourceNamespace + this.findExtension(sourceLocation, type), importName);
            IDLImportSource importedModel = this.createImportSource(importName, importedIDL.getDocumentElement());
            importedIdls.put(importName, importedModel);
        }
    }

    private String findExtension(String sourceLocation, String type) {
        String extension;
        if (type.length() == 0) {
            int index = sourceLocation.lastIndexOf(46);
            if (index == -1) {
                extension = "";
            } else {
                extension = sourceLocation.substring(index).toLowerCase();
                int questionMarkIndex = extension.indexOf(63);
                if (questionMarkIndex != -1) {
                    extension = extension.substring(0, questionMarkIndex);
                }
            }
        } else {
            extension = '.' + type;
        }
        return extension;
    }
}

