/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.compiler.document.importer.ExtensionElement;
import ch.e2e.builder.compiler.document.importer.Logging;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportModel {
    private Document model;
    private File destination;
    private boolean create;
    private String name;
    private DataModel dataModel;
    private List<String> sharedPackages;
    private OldIds oldIds;
    List<OldIds> oldIdsList = new ArrayList<OldIds>();

    public ImportModel(String name) {
        this.name = name;
        this.destination = ImportModel.getDestinationFile(name);
        this.create = false;
    }

    public static File getDestinationFile(String name) {
        File importsFolder = new File(CompilerConstants.getSourceFolder(), "imports/");
        return new File(importsFolder, name + ".import.xml");
    }

    public String getName() {
        return this.name;
    }

    public Document getModel() {
        return this.model;
    }

    public void setModel(Document model) {
        this.model = model;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void serialize(boolean readOnly) throws IOException, TransformerException {
        this.serialize(this.destination, readOnly);
    }

    public void serialize(boolean readOnly, Transformer transformer) throws IOException, TransformerException {
        this.serialize(this.destination, readOnly, transformer);
    }

    public void serialize(File destination, boolean readOnly) throws IOException, TransformerException {
        this.serialize(destination, readOnly, null);
    }

    public void serialize(File destination, boolean readOnly, Transformer transformer) throws IOException, TransformerException {
        this.replaceOldIds();
        this.doBackup(true);
        DOMResult result = new DOMResult();
        Logging.logger.info("serializing '" + this.name + "' to '" + destination.getAbsolutePath() + "'.");
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (transformer != null) {
            File tmp = File.createTempFile("importModelSerializeSource", ".xml");
            DomUtilities.serialize((File)tmp, (Document)this.model, (boolean)false);
            transformer.transform(new StreamSource(tmp), result);
            this.model = (Document)result.getNode();
            tmp.delete();
        }
        DomUtilities.serialize((File)destination, (Document)this.model, (boolean)true);
        if (readOnly) {
            destination.setReadOnly();
        }
    }

    public OldIds getOldIds() {
        if (this.model == null) {
            return null;
        }
        if (this.oldIds == null) {
            try {
                this.oldIds = new OldIds();
                Element transformationModelElement = (Element)DomUtilities.evaluate((Node)this.model.getDocumentElement(), (String)"/XMITransformationModel", (QName)XPathConstants.NODE);
                this.oldIds.newModelId = transformationModelElement.getAttribute("xmi:id");
                if (this.destination.exists() && this.destination.length() > 0L) {
                    Document oldDocument = DomUtilities.parse((File)this.destination, (boolean)false, (boolean)false, (boolean)false);
                    String oldModelId = (String)DomUtilities.evaluate((Node)oldDocument.getDocumentElement(), (String)"/xmi:XMI/uml:Model/@xmi:id", (QName)XPathConstants.STRING);
                    String oldProjectId = (String)DomUtilities.evaluate((Node)oldDocument.getDocumentElement(), (String)"/xmi:XMI/xmi:Extension/filePart[@type='BINARY'][starts-with(@name,'PROJECT-')]/@name", (QName)XPathConstants.STRING);
                    if (oldModelId != null && !oldModelId.equals("")) {
                        this.oldIds.oldModelId = oldModelId;
                    }
                    if (oldProjectId != null && !oldProjectId.equals("")) {
                        this.oldIds.oldProjectId = oldProjectId;
                    }
                }
            }
            catch (Exception e) {
                this.oldIds = null;
                e.printStackTrace();
            }
        }
        return this.oldIds;
    }

    public void setOldIdsList(List<OldIds> oldIdsList) {
        this.oldIdsList = oldIdsList;
    }

    private void replaceOldIds() {
        try {
            Element transformationModelElement = (Element)DomUtilities.evaluate((Node)this.model.getDocumentElement(), (String)"/XMITransformationModel", (QName)XPathConstants.NODE);
            OldIds thisOldIds = this.getOldIds();
            if (thisOldIds != null) {
                if (thisOldIds.oldModelId != null) {
                    transformationModelElement.setAttribute("xmi:id", thisOldIds.oldModelId);
                    NodeList mountedOns = (NodeList)DomUtilities.evaluate((Node)this.model.getDocumentElement(), (String)"//@mountedOn", (QName)XPathConstants.NODESET);
                    int length = mountedOns.getLength();
                    for (int i = 0; i < length; ++i) {
                        Attr attribute = (Attr)mountedOns.item(i);
                        attribute.setValue(thisOldIds.oldModelId);
                    }
                }
                if (thisOldIds.oldProjectId != null) {
                    transformationModelElement.setAttribute("projectID", thisOldIds.oldProjectId);
                }
            }
            for (OldIds oldIds : this.oldIdsList) {
                Element moduleElement;
                if (oldIds.oldModelId == null || (moduleElement = (Element)DomUtilities.evaluate((Node)transformationModelElement, (String)("mountTable/module[@moduleId='" + oldIds.newModelId + "']"), (QName)XPathConstants.NODE)) == null) continue;
                moduleElement.setAttribute("moduleId", oldIds.oldModelId);
                if (oldIds.oldProjectId == null) continue;
                moduleElement.setAttribute("projectID", oldIds.oldProjectId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doBackup(boolean delete) {
        if (this.destination.exists() && this.destination.length() > 0L) {
            String backupName = this.findDestinationBackupName();
            if (backupName == null) {
                this.destination.delete();
            } else {
                File backupFile = new File(this.destination.getParentFile(), backupName);
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                this.destination.renameTo(backupFile);
            }
        }
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.sharedPackages = new ArrayList<String>();
        for (BridgePackage bridgePackage : dataModel.getSharedPackages()) {
            this.sharedPackages.add(bridgePackage.getName());
        }
    }

    public void addSharedPackage(String name) {
        if (this.sharedPackages == null) {
            this.sharedPackages = new ArrayList<String>();
        }
        this.sharedPackages.add(name);
    }

    public List<String> getSharedPackages() {
        return this.sharedPackages;
    }

    public void setSharedPackages(List<String> sharedPackages) {
        this.sharedPackages = sharedPackages;
    }

    private String findDestinationBackupName() {
        String name = null;
        int index = this.destination.getName().lastIndexOf(46);
        if (index != -1) {
            name = this.destination.getName().substring(0, index) + ".bak";
        }
        return name;
    }

    public Element getDestinationExtensionElement() {
        return ExtensionElement.getExtensionImportedElement(this.getDestination());
    }

    public class OldIds {
        public String newModelId;
        public String oldProjectId;
        public String oldModelId;
    }
}

