/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LibraryService {
    private String path;
    private String name;
    private String filename;
    private String umlLocation;
    File libsFolder;

    public LibraryService(String name, String filename, String path, String umlLocation, File libsFolder) {
        this.umlLocation = umlLocation;
        this.filename = filename;
        this.name = name;
        this.libsFolder = libsFolder;
        this.path = path;
        if (path == null || path.length() == 0) {
            this.path = libsFolder.getAbsolutePath();
        }
    }

    public File getRepository() {
        return new File(this.libsFolder, this.name + ".lrep");
    }

    public Document getLibraryInterface() throws IOException, ParserConfigurationException, SAXException {
        ZipFile repository = new ZipFile(this.getRepository());
        Document result = repository.getEntry("library.interface") != null ? ZipUtilities.getZippedDocumentFromFile((ZipFile)repository, (String)"library.interface", (boolean)false, (boolean)false) : ZipUtilities.getZippedDocumentFromFile((ZipFile)repository, (String)"module.interface", (boolean)false, (boolean)false);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getUmlLocation() {
        return this.umlLocation;
    }
}

