/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.tabfile;

import ch.e2e.builder.compiler.build.types.tabfile.Attribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Element;

public abstract class SimpleElement {
    private Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();

    public SimpleElement() {
    }

    public SimpleElement(Element tabfileElement) {
        this.readAttributes(tabfileElement);
    }

    public abstract String getElementName();

    protected void setAttribute(String name, String value) {
        this.attributes.put(name, new Attribute(name, value));
    }

    public String getAttributeValue(String name) {
        Attribute attribute = this.attributes.get(name);
        return attribute != null ? attribute.getValue() : null;
    }

    public List<String> getAttributeNames() {
        return null;
    }

    protected void readAttributes(Element tabfileElement) {
        List<String> attributeNames = this.getAttributeNames();
        if (attributeNames != null) {
            for (String attrName : attributeNames) {
                if (!tabfileElement.hasAttribute(attrName)) continue;
                this.setAttribute(attrName, tabfileElement.getAttribute(attrName));
            }
        }
    }

    public Element buildDom(Element parent, boolean library) {
        Element me = parent.getOwnerDocument().createElement(this.getElementName());
        parent.appendChild(me);
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            entry.getValue().buildDom(me, library);
        }
        return me;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleElement that = (SimpleElement)o;
        return this.getAttributes().equals(that.getAttributes());
    }

    public int hashCode() {
        return Objects.hash(this.getAttributes());
    }
}

