/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.RuntimeFeature;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FeaturesTabfile
extends XmlTabfile {
    public FeaturesTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
        this.getDocument();
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Iterator featureIterator = DomUtilities.elementIterator((NodeList)table.getChildNodes());
        while (featureIterator.hasNext()) {
            this.addFeature((Element)featureIterator.next());
        }
        return true;
    }

    private void addFeature(Element element) {
        String runtimeVersion = element.getAttribute("runtimeVersion");
        int dot = runtimeVersion.indexOf(".");
        String majorStr = runtimeVersion.substring(0, dot);
        String minorStr = runtimeVersion.substring(dot + 1);
        this.addRuntimeFeature(element.getAttribute("description"), Integer.parseInt(majorStr), Integer.parseInt(minorStr), Boolean.valueOf(element.getAttribute("runtimeVersionRequired")));
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        for (RuntimeFeature feature : this.getRuntimeFeatures()) {
            feature.serialize(tabfile.getDocumentElement());
        }
    }

    public String getRecommendedRuntimeVersion() {
        if (!this.getRuntimeFeatures().isEmpty()) {
            return this.getRuntimeFeatures().iterator().next().getRuntimeVersion();
        }
        return null;
    }
}

