/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public abstract class AbstractTabfile {
    protected File target;
    private String tabfileName;

    public AbstractTabfile(File repositoryFolder, String tabfileName) {
        this.tabfileName = tabfileName;
        this.target = new File(repositoryFolder, tabfileName);
    }

    public String getTabfileName() {
        return this.tabfileName;
    }

    public File getTabfile() {
        return this.target;
    }

    protected void write(Document document) throws IOException, TransformerException {
        if (!this.target.getParentFile().exists() && !this.target.getParentFile().mkdirs()) {
            throw new BuildException("Exception: Unable to create directory \"" + this.target.getParentFile().getAbsolutePath() + "\"");
        }
        DomUtilities.serialize((OutputStream)new FileOutputStream(this.target), (Document)document, (boolean)true);
    }
}

