/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.BuildLibraryTask;
import ch.e2e.builder.compiler.build.tasks.model.ZipTask;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class XlibZipTask
extends ZipTask {
    public static String TASK_ID = "library.build.xlib";
    private static final String[] ALLOWED_EXTENSIONS = new String[]{".descriptor.json", ".form.json", ".lrep", ".tgz"};

    public static Boolean select(String id) {
        return id.equals(TASK_ID);
    }

    public XlibZipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    public XumlProject getProject() {
        return ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class);
    }

    @Override
    protected Path[] getInputFolderPaths() {
        return new Path[0];
    }

    @Override
    protected Map<String, File> getInputFiles() {
        HashMap<String, File> result = new HashMap<String, File>();
        result.put(this.getProject().getName() + ".lrep", ((CacheAbleTask)this.getSourceManager().getSource(BuildLibraryTask.TASK_ID)).getDestinationFile());
        result.put("library.descriptor.json", ((CacheAbleTask)this.getSourceManager().getSource("library/library.descriptor.json")).getDestinationFile());
        Set<String> exposedForms = FormHelper.getLibraryForms(this.getSourceManager());
        if (!exposedForms.isEmpty()) {
            String angularLibArchiveName = AngularHelper.getAngularLibArchiveName(this.getProject());
            result.put(angularLibArchiveName, new File(this.sourceManager.getWorkFolder(), "angular-lib/dist/" + AngularHelper.getAngularLibName(this.getProject().getName()) + "/" + angularLibArchiveName));
            exposedForms.forEach(form -> result.put(Files.forms__FORM_library_form_json(form), ((FileSource)this.getSourceManager().getSource(Files.form__FORM_library_form_json(form))).getFile()));
        }
        return result;
    }

    @Override
    public File getDestinationFile() {
        return new File(this.sourceManager.getWorkFolder(), Files.library__PROJECTNAME_xlib(this.getProject().getName()));
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".xlib";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("project.xml");
        result.addAll(FormHelper.getFormJsonDocumentSourceSet(this.getSourceManager()));
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("library/library.descriptor.json");
        result.add(BuildLibraryTask.TASK_ID);
        Set<String> exposedForms = FormHelper.getLibraryForms(this.getSourceManager());
        if (!exposedForms.isEmpty()) {
            result.add(Files.library__PROJECT_build_npm(AngularHelper.getAngularLibName(this.getProject().getName())));
            exposedForms.forEach(form -> result.add(Files.form__FORM_library_form_json(form)));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        String fileName = path.getFileName().toString();
        if (!super.doFilter(path)) return false;
        if (!Stream.of(ALLOWED_EXTENSIONS).anyMatch(fileName::endsWith)) return false;
        return true;
    }
}

