/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.BehaviorWithReferenceTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.XumlActivity;
import ch.e2e.builder.compiler.document.json.xuml.XumlCallAction;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;

public class ActivityWithReferencesTask
extends BehaviorWithReferenceTask
implements XSLTTransformSource {
    public static Boolean select(String id) {
        return id.endsWith(".activity.wr.xml");
    }

    public ActivityWithReferencesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".activity.wr.xml";
    }

    @Override
    public String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".activity.xml";
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JsonDocumentSource source = (JsonDocumentSource)this.getSource(this.getSourceId());
            if (source == null) {
                return;
            }
            XumlActivity document = source.getJsonDocument(XumlActivity.class);
            this.setCalledOperation(document.getNodes().stream().filter(e -> e instanceof XumlCallAction).map(e -> (XumlCallAction)e).collect(Collectors.toList()));
            if (!this.getErrorHandler().hasErrors()) {
                this.result = new DOMResult();
                this.getMarshaller(XumlActivity.class).marshal((Object)document, (Result)this.result);
                DomUtilities.serialize((File)this.getDestinationFile(), (Node)this.result.getNode(), (boolean)true);
            }
        }
        catch (Exception e2) {
            this.getErrorHandler().error((Throwable)e2);
        }
    }
}

