/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.bpmn.executions;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel.BehaviorWithReferenceTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.XumlExecution;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;

public class ExecutionWithReferencesTask
extends BehaviorWithReferenceTask
implements XSLTTransformSource {
    public static Boolean select(String id) {
        return id.endsWith(".execution.wr.xml");
    }

    public ExecutionWithReferencesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".execution.wr.xml";
    }

    @Override
    public String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".execution.xml";
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            JsonDocumentSource source = (JsonDocumentSource)this.getSource(this.getSourceId());
            if (source == null) {
                return;
            }
            XumlExecution document = source.getJsonDocument(XumlExecution.class);
            this.setCalledOperation(document.getCallActions());
            if (!this.getErrorHandler().hasErrors()) {
                this.result = new DOMResult();
                this.getMarshaller(XumlExecution.class).marshal((Object)document, (Result)this.result);
                DomUtilities.serialize((File)this.getDestinationFile(), (Node)this.result.getNode(), (boolean)true);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }
}

