/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.model.AliasesXmiTransformationModelTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ComponentModelTask
extends XSLTTask {
    public static Boolean select(String id) {
        return id.endsWith(".xmiTransformationModel.xml");
    }

    public ComponentModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".xml";
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.component";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add("project.xml");
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    private Set<String> getLibrariesComponentsSourceSet() {
        return this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().keySet().stream().map(Files::libs_LIBRARY__LIBRARY_library_components_xml).collect(Collectors.toSet());
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add("project.xml");
        result.addAll(this.getLibrariesComponentsSourceSet());
        result.addAll(AliasesXmiTransformationModelTask.getAliasesSourceSet(this.getSourceManager()));
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class);
        result.add("model/" + projectDocument.getName() + ".bpmn.components.xml");
        File[] apiFolderContent = new File(this.getSourceManager().getProjectFolder(), "api").listFiles();
        if (apiFolderContent != null) {
            Arrays.stream(apiFolderContent).filter(file -> file.getName().endsWith(".api.json")).map(file -> file.getName().replace(".api.json", "")).forEach(apiName -> result.add("api/" + apiName + "/" + apiName + ".components.xml"));
        }
        return result;
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> map = super.getTransformParameters();
        map.put("isAngularApp", true);
        return map;
    }
}

