/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractDataModelXmiTransformationModelTask
extends XSLTTask {
    public AbstractDataModelXmiTransformationModelTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.dataModel";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    private Set<String> getLibrariesComponentsSourceSet() {
        return this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().keySet().stream().map(Files::libs_LIBRARY__LIBRARY_library_components_xml).collect(Collectors.toSet());
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>(this.getLibrariesComponentsSourceSet());
        File dataModelFolder = new File(this.getSourceManager().getProjectFolder(), this.getDataModelPath());
        if (dataModelFolder.isDirectory()) {
            Arrays.stream(dataModelFolder.listFiles()).filter(file -> file.getPath().endsWith(".package.json") || file.getPath().endsWith(".class.json") || file.getPath().endsWith(".interface.json")).map(this.getSourceManager()::relativize).map(fileName -> fileName.replace(System.getProperty("file.separator"), "/").replace(".json", ".xmiPart.xml")).forEach(result::add);
        }
        return result;
    }

    protected abstract String getDataModelPath();
}

