/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.project;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.project.AbstractAngularSourcesTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class AngularSourcesTask
extends AbstractAngularSourcesTask {
    public static Boolean select(String id) {
        return id.equals("angular.file.list");
    }

    public AngularSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        try {
            this.sourceManager.getSourceFilesStream().map(path -> path.getFileName().toString()).filter(path -> path.endsWith(".bpmn.json")).map(path -> Files.bpmn__PROCESS_bpmn_xml(path.replace(".bpmn.json", ""))).forEach(result::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        String mainProjectName = this.getAngularProjectName();
        result.add("angular/angular.json");
        result.add("angular/Dockerfile");
        result.add("angular/.gitignore");
        result.add("angular/.gitlab-ci.yml");
        result.add("angular/.npmrc");
        result.add("angular/package.json");
        result.add("angular/tsconfig.json");
        result.add("angular/tslint.json");
        result.add("angular/README.md");
        result.add("angular/config/local/config.json");
        result.add("angular/config/default/config.json");
        String resourcePath = Folders.angular_projects_PROJECT(mainProjectName) + "/";
        result.add(resourcePath + "src/app/components/process-list/process-list.component.html");
        result.add(resourcePath + "src/app/components/process-list/process-list.component.ts");
        result.add(resourcePath + "src/app/components/user/user.component.html");
        result.add(resourcePath + "src/app/components/user/user.component.scss");
        result.add(resourcePath + "src/app/components/user/user.component.theme.scss");
        result.add(resourcePath + "src/app/components/user/user.component.ts");
        result.add(resourcePath + "src/app/guards/security.guard.ts");
        result.add(resourcePath + "src/app/app.component.html");
        result.add(resourcePath + "src/app/app.component.ts");
        result.add(resourcePath + "src/app/app.module.ts");
        result.add(resourcePath + "src/app/app-config.ts");
        result.add(resourcePath + "src/app/material.module.ts");
        result.add(resourcePath + "src/environments/environment.ts");
        result.add(resourcePath + "src/environments/procode.environment.ts");
        result.add(resourcePath + "src/environments/prod.environment.ts");
        result.add(resourcePath + "src/favicon.ico");
        result.add(resourcePath + "src/index.html");
        result.add(resourcePath + "src/main.ts");
        result.add(resourcePath + "src/polyfills.ts");
        result.add(resourcePath + "src/proxy.conf.js");
        result.add(resourcePath + "src/style.scss");
        result.add(resourcePath + "tsconfig.app.json");
        result.add(Files.angular_projects_PROJECT_src_app_forms__forms_module_ts(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_app__app_routing_module_ts(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_app__css_json(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_app__libraries_module_ts(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_app_services__form_service_ts(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_app_services__security_service_ts(mainProjectName));
        result.add(Files.angular_projects_PROJECT_src_assets_i18n__LANGUAGE_json(mainProjectName, "de"));
        result.add(Files.angular_projects_PROJECT_src_assets_i18n__LANGUAGE_json(mainProjectName, "en"));
        try {
            this.sourceManager.getSourceFilesStream().map(path -> path.getFileName().toString()).filter(path -> path.endsWith(".form.json") || path.endsWith(".bpmn.json")).forEach(path -> {
                if (path.endsWith(".form.json")) {
                    result.addAll(this.listFormSources(mainProjectName, path.replace(".form.json", "")));
                } else if (path.endsWith(".bpmn.json")) {
                    result.addAll(this.listProcessSources(mainProjectName, path.replace(".bpmn.json", "")));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Set<String> listFormSources(String projectName, String formName) {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.angular_projects_PROJECT_src_app_forms_FORM__form_component_html(projectName, formName));
        result.add(Files.angular_projects_PROJECT_src_app_forms_FORM__form_component_ts(projectName, formName));
        return result;
    }

    private Set<String> listProcessSources(String projectName, String bpmnName) {
        HashSet<String> result = new HashSet<String>();
        JsonDocumentSource source = (JsonDocumentSource)this.getSource(Files.bpmn__PROCESS_bpmn_xml(bpmnName));
        BpmnDefinitions bpmnDefinitions = source.getJsonDocument(BpmnDefinitions.class);
        if (bpmnDefinitions != null && bpmnDefinitions.getProcess() != null) {
            bpmnDefinitions.getProcess().forEach(bpmnProcess -> {
                if (bpmnProcess.getUserTask() != null) {
                    bpmnProcess.getUserTask().forEach(bpmnUserTask -> {
                        if (bpmnUserTask.getExtensionElements() != null && bpmnUserTask.getExtensionElements().getForm() != null && bpmnUserTask.getExtensionElements().getForm().getForm() != null && !bpmnUserTask.getExtensionElements().getForm().getForm().equals("")) {
                            result.addAll(this.listTaskSources(projectName, bpmnName, bpmnUserTask.getName()));
                        }
                    });
                }
            });
        }
        result.add(Files.angular_projects_PROJECT_src_app_process_PROCESS__process_routing_module_ts(projectName, bpmnName));
        result.add(Files.angular_projects_PROJECT_src_app_services_security__PROCESS_bpmn_authorizations_json(projectName, bpmnName));
        String libPath = Folders.angular_projects_PROJECT_src_app_process_PROCESS(projectName, bpmnName) + "/";
        result.add(libPath + "components/default/default.component.html");
        result.add(libPath + "components/default/default.component.ts");
        result.add(libPath + "components/instance/instance.component.html");
        result.add(libPath + "components/instance/instance.component.ts");
        result.add(libPath + "components/process/instanceList.ts");
        result.add(libPath + "components/process/process.component.html");
        result.add(libPath + "components/process/process.component.ts");
        result.add(libPath + "components/start/start.component.html");
        result.add(libPath + "components/start/start.component.ts");
        result.add(libPath + "components/select-task/select-task.component.html");
        result.add(libPath + "components/select-task/select-task.component.ts");
        result.add(libPath + "guards/instance.guard.ts");
        result.add(libPath + "guards/instance-list.guard.ts");
        result.add(libPath + "guards/task.guard.ts");
        result.add(libPath + "guards/select-task.guard.ts");
        result.add(libPath + "process.module.ts");
        return result;
    }

    private Set<String> listTaskSources(String projectName, String bpmnName, String taskName) {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK__task_component_ts(projectName, bpmnName, taskName));
        String libPath = Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(projectName, bpmnName, taskName) + "/";
        result.add(libPath + "task.component.html");
        result.add(libPath + "task.module.ts");
        result.add(libPath + "task.routing.module.ts");
        return result;
    }
}

