/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.project;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.project.AbstractAngularSourcesTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.builder.compiler.document.json.xuml.usages.XumlClassUsage;
import ch.e2e.builder.compiler.document.json.xuml.usages.XumlClassesUsages;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public class AngularLibSourcesTask
extends AbstractAngularSourcesTask {
    public static Boolean select(String id) {
        return id.equals("angular-lib.file.list");
    }

    public AngularLibSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> sourceSet = super.getBeforeSourceSet();
        sourceSet.add("dataModel/dataModel.classes.usages.xml");
        try {
            this.getSourceManager().getSourceIdsStream().filter(id -> id.endsWith(".form.json")).forEach(id -> sourceSet.add(id.replace(".form.json", ".form.xml")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("angular-lib/angular.json");
        result.add("angular-lib/.gitignore");
        result.add("angular-lib/.npmrc");
        result.add("angular-lib/package.json");
        result.add("angular-lib/tsconfig.json");
        result.add("angular-lib/README.md");
        String angularProjectName = AngularHelper.getAngularLibName(this.getProjectName());
        result.add(Files.angularLib_projects_PROJECT_src__publicApi_ts(angularProjectName));
        result.add(Files.angularLib_projects_PROJECT_src_lib__PROJECT_library_module_ts(angularProjectName));
        String resourcePath = Folders.angularLib_projects_PROJECT_(angularProjectName);
        result.add(resourcePath + "ng-package.json");
        result.add(resourcePath + "package.json");
        result.add(resourcePath + "README.md");
        result.add(resourcePath + "tsconfig.lib.json");
        result.add(resourcePath + "tsconfig.lib.prod.json");
        XSLTTransformSource classesUsagesSource = (XSLTTransformSource)this.getSourceManager().getSource("dataModel/dataModel.classes.usages.xml");
        XumlClassesUsages classesUsages = XSLTTransformSource.getJsonDocument(classesUsagesSource, XumlClassesUsages.class);
        try {
            this.getSourceManager().getSourceIdsStream().filter(id -> id.endsWith(".form.json")).forEach(id -> this.addFormSourcesIfExposed(result, angularProjectName, id.replace(".form.json", ""), classesUsages));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void addFormSourcesIfExposed(Set<String> result, String projectName, String formPath, XumlClassesUsages classesUsages) {
        String formName = formPath.substring(formPath.lastIndexOf("/") + 1);
        XumlForm xumlForm = ((JsonDocumentSource)this.sourceManager.getSource(Files.form__FORM_form_xml(formName))).getJsonDocument(XumlForm.class);
        if (xumlForm.getLibraryExposed().booleanValue()) {
            result.add(Files.angularLib_projects_PROJECT__src_lib_FORMPATH__FORM_form_component_ts(projectName, formPath, formName));
            result.add(Files.angularLib_projects_PROJECT__src_lib_FORMPATH__FORM_form_component_html(projectName, formPath, formName));
            AngularLibSourcesTask.addFormInterfaceSources(result, projectName, xumlForm, classesUsages);
        }
    }

    public static void addFormInterfaceSources(Set<String> result, String projectName, XumlForm xumlForm, XumlClassesUsages classesUsages) {
        if (xumlForm.getClassId() != null && xumlForm.getClassId().contains(".class.json")) {
            LinkedList<String> classToAdd = new LinkedList<String>();
            classToAdd.add(xumlForm.getClassId().substring(0, xumlForm.getClassId().indexOf(".class.json")));
            while (classToAdd.size() > 0) {
                String classPath = (String)classToAdd.pop();
                if (classPath.equals("") || result.contains(Folders.angularLib_projects_PROJECT__src_lib_(projectName) + classPath + ".interface.ts")) continue;
                result.add(Folders.angularLib_projects_PROJECT__src_lib_(projectName) + classPath + ".interface.ts");
                if (classesUsages.getClassUsages() == null) continue;
                classesUsages.getClassUsages().stream().filter(xumlClassUsages -> xumlClassUsages.getClassPath().equals(classPath)).findFirst().ifPresent(classUsages -> {
                    if (classUsages.getClassUsage() != null) {
                        classToAdd.addAll(classUsages.getClassUsage().stream().map(XumlClassUsage::getClassPath).collect(Collectors.toList()));
                    }
                });
            }
        }
    }
}

