/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.SubstitutionTask;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnUserTask;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AngularSubstitutionFromBase
extends SubstitutionTask {
    private static final Boolean XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR", true);
    private static final Boolean XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR", true);
    private static final String XUML_SERVICES_BRIDGE_PATH = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_BRIDGE_PATH", "cust/service");
    private static final String XUML_SERVICES_CONTAINER_PATH = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_CONTAINER_PATH", "xuml");
    private static final String XUML_APP_KEYCLOAK_CLIENT_ID = EnvUtils.get("XUML_COMPILER_XUML_APP_KEYCLOAK_CLIENT_ID", "authenticator-service");

    public static Boolean select(String id) {
        return id.startsWith("angular/") && (id.endsWith("ng-package.json") || id.endsWith("package.json") || id.endsWith("angular.json") || id.endsWith("index.html") || id.endsWith(".component.ts") || id.endsWith("public-api.ts") || id.endsWith("proxy.conf.json") || id.endsWith("Dockerfile") || id.endsWith("README.md") || id.endsWith(".npmrc")) || id.endsWith("environment.ts") || id.startsWith("angular-lib/") && (id.endsWith("angular.json") || id.endsWith("ng-package.json") || id.endsWith("package.json") || id.endsWith("tsconfig.json") || id.endsWith("README.md") || id.endsWith(".npmrc"));
    }

    public AngularSubstitutionFromBase(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getSourceId() {
        return AngularHelper.getBaseResourceId(this.getId());
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getSourceId());
        set.add("project.xml");
        String moduleName = this.getModuleName();
        String intermediateName = this.getIntermediateName();
        if (!moduleName.equals("") && !intermediateName.equals("")) {
            set.add(Files.bpmn_PROCESS__TASK_userTask_bpmnPart_xml(intermediateName, moduleName));
        }
        return set;
    }

    String getAngularProjectName() {
        return AngularHelper.extractAngularProjectName(this.getId());
    }

    String getIntermediateName() {
        return AngularHelper.extractIntermediateName(this.getAngularProjectName());
    }

    String getModuleName() {
        return AngularHelper.extractModuleName(this.getAngularProjectName());
    }

    String getFormName() {
        JsonDocumentSource source = (JsonDocumentSource)this.getSource(Files.bpmn_PROCESS__TASK_userTask_bpmnPart_xml(this.getIntermediateName(), this.getModuleName()));
        BpmnUserTask userTask = source.getJsonDocument(BpmnUserTask.class);
        if (userTask.getExtensionElements() != null && userTask.getExtensionElements().getForm() != null) {
            String formName = userTask.getExtensionElements().getForm().getForm();
            return StringUtils.substringBetween(formName, "/", ".form.json#");
        }
        return "";
    }

    @Override
    protected Map<String, String> getSubstitutions() {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        JsonDocumentSource source = (JsonDocumentSource)this.getSource("project.xml");
        XumlProject projectDocument = source.getJsonDocument(XumlProject.class);
        String projectName = projectDocument.getName();
        String intermediateName = this.getIntermediateName();
        String moduleName = this.getModuleName();
        substitutions.put("placeholder.system.endpoint", EnvUtils.get("SYSTEM_ENDPOINT", "vagrantguest"));
        substitutions.put("placeholder.system.prefix", EnvUtils.get("SYSTEM_PREFIX", "pas"));
        substitutions.put("placeholder.gitlab.access.token", EnvUtils.get("GITLAB_ACCESS_TOKEN", ""));
        substitutions.put("placeholder.project.name", projectName);
        substitutions.put("placeholder.project.base.href", projectDocument.getDeploymentType().equals("bridge") && projectDocument.getProxyPort() != null && projectDocument.getProxyPort() != 0 ? "/" + projectName : "");
        substitutions.put("placeholder.project.version", projectDocument.getVersion());
        substitutions.put("placeholder.project.proxyPort", projectDocument.getProxyPort() != null && projectDocument.getProxyPort() != 0 ? projectDocument.getProxyPort().toString() : "");
        substitutions.put("placeholder.project.xuml.service.path", projectDocument.getDeploymentType().equals("bridge") ? XUML_SERVICES_BRIDGE_PATH + "/" + projectName : XUML_SERVICES_CONTAINER_PATH + "/" + projectDocument.getHostname());
        substitutions.put("placeholder.project.xuml.service.is.authenticator", (projectDocument.getDeploymentType().equals("bridge") ? XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR : XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR) != false ? "true" : "false");
        substitutions.put("placeholder.project.app.keycloak.clientId", XUML_APP_KEYCLOAK_CLIENT_ID);
        substitutions.put("placeholder.angular.main.project.name", AngularHelper.getMainProjectName(projectName));
        substitutions.put("placeholder.angular.library.project.name", AngularHelper.getLibraryProjectName(projectName));
        if (!moduleName.equals("")) {
            substitutions.put("placeholder.angular.module.name", moduleName);
            substitutions.put("placeholder.angular.form.project.name", AngularHelper.getFormProjectName(projectName, moduleName));
            if (!intermediateName.equals("")) {
                substitutions.put("placeholder.angular.form-dependency.project.name", AngularHelper.getFormProjectName(projectName, this.getFormName()));
                substitutions.put("placeholder.angular.process.project.name", AngularHelper.getProcessProjectName(projectName, intermediateName));
                substitutions.put("placeholder.angular.task.project.name", AngularHelper.getTaskProjectName(projectName, intermediateName, moduleName));
            } else {
                substitutions.put("placeholder.angular.process.project.name", AngularHelper.getProcessProjectName(projectName, moduleName));
            }
        }
        if (this.getId().startsWith("angular-lib/")) {
            substitutions.put("placeholder.angular-lib.project.name", AngularHelper.getAngularLibName(projectDocument.getName()));
        }
        return substitutions;
    }
}

