/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class FileUtilities {
    public static Path getParentAfter(Path path, String pathToSearch, int level) {
        Path parent = null;
        int parentCount = 0;
        while (path.getParent() != null) {
            if (FileUtilities.getFileName(path.getParent()).equals(pathToSearch) && ++parentCount == level) {
                parent = path;
                break;
            }
            path = path.getParent();
        }
        return parent;
    }

    public static String getParentFileNameAfter(Path path, String pathToSearch, int level) {
        return Optional.ofNullable(FileUtilities.getParentAfter(path, pathToSearch, level)).map(FileUtilities::getFileName).orElse(null);
    }

    public static String getParentFileNameAfter(Path path, String pathToSearch) {
        return FileUtilities.getParentFileNameAfter(path, pathToSearch, 1);
    }

    public static String getParentFileNameAfter(String id, String pathToSearch) {
        return FileUtilities.getParentFileNameAfter(id, pathToSearch, 1);
    }

    public static String getParentFileNameAfter(String id, String pathToSearch, int level) {
        return FileUtilities.getParentFileNameAfter(Paths.get(id, new String[0]), pathToSearch, level);
    }

    private static String getFileName(Path path) {
        return path.getFileName().toString();
    }
}

