/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public abstract class CopyTask
extends CacheAbleTask {
    public CopyTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected abstract String getSourceId();

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    protected InputStream getResourceInputStream() throws IOException {
        Source inputStreamSource = this.getSource(this.getSourceId());
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            Path destinationFile = this.getDestinationFile().toPath();
            Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
            Files.copy(this.getResourceInputStream(), destinationFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }
}

