/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.eml;

import ch.e2e.builder.compiler.build.eml.EmlFunction;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.dom.DomUtilities;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class EmlIf
implements EmlFunction {
    private static final int EXISTS = 0;
    private Element ifElement;
    private int type;
    private String expression;

    public EmlIf(Element ifElement) {
        this.ifElement = ifElement;
        NamedNodeMap attrs = ifElement.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("exists")) continue;
            this.type = 0;
            this.expression = attr.getValue();
        }
    }

    @Override
    public NodeList evaluate(Element configurationElement, XmlTabfile tabfile) {
        NodeList result = null;
        switch (this.type) {
            case 0: {
                result = this.evaluateExists(configurationElement);
                break;
            }
        }
        return result;
    }

    private NodeList evaluateExists(Element configurationElement) {
        int endIndex;
        NodeList result = null;
        int index = this.expression.indexOf("$XPATH{");
        if (index != -1 && (endIndex = this.expression.indexOf(125, index)) != -1) {
            String xPathStr = this.expression.substring(index + 7, endIndex);
            NodeList xPathResult = null;
            try {
                XPath xpath = DomUtilities.newXPath();
                xPathResult = (NodeList)xpath.evaluate(xPathStr, configurationElement, XPathConstants.NODESET);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xPathResult == null || xPathResult.getLength() > 0) {
                result = this.ifElement.getChildNodes();
            }
        }
        return result;
    }
}

