/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Description.java,v 1.1 2008/11/15 22:09:47 tzimber Exp $
 */
package ch.e2e.examples.list;

/**
 * Name, short and detailed description of a product.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Description {
	/**
	 * The name of the product.
	 */
	private String name;
	/**
	 * The short description of the product.
	 */
	private String shortDescription;
	/**
	 * The detailed description of the product.
	 */
	private String detailedDescription;

	/**
	 * Returns the detailed description of the product.
	 * @return The detailed description of the product.
	 */
	public String getDetailedDescription() {
		return detailedDescription;
	}

	/**
	 * Sets the detailed description of the product.
	 * @param detailedDescription The detailed description of the product.
	 */
	public void setDetailedDescription(String detailedDescription) {
		this.detailedDescription = detailedDescription;
	}

	/**
	 * Returns the name of the product.
	 * @return The name of the product.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of the product.
	 * @param name The name of the product.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the short description of the product.
	 * @return The short description of the product.
	 */
	public String getShortDescription() {
		return shortDescription;
	}

	/**
	 * Sets the short description of the product.
	 * @param shortDescription The short description of the product.
	 */
	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}
}
