/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.mq.jms.admin.AdminService;
import com.ibm.mq.jms.admin.BAO;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;

public class JMSAdmin {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/admin/JMSAdmin.java, jms, j600, j600-101-060328 1.75.1.2 06/01/30 15:22:54";
    private static final String DEF_CONFIG_FILENAME = "JMSAdmin.config";
    private static final String CLASSNAME = "com.ibm.mq.jms.admin.JMSAdmin";
    private static final int VERB_NON = -1;
    private static final int VERB_END = 0;
    private static final int VERB_DEF = 1;
    private static final int VERB_CHG = 2;
    private static final int VERB_DIS = 3;
    private static final int VERB_DEL = 4;
    private static final int VERB_COP = 5;
    private static final int VERB_MOV = 6;
    private static final int VERB_ALT = 7;
    private static JMSAdmin program = null;
    private AdminService service;
    private boolean verbose;
    private String cfgFilename;
    private String icf;
    private String purl;
    private String auth;
    private String userdn;
    private String userpw;
    protected static PrintWriter pw = null;
    private BufferedReader in;
    private Properties config;
    private String wildCardCharacter;

    protected JMSAdmin(boolean bl, Properties properties, AdminService adminService, PrintWriter printWriter) {
        this.service = null;
        this.verbose = false;
        this.cfgFilename = DEF_CONFIG_FILENAME;
        this.icf = null;
        this.purl = null;
        this.auth = "none";
        this.userdn = null;
        this.userpw = null;
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.wildCardCharacter = "*";
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.verbose = bl;
        this.cfgFilename = "UNDEFINED";
        if (printWriter == null) {
            JMSAdmin.initializePW();
        } else {
            pw = printWriter;
        }
        if (properties != null) {
            this.setConfigVariables(properties);
        }
        if (adminService != null) {
            this.service = adminService;
        }
        this.checkServiceActive(this.service);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    private void checkServiceActive(AdminService adminService) {
        if (Trace.isOn) {
            Trace.entry(this, "checkServiceActive");
        }
        if (adminService == null || !adminService.isActive()) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4110"));
            pw.flush();
            if (Trace.isOn) {
                Trace.trace(this, "Unable to initialise JNDI. Calling System.exit()");
            }
            System.exit(-1);
        } else if (this.verbose) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4003"));
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkServiceActive");
        }
    }

    private JMSAdmin(boolean bl, String string) {
        block16: {
            this.service = null;
            this.verbose = false;
            this.cfgFilename = DEF_CONFIG_FILENAME;
            this.icf = null;
            this.purl = null;
            this.auth = "none";
            this.userdn = null;
            this.userpw = null;
            this.in = new BufferedReader(new InputStreamReader(System.in));
            this.wildCardCharacter = "*";
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            this.verbose = bl;
            this.cfgFilename = string;
            if (pw == null) {
                JMSAdmin.initializePW();
            }
            this.loadConfig(this.cfgFilename);
            try {
                this.service = new AdminService(this.icf, this.purl, this.auth, this.config);
            }
            catch (JMSSecurityException jMSSecurityException) {
                pw.println((Object)jMSSecurityException);
                pw.flush();
            }
            pw.println();
            pw.println(ConfigEnvironment.getMessage("MQJMS1003"));
            pw.println(ConfigEnvironment.getMessage("MQJMS4000"));
            pw.println();
            pw.flush();
            try {
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4002"));
                    pw.println("   " + ConfigEnvironment.getMessage("MQJMS4094") + ": " + this.service.getICF());
                    pw.println("   " + ConfigEnvironment.getMessage("MQJMS4095") + ": " + this.service.getPURL());
                    pw.flush();
                }
                if (this.service.needsAuthorization()) {
                    if (this.userdn == null) {
                        pw.print(ConfigEnvironment.getMessage("MQJMS4134") + ": ");
                        pw.flush();
                        this.userdn = this.in.readLine();
                    }
                    if (this.userpw == null) {
                        pw.print(ConfigEnvironment.getMessage("MQJMS4135") + ": ");
                        pw.flush();
                        this.userpw = this.in.readLine();
                    }
                    pw.println("");
                    pw.flush();
                }
                this.service.initJNDI(this.userdn, this.userpw);
            }
            catch (Exception exception) {
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4008") + ": " + exception);
                    pw.flush();
                }
                if (Trace.isOn) {
                    Trace.exception(this, "constructor", (Throwable)exception);
                    Trace.trace(this, "Unable to initialise JNDI. Calling System.exit()");
                }
                System.exit(-1);
            }
            this.checkServiceActive(this.service);
            this.commandLoop();
            try {
                this.service.stopJNDI();
            }
            catch (Exception exception) {
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4008") + ": " + exception);
                    pw.flush();
                }
                if (!Trace.isOn) break block16;
                Trace.exception(this, "constructor", (Throwable)exception);
                Trace.trace(this, "Unable to stop JNDI. ");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    private void commandLoop() {
        block17: {
            boolean bl = true;
            String string = null;
            int n = 1;
            if (Trace.isOn) {
                Trace.entry(this, "commandLoop");
            }
            if (this.verbose) {
                pw.println("\n" + ConfigEnvironment.getMessage("MQJMS4085") + "\n");
            }
            pw.flush();
            while (bl) {
                StringBuffer stringBuffer;
                block16: {
                    pw.print(this.service.getPathString() + "> ");
                    pw.flush();
                    stringBuffer = new StringBuffer();
                    try {
                        boolean bl2 = true;
                        while (bl2) {
                            string = this.in.readLine();
                            if (string == null) continue;
                            if (string.length() == 0) {
                                bl2 = false;
                            } else if (string.charAt(0) == '*' || string.charAt(0) == '#' || string.charAt(0) == '/') {
                                string = "";
                                bl2 = false;
                            } else if (string.charAt(string.length() - 1) != '+') {
                                bl2 = false;
                            } else {
                                string = string.substring(0, string.length() - 1);
                            }
                            if (string.length() <= 0) continue;
                            stringBuffer.append(" " + string);
                        }
                    }
                    catch (IOException iOException) {
                        pw.println(ConfigEnvironment.getMessage("MQJMS4086") + ": " + iOException);
                        pw.flush();
                        if (!Trace.isOn) break block16;
                        Trace.exception(this, "commandLoop", (Throwable)iOException);
                    }
                }
                if ((string = stringBuffer.toString()).length() <= 0) continue;
                ++n;
                if (this.execCommand(string)) continue;
                bl = false;
            }
            try {
                this.in.close();
                pw.flush();
            }
            catch (IOException iOException) {
                if (this.verbose) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4008") + ": " + iOException);
                    pw.flush();
                }
                if (!Trace.isOn) break block17;
                Trace.exception(this, "commandLoop", (Throwable)iOException);
            }
        }
        this.exitMessage();
        if (Trace.isOn) {
            Trace.exit(this, "commandLoop");
        }
    }

    protected boolean execCommand(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "execCommand");
        }
        boolean bl = true;
        Command command = new Command(string);
        if (command.getArgCount() == -1) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4120"));
            pw.flush();
            if (Trace.isOn) {
                Trace.trace(this, "Minimum/maximum number of args rule has been broken");
                Trace.trace(this, "The input line was: " + string);
            }
        } else {
            int n = command.getVerb();
            if (n == 0) {
                if (command.getObjType() == -1 && command.getObjName() == null) {
                    bl = false;
                } else {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4120"));
                }
                pw.flush();
            } else if (n == 1) {
                this.doDefine(command);
            } else if (n == 7) {
                this.doAlter(command);
            } else if (n == 2) {
                if (command.getObjType() == -2) {
                    String string2 = command.getObjName();
                    try {
                        this.service.chContext(string2);
                    }
                    catch (Exception exception) {
                        pw.println(ConfigEnvironment.getMessage("MQJMS4097"));
                        pw.flush();
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Tried to CHG a non-context object");
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS4120"));
                    pw.flush();
                }
            } else if (n == 3) {
                if (command.getObjType() == -2) {
                    if (command.getObjName() == null && command.getArgCount() == 0) {
                        this.doDisplayCtx();
                    } else {
                        pw.println(ConfigEnvironment.getMessage("MQJMS4120"));
                    }
                } else if (command.getArgCount() == -1) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4120"));
                } else {
                    this.doDisplay(command);
                }
            } else if (n == 4) {
                if (command.getObjType() == -2) {
                    this.doDeleteCtx(command.getObjName());
                } else {
                    this.doDelete(command);
                }
            } else if (n == 5) {
                this.doCopy(command);
            } else if (n == 6) {
                this.doMove(command);
            } else if (command.getVerbString() != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unknown command: " + string);
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS4087") + ": " + command.getVerbString());
            }
        }
        pw.println("");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit(this, "execCommand");
        }
        return bl;
    }

    private void loadConfig(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "loadConfig");
        }
        this.config = new Properties();
        try {
            this.config.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            try {
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("file.separator");
                    }
                });
                String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("MQ_JAVA_INSTALL_PATH");
                    }
                }) + string2 + "bin" + string2 + string;
                if (Trace.isOn) {
                    Trace.trace(this, "Unable to find config file: " + string);
                    Trace.trace(this, "Performing extended search...");
                    Trace.trace(this, "Trying: " + string3);
                }
                this.config.load(new FileInputStream(string3));
            }
            catch (IOException iOException2) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4121") + ": " + string);
                if (this.verbose) {
                    pw.println("\n" + iOException2);
                }
                pw.flush();
                if (Trace.isOn) {
                    Trace.trace(this, "Extended search failed!");
                    Trace.exception(this, "loadConfig", (Throwable)iOException2);
                    Trace.exit(this, "loadConfig");
                }
                return;
            }
        }
        this.setConfigVariables(this.config);
        if (Trace.isOn) {
            Trace.exit(this, "loadConfig");
        }
    }

    private void setConfigVariables(Properties properties) {
        if (Trace.isOn) {
            Trace.entry(this, "setConfigVariables");
        }
        this.icf = properties.getProperty("INITIAL_CONTEXT_FACTORY");
        this.purl = properties.getProperty("PROVIDER_URL");
        String string = properties.getProperty("SECURITY_AUTHENTICATION");
        this.userdn = properties.getProperty("PROVIDER_USERDN");
        this.userpw = properties.getProperty("PROVIDER_PASSWORD");
        if (this.icf == null || this.purl == null) {
            Exception exception = new Exception(ConfigEnvironment.getMessage("MQJMS4105"));
            pw.println(exception);
            pw.flush();
            if (Trace.isOn) {
                Trace.exception(this, "loadConfig", (Throwable)exception);
                Trace.exit(this, "loadConfig");
            }
            return;
        }
        this.icf = this.icf.trim();
        this.purl = this.purl.trim();
        if (string != null) {
            this.auth = string;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setConfigVariables");
        }
    }

    private void doDefine(Command command) {
        block26: {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "doDefine");
            }
            AdminObject adminObject = null;
            if (command.getObjType() == -2) {
                String string = command.getObjName();
                try {
                    this.service.mkContext(string);
                }
                catch (Exception exception) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4111"));
                    if (this.verbose) {
                        pw.println("\n" + exception);
                    }
                    pw.flush();
                    if (Trace.isOn) {
                        Trace.exception(this, "doDefine", (Throwable)exception);
                    }
                    break block26;
                }
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = command.getArgCount();
            for (n = 0; n < n2; ++n) {
                if (command.getArgValue(n) != null) {
                    if (command.getArgValue(n).length() <= 0) continue;
                    hashtable.put(command.getArgName(n), command.getArgValue(n));
                    continue;
                }
                hashtable.put(command.getArgName(n), "<null>");
            }
            adminObject = new AdminObject(command.getObjType(), hashtable);
            if (adminObject.errorRaised()) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4112"));
                pw.flush();
                n = adminObject.getErrorType();
                switch (n) {
                    case 0: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_LEX on " + adminObject.getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4129", adminObject.getErrorString1()));
                        pw.flush();
                        break;
                    }
                    case 1: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_SYN_INVALID on " + adminObject.getErrorString2() + " for a " + adminObject.getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4125", adminObject.getErrorString1(), adminObject.getErrorString2()));
                        pw.flush();
                        break;
                    }
                    case 3: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_SEM on " + adminObject.getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4127") + ": " + adminObject.getErrorString1());
                        pw.flush();
                        break;
                    }
                    case 4: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_PRAG on " + adminObject.getErrorString2() + " for a " + adminObject.getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4128", adminObject.getErrorString1(), adminObject.getErrorString2()));
                        pw.flush();
                        break;
                    }
                    case 5: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_OTHER on " + adminObject.getErrorString1());
                        }
                        pw.println(adminObject.getErrorString1());
                        pw.flush();
                    }
                }
                adminObject.resetError();
            } else {
                try {
                    this.service.bind(command.getObjName(), adminObject);
                }
                catch (Exception exception) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4113"));
                    if (this.verbose) {
                        pw.println("\n" + exception);
                    }
                    pw.flush();
                    if (!Trace.isOn) break block26;
                    Trace.exception(this, "doDefine", (Throwable)exception);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "doDefine");
        }
    }

    private void doAlter(Command command) {
        block42: {
            Object object;
            AdminObject adminObject;
            int n;
            block41: {
                if (Trace.isOn) {
                    Trace.entry(this, "doAlter");
                }
                n = command.getObjType();
                String string = command.getObjName();
                adminObject = null;
                if (string == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "alias was null; exiting");
                        Trace.exit(this, "doAlter");
                    }
                    return;
                }
                try {
                    adminObject = this.service.get(string);
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.exception(this, "doAlter", (Throwable)exception);
                    }
                    if (!this.verbose) break block41;
                    pw.println(ConfigEnvironment.getMessage("MQJMS4008") + ": " + exception);
                    pw.flush();
                }
            }
            if (adminObject == null) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.trace(this, "Didn't retrieve an object to copy");
                    Trace.exit(this, "doAlter");
                }
                return;
            }
            if (!this.objectTypeMatch(n, adminObject.getType())) {
                if (Trace.isOn) {
                    Trace.trace(this, "object types didn't match");
                    Trace.exit(this, "doCopy");
                }
                return;
            }
            Hashtable hashtable = adminObject.getProperties();
            if (this.isConnectionFactoryObject(adminObject) && hashtable.get("TRANSPORT") != null) {
                if (hashtable.get("TRANSPORT").equals("BIND")) {
                    this.removeClientProperties(hashtable);
                    this.removeDirectProperties(hashtable);
                }
                if (hashtable.get("TRANSPORT").equals("CLIENT")) {
                    this.removeDirectProperties(hashtable);
                }
            }
            String string = null;
            if (hashtable.get("TRANSPORT") != null) {
                string = hashtable.get("TRANSPORT").toString().toUpperCase();
            }
            int n2 = command.getArgCount();
            for (int i = 0; i < n2; ++i) {
                if (command.getArgValue(i) == null || command.getArgValue(i).length() == 0) {
                    object = this.toLongName(command.getArgName(i));
                    if (object != null) {
                        hashtable.remove(object);
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Unable to get longname for property '" + command.getArgName(i) + "'.");
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS4125", adminObject.getObject().getClass().getName(), command.getArgName(i)));
                    pw.flush();
                    continue;
                }
                object = command.getArgName(i);
                String string2 = command.getArgValue(i);
                String string3 = this.toLongName((String)object);
                if (string3 == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Unable to get longname for property '" + (String)object + "'.");
                    }
                    pw.println(ConfigEnvironment.getMessage("MQJMS4125", adminObject.getObject().getClass().getName(), object));
                    pw.flush();
                    continue;
                }
                hashtable.put(string3, string2);
            }
            hashtable.remove("VERSION");
            String string4 = null;
            if (hashtable.get("TRANSPORT") != null) {
                string4 = hashtable.get("TRANSPORT").toString().toUpperCase();
            }
            if (this.isConnectionFactoryObject(adminObject)) {
                if (string.equals("CLIENT") && string4.equals("BIND")) {
                    this.removeClientProperties(hashtable);
                    this.removeDirectProperties(hashtable);
                }
                if (string.equals("DIRECT") && string4.equals("BIND")) {
                    this.removeClientProperties(hashtable);
                    this.removeDirectProperties(hashtable);
                }
                if (string.equals("DIRECTHTTP") && string4.equals("BIND")) {
                    this.removeClientProperties(hashtable);
                }
            }
            if (((AdminObject)(object = new AdminObject(command.getObjType(), hashtable))).errorRaised()) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4112"));
                pw.flush();
                int n3 = ((AdminObject)object).getErrorType();
                switch (n3) {
                    case 0: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_LEX on " + ((AdminObject)object).getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4129", ((AdminObject)object).getErrorString1()));
                        pw.flush();
                        break;
                    }
                    case 1: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_SYN_INVALID on " + ((AdminObject)object).getErrorString2() + " for a " + ((AdminObject)object).getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4125", ((AdminObject)object).getErrorString1(), ((AdminObject)object).getErrorString2()));
                        pw.flush();
                        break;
                    }
                    case 3: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_SEM on " + ((AdminObject)object).getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4127") + ": " + ((AdminObject)object).getErrorString1());
                        pw.flush();
                        break;
                    }
                    case 4: {
                        if (Trace.isOn) {
                            Trace.trace(this, "AdminObject ctor returned ERROR_PRAG on " + ((AdminObject)object).getErrorString2() + " for a " + ((AdminObject)object).getErrorString1());
                        }
                        pw.println(ConfigEnvironment.getMessage("MQJMS4128", ((AdminObject)object).getErrorString1(), ((AdminObject)object).getErrorString2()));
                        pw.flush();
                    }
                }
                ((AdminObject)object).resetError();
            } else {
                try {
                    this.service.rebind(command.getObjName(), (AdminObject)object);
                }
                catch (Exception exception) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4113"));
                    if (this.verbose) {
                        pw.println("\n" + exception);
                    }
                    pw.flush();
                    if (!Trace.isOn) break block42;
                    Trace.exception(this, "doAlter", (Throwable)exception);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "doAlter");
        }
    }

    private boolean isConnectionFactoryObject(AdminObject adminObject) {
        try {
            BAO bAO = (BAO)adminObject.getBAOObject();
            return bAO.name().indexOf("QCF") != -1 || bAO.name().indexOf("TCF") != -1 || bAO.name().indexOf("CF") != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void removeClientProperties(Hashtable hashtable) {
        hashtable.remove("HOSTNAME");
        hashtable.remove("CHANNEL");
        hashtable.remove("RECEXIT");
        hashtable.remove("RECEXITINIT");
        hashtable.remove("SECEXIT");
        hashtable.remove("SECEXITINIT");
        hashtable.remove("SENDEXIT");
        hashtable.remove("SENDEXITINIT");
        hashtable.remove("SSLCIPHERSUITE");
        hashtable.remove("SSLCRL");
        hashtable.remove("SSLPEERNAME");
        hashtable.remove("SENDEXIT");
        hashtable.remove("SSLPEERNAME");
        hashtable.remove("PORT");
        hashtable.remove("CCSID");
        hashtable.remove("LOCALADDRESS");
        hashtable.remove("SSLRESETCOUNT");
        hashtable.remove("SSLFIPSREQUIRED");
        hashtable.remove("CCDTURL");
    }

    private void removeDirectProperties(Hashtable hashtable) {
        hashtable.remove("MULTICAST");
        hashtable.remove("PROXYHOSTNAME");
        hashtable.remove("PROXYPORT");
        hashtable.remove("DIRECTAUTH");
        hashtable.remove("MAXBUFFSIZE");
    }

    private String toLongName(String string) {
        return AP.getLongName(string);
    }

    private void doCopy(Command command) {
        block14: {
            AdminObject adminObject;
            int n;
            block13: {
                if (Trace.isOn) {
                    Trace.entry(this, "doCopy");
                }
                n = command.getObjType();
                String string = command.getObjName();
                adminObject = null;
                if (string == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "alias was null; exiting");
                        Trace.exit(this, "doCopy");
                    }
                    return;
                }
                try {
                    adminObject = this.service.get(string);
                }
                catch (Exception exception) {
                    if (!Trace.isOn) break block13;
                    Trace.exception(this, "doCopy", (Throwable)exception);
                }
            }
            if (adminObject == null) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.trace(this, "Didn't retrieve an object to copy");
                    Trace.exit(this, "doCopy");
                }
                return;
            }
            if (!this.objectTypeMatch(n, adminObject.getType())) {
                if (Trace.isOn) {
                    Trace.trace(this, "object types didn't match");
                    Trace.exit(this, "doCopy");
                }
                return;
            }
            try {
                this.service.bind(command.getArgValue(0), adminObject);
            }
            catch (Exception exception) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4113"));
                if (this.verbose) {
                    pw.println("\n" + exception);
                }
                pw.flush();
                if (!Trace.isOn) break block14;
                Trace.exception(this, "doCopy", (Throwable)exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "doCopy");
        }
    }

    private void doMove(Command command) {
        AdminObject adminObject;
        String string;
        int n;
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, "doMove");
            }
            n = command.getObjType();
            string = command.getObjName();
            adminObject = null;
            if (string == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "alias was null; exiting");
                    Trace.exit(this, "doMove");
                }
                return;
            }
            try {
                adminObject = this.service.get(string);
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block18;
                Trace.exception(this, "doCopy", (Throwable)exception);
            }
        }
        if (adminObject == null) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
            pw.flush();
            if (Trace.isOn) {
                Trace.trace(this, "Didn't retrieve an object to move");
                Trace.exit(this, "doMove");
            }
            return;
        }
        if (!this.objectTypeMatch(n, adminObject.getType())) {
            if (Trace.isOn) {
                Trace.trace(this, "object types didn't match");
                Trace.exit(this, "doMove");
            }
            return;
        }
        try {
            this.service.bind(command.getArgValue(0), adminObject);
        }
        catch (Exception exception) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4113"));
            if (this.verbose) {
                pw.println("\n" + exception);
            }
            pw.flush();
            if (Trace.isOn) {
                Trace.exception(this, "doMove", (Throwable)exception);
                Trace.exit(this, "doMove");
            }
            return;
        }
        try {
            this.service.unbind(string);
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.exception(this, "doMove", (Throwable)exception);
            }
            pw.println(ConfigEnvironment.getMessage("MQJMS4122"));
            if (this.verbose) {
                pw.println("\n" + exception);
            }
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit(this, "doMove");
        }
    }

    private void doDisplay(Command command) {
        int n = command.getObjType();
        String string = command.getObjName();
        AdminObject adminObject = null;
        if (Trace.isOn) {
            Trace.entry(this, "doDisplay");
        }
        if (string == null) {
            if (Trace.isOn) {
                Trace.exit(this, "doDisplay");
            }
            return;
        }
        if (string.indexOf(this.wildCardCharacter) != -1) {
            try {
                this.service.get(string);
            }
            catch (Exception exception) {
                this.doWildcardDisplay(command);
                if (Trace.isOn) {
                    Trace.exit(this, "doDisplay");
                }
                return;
            }
        }
        try {
            adminObject = this.service.get(string);
        }
        catch (JMSException jMSException) {
            pw.println(jMSException.getMessage());
            pw.flush();
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.exception(this, "doDisplay", (Throwable)exception);
            }
            pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
            if (this.verbose) {
                pw.println("\n" + exception);
            }
            pw.flush();
        }
        if (adminObject == null) {
            if (Trace.isOn) {
                Trace.trace(this, "Didn't retrieve an object to display");
                Trace.exit(this, "doDisplay");
            }
            return;
        }
        if (!this.objectTypeMatch(n, adminObject.getType())) {
            if (Trace.isOn) {
                Trace.trace(this, "object types didn't match");
                Trace.exit(this, "doDisplay");
            }
            return;
        }
        Hashtable hashtable = adminObject.getProperties();
        if (this.isConnectionFactoryObject(adminObject) && hashtable.get("TRANSPORT") != null) {
            if (hashtable.get("TRANSPORT").equals("BIND")) {
                this.removeClientProperties(hashtable);
                this.removeDirectProperties(hashtable);
            }
            if (hashtable.get("TRANSPORT").equals("CLIENT")) {
                this.removeDirectProperties(hashtable);
            }
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            pw.println("");
            pw.flush();
            String string2 = (String)enumeration.nextElement();
            Object v = hashtable.get(string2);
            if (Trace.isOn) {
                Trace.trace(this, "Key=" + string2);
                Trace.trace(this, "Value=" + v);
            }
            if (v != null) {
                pw.print("    " + string2 + "(" + (String)v + ")");
            } else {
                pw.print("    " + string2 + "(*error*)");
            }
            pw.flush();
        }
        pw.println("");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit(this, "doDisplay");
        }
    }

    private void doDisplayCtx() {
        block10: {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (Trace.isOn) {
                Trace.entry(this, "doDisplayCtx");
            }
            pw.print("\n  " + ConfigEnvironment.getMessage("MQJMS4089") + " " + this.service.getPathString());
            pw.flush();
            try {
                Vector vector = this.service.getContents();
                for (int i = 0; i < vector.size(); i += 2) {
                    String string = (String)vector.elementAt(i);
                    String string2 = null;
                    if (string.endsWith("Context") || string.endsWith("ContextImpl") || string.endsWith("LDAPCtx")) {
                        string2 = "[D]";
                        ++n;
                    } else if (string.endsWith("MQQueueConnectionFactory") || string.endsWith("MQTopicConnectionFactory") || string.endsWith("MQQueue") || string.endsWith("MQTopic") || string.endsWith("MQXAQueueConnectionFactory") || string.endsWith("MQXATopicConnectionFactory") || string.endsWith("JMSWrapXAQueueConnectionFactory") || string.endsWith("JMSWrapXATopicConnectionFactory") || string.endsWith("MQXAConnectionFactory") || string.endsWith("MQConnectionFactory")) {
                        string2 = " a ";
                        ++n2;
                    } else {
                        string2 = "   ";
                        ++n3;
                    }
                    String string3 = (String)vector.elementAt(i + 1);
                    string3 = this.padToLength(string3, 25, ' ');
                    if (i == 0) {
                        pw.print("\n");
                    }
                    pw.print("\n  " + string2 + " " + string3 + " " + string);
                    pw.flush();
                }
                pw.println("\n\n  " + (n + n2 + n3) + " " + ConfigEnvironment.getMessage("MQJMS4098"));
                pw.println("    " + n + " " + ConfigEnvironment.getMessage("MQJMS4099"));
                pw.println("    " + (n2 + n3) + " " + ConfigEnvironment.getMessage("MQJMS4100") + ", " + n2 + " " + ConfigEnvironment.getMessage("MQJMS4101"));
                pw.flush();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block10;
                Trace.exception(this, "doDisplayCtx", (Throwable)exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "doDisplayCtx");
        }
    }

    private void doWildcardDisplay(Command command) {
        if (Trace.isOn) {
            Trace.entry(this, "doWildcardDisplay");
        }
        int n = command.getObjType();
        String string = command.getObjName();
        String string2 = "";
        String string3 = "";
        if (Trace.isOn) {
            Trace.trace(this, "wildcard match phrase: " + string);
        }
        if (!string.equals(this.wildCardCharacter)) {
            int n2 = string.indexOf(this.wildCardCharacter);
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        try {
            Vector vector = this.service.getContents();
            String string4 = this.service.getNamePrefix();
            for (int i = 1; i < vector.size(); i += 2) {
                String string5 = (String)vector.elementAt(i);
                if (!string5.endsWith(string3) || !string5.startsWith(string2) && (string4 == null || !string5.startsWith(string4 + string2))) continue;
                if (Trace.isOn) {
                    Trace.trace(this, "passed name test: " + string5);
                }
                AdminObject adminObject = null;
                try {
                    adminObject = this.service.get(string5);
                    if (adminObject == null || n != adminObject.getType()) continue;
                    if (Trace.isOn) {
                        Trace.trace(this, "passed objectType test: " + string5);
                    }
                    BAO bAO = (BAO)adminObject.getBAOObject();
                    String string6 = bAO.name() + "(" + string5 + ")";
                    pw.print(string6);
                    if (Trace.isOn) {
                        Trace.trace(this, "spawn display command: " + string6);
                    }
                    this.doDisplay(new Command(command.getVerbString() + " " + string6));
                    pw.println("");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Trace.isOn) {
            Trace.exit(this, "doWildcardDisplay");
        }
    }

    private String padToLength(String string, int n, char c) {
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -1 * n;
        }
        if (Trace.isOn) {
            Trace.entry(this, "padToLength");
        }
        int n2 = n - string.length();
        if (Trace.isOn) {
            Trace.trace(this, "padSize is " + n2);
        }
        if (n2 < 1) {
            if (Trace.isOn) {
                Trace.exit(this, "padToLength");
            }
            return string;
        }
        StringBuffer stringBuffer = null;
        if (!bl) {
            stringBuffer = new StringBuffer(string);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(c);
            }
        } else {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(c);
            }
            stringBuffer.append(string);
        }
        if (Trace.isOn) {
            Trace.exit(this, "padToLength");
        }
        return stringBuffer.toString();
    }

    private void doDeleteCtx(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "doDeleteCtx");
        }
        try {
            this.service.rmContext(string);
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.exception(this, "doDeleteCtx", (Throwable)exception);
            }
            if (exception instanceof ContextNotEmptyException) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4009"));
                if (this.verbose) {
                    pw.println("\n" + exception);
                }
                pw.flush();
            }
            if (exception instanceof InvalidNameException) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4115"));
                if (this.verbose) {
                    pw.println("\n" + exception);
                }
                pw.flush();
            }
            pw.println(ConfigEnvironment.getMessage("MQJMS4130"));
            if (this.verbose) {
                pw.println("\n" + exception);
            }
            pw.flush();
        }
        if (Trace.isOn) {
            Trace.exit(this, "doDeleteCtx");
        }
    }

    private void doDelete(Command command) {
        block14: {
            if (Trace.isOn) {
                Trace.entry(this, "doDelete");
            }
            int n = command.getObjType();
            String string = command.getObjName();
            AdminObject adminObject = null;
            try {
                adminObject = this.service.get(string);
            }
            catch (JMSException jMSException) {
                pw.println("\n" + (Object)((Object)jMSException));
                pw.flush();
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.exception(this, "doDelete", (Throwable)exception);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Didn't retrieve an object to delete");
                }
                pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
                if (this.verbose) {
                    pw.println("\n" + exception);
                }
                pw.flush();
            }
            if (adminObject != null) {
                if (!this.objectTypeMatch(n, adminObject.getType())) {
                    if (Trace.isOn) {
                        Trace.trace(this, "object types didn't match");
                        Trace.exit(this, "doDisplay");
                    }
                    return;
                }
                try {
                    this.service.unbind(string);
                }
                catch (Exception exception) {
                    pw.println(ConfigEnvironment.getMessage("MQJMS4096"));
                    if (this.verbose) {
                        pw.println("\n" + exception);
                    }
                    pw.flush();
                    if (!Trace.isOn) break block14;
                    Trace.trace(this, "Couldn't unbind object");
                    Trace.exception(this, "doDelete", (Throwable)exception);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "doDelete");
        }
    }

    public static void initializePW() {
        if (pw == null) {
            try {
                Locale locale = Locale.getDefault();
                String string = locale.getLanguage();
                String string2 = System.getProperty("os.name");
                pw = (string2.equals("Windows NT") || string2.equals("Windows 2000") || string2.equals("Windows XP") || string2.equals("OS/2")) && (string.equals("en") || string.equals("fr") || string.equals("de") || string.equals("es") || string.equals("it") || string.equals("pt")) ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "Cp850")) : new PrintWriter(new OutputStreamWriter(System.out));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                pw = new PrintWriter(new OutputStreamWriter(System.out));
            }
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = DEF_CONFIG_FILENAME;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toUpperCase();
            if (string2.equals("-V")) {
                bl = true;
                continue;
            }
            if (string2.equals("-CFG")) {
                if (i + 1 >= stringArray.length) continue;
                string = stringArray[++i];
                continue;
            }
            if (string2.equals("-T")) {
                ConfigEnvironment.start();
                if (!Trace.isOn) continue;
                Trace.entry(CLASSNAME, "main");
                Trace.trace(CLASSNAME, "Trace started from main by -t flag");
                continue;
            }
            if (pw == null) {
                JMSAdmin.initializePW();
            }
            pw.println(ConfigEnvironment.getMessage("MQJMS5003") + ": " + stringArray[i]);
            pw.flush();
            if (!Trace.isOn) continue;
            Trace.trace(CLASSNAME, "Unrecognised flag: " + stringArray[i]);
        }
        program = new JMSAdmin(bl, string);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "main");
        }
    }

    private boolean objectTypeMatch(int n, int n2) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "objectTypeMatch");
        }
        boolean bl2 = bl = n == n2;
        if (!bl) {
            pw.println(ConfigEnvironment.getMessage("MQJMS4131"));
        }
        if (Trace.isOn) {
            Trace.exit(this, "objectTypeMatch");
        }
        return bl;
    }

    private void exitMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "exitMessage");
        }
        pw.println(ConfigEnvironment.getMessage("MQJMS4001") + "\n");
        pw.flush();
        if (Trace.isOn) {
            Trace.exit(this, "exitMessage");
        }
    }

    private class Command {
        private final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        final int VERB_NON = -1;
        final int VERB_END = 0;
        final int VERB_DEF = 1;
        final int VERB_CHG = 2;
        final int VERB_DIS = 3;
        final int VERB_DEL = 4;
        final int VERB_COP = 5;
        final int VERB_REN = 6;
        final int VERB_ALT = 7;
        private int verb = -1;
        private String verbString = null;
        private int objType = -1;
        private String objName = null;
        private int targType = -1;
        private String targName = null;
        private int numArgs = 0;
        private String[] argName = null;
        private String[] argValue = null;

        public Command(String string) {
            String string2;
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            this.numArgs = 0;
            this.verb = -1;
            this.verbString = null;
            Vector<String> vector = new Vector<String>();
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            int n2 = 0;
            boolean bl = true;
            int n3 = -1;
            if (Trace.isOn) {
                Trace.trace(this, "Starting lexical parsing");
            }
            int n4 = 0;
            for (n = 0; n < string.length() && bl; ++n) {
                char c = string.charAt(n);
                if (c == '(') {
                    if (n2 == 2) {
                        stringBuffer2.append(c);
                        ++n4;
                        continue;
                    }
                    if (n2 == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "LEX_ERROR: Cannot supply a NAME-less VALUE");
                        }
                        n3 = n;
                        bl = false;
                        continue;
                    }
                    if (n2 != 1) continue;
                    vector.addElement(stringBuffer.toString().toUpperCase());
                    stringBuffer = null;
                    stringBuffer2 = new StringBuffer();
                    n2 = 2;
                    n4 = 0;
                    continue;
                }
                if (c == ')') {
                    if (n2 == 2) {
                        if (n4 == 0) {
                            vector.addElement(stringBuffer2.toString());
                            stringBuffer2 = null;
                            n2 = 0;
                            continue;
                        }
                        stringBuffer2.append(c);
                        --n4;
                        continue;
                    }
                    if (n2 == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "LEX_ERROR: Cannot close paren without opening one first");
                        }
                        n3 = n;
                        bl = false;
                        continue;
                    }
                    if (n2 != 1) continue;
                    if (Trace.isOn) {
                        Trace.trace(this, "LEX_ERROR: Cannot close paren without opening one first");
                    }
                    n3 = n;
                    bl = false;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\n') {
                    if (n2 == 0) continue;
                    if (n2 == 2) {
                        stringBuffer2.append(c);
                        continue;
                    }
                    if (n2 != 1) continue;
                    vector.addElement(stringBuffer.toString());
                    vector.addElement(null);
                    stringBuffer = null;
                    n2 = 0;
                    continue;
                }
                if (n2 == 0) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    n2 = 1;
                    continue;
                }
                if (n2 == 1) {
                    stringBuffer.append(c);
                    continue;
                }
                if (n2 != 2) continue;
                stringBuffer2.append(c);
            }
            if (n2 == 2) {
                if (Trace.isOn) {
                    Trace.trace(this, "LEX_ERROR: Unexpected end of input");
                }
                n3 = string.length();
            } else if (n2 != 0 && n2 == 1) {
                vector.addElement(stringBuffer.toString());
                vector.addElement(null);
                stringBuffer = null;
                n2 = 0;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Finished lexical parsing");
            }
            n = vector.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            vector = null;
            if (n3 != -1) {
                pw.println(ConfigEnvironment.getMessage("MQJMS4123"));
                pw.flush();
                if (Trace.isOn) {
                    Trace.trace(this, "A lexical error occured in line: " + string);
                    Trace.exit(this, "constructor");
                }
                return;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Starting rudimentary syntax checking");
            }
            if (n == 0) {
                if (Trace.isOn) {
                    Trace.exit(this, "constructor");
                }
                return;
            }
            this.verbString = string2 = stringArray[0].toUpperCase();
            if (string2.equals("END")) {
                this.verb = 0;
            } else if (string2.equals("DEF") || string2.equals("DEFINE")) {
                this.verb = 1;
            } else if (string2.equals("CHG") || string2.equals("CHANGE")) {
                this.verb = 2;
            } else if (string2.equals("DIS") || string2.equals("DISPLAY")) {
                this.verb = 3;
            } else if (string2.equals("DEL") || string2.equals("DELETE")) {
                this.verb = 4;
            } else if (string2.equals("CP") || string2.equals("COPY")) {
                this.verb = 5;
            } else if (string2.equals("MV") || string2.equals("MOVE")) {
                this.verb = 6;
            } else if (string2.equals("ALT") || string2.equals("ALTER")) {
                this.verb = 7;
            }
            if (this.verb != -1) {
                if (Trace.isOn) {
                    Trace.trace(this, "Verb is: " + this.verbString);
                    Trace.trace(this, "TokenCount is: " + n);
                    Trace.trace(this, "Checking that these two are valid w.r.t each other...");
                }
                if (this.verb == 0) {
                    if (n != 2) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 3) {
                    if (n != 4) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 1) {
                    if (n < 4 || stringArray[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 4) {
                    if (n != 4 || stringArray[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 2) {
                    if (n != 4 || stringArray[3] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 5) {
                    if (n != 6 || stringArray[3] == null || stringArray[5] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 6) {
                    if (n != 6 || stringArray[3] == null || stringArray[5] == null) {
                        this.numArgs = -1;
                    }
                } else if (this.verb == 7 && (n < 4 || stringArray[3] == null)) {
                    this.numArgs = -1;
                }
                if (this.numArgs == -1) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Verb-TokenCount checking failed!");
                        Trace.exit(this, "constructor");
                    }
                    return;
                }
                if (this.verb != 0) {
                    String string3 = stringArray[2].toUpperCase();
                    if (string3.equals("CF")) {
                        this.objType = 8;
                    } else if (string3.equals("QCF")) {
                        this.objType = 0;
                    } else if (string3.equals("Q")) {
                        this.objType = 1;
                    } else if (string3.equals("TCF")) {
                        this.objType = 2;
                    } else if (string3.equals("T")) {
                        this.objType = 3;
                    } else if (string3.equals("CTX")) {
                        this.objType = -2;
                    } else if (string3.equals("XACF")) {
                        this.objType = 9;
                    } else if (string3.equals("XAQCF")) {
                        this.objType = 4;
                    } else if (string3.equals("XATCF")) {
                        this.objType = 5;
                    } else if (string3.equals("WSQCF")) {
                        this.objType = 6;
                    } else if (string3.equals("WSTCF")) {
                        this.objType = 7;
                    } else {
                        this.numArgs = -1;
                        if (Trace.isOn) {
                            Trace.exit(this, "constructor");
                        }
                        return;
                    }
                    this.objName = stringArray[3];
                    this.numArgs = (n - 4) / 2;
                    if (this.verb == 3) {
                        if (this.objType == -2 && this.objName != null || this.objType != -2 && this.objName == null) {
                            this.numArgs = -1;
                        }
                    } else if (this.verb == 5 || this.verb == 6) {
                        String string4 = stringArray[4].toUpperCase();
                        if (string3.equals("CF")) {
                            this.targType = 8;
                        } else if (string4.equals("QCF")) {
                            this.targType = 0;
                        } else if (string4.equals("Q")) {
                            this.targType = 1;
                        } else if (string4.equals("TCF")) {
                            this.targType = 2;
                        } else if (string4.equals("T")) {
                            this.targType = 3;
                        } else if (string4.equals("CTX")) {
                            this.targType = -2;
                        } else if (string3.equals("XACF")) {
                            this.targType = 9;
                        } else if (string4.equals("XAQCF")) {
                            this.targType = 4;
                        } else if (string4.equals("XATCF")) {
                            this.targType = 5;
                        } else if (string3.equals("WSQCF")) {
                            this.objType = 6;
                        } else if (string3.equals("WSTCF")) {
                            this.objType = 7;
                        } else {
                            this.numArgs = -1;
                        }
                        if (this.objType == -2 || this.targType == -2 || this.objType != this.targType) {
                            this.numArgs = -1;
                            if (Trace.isOn) {
                                Trace.trace(this, "In COPY or MOVE checks, found an error!");
                            }
                        }
                    } else if (this.verb == 7 && this.objType == -2) {
                        this.numArgs = -1;
                        if (Trace.isOn) {
                            Trace.trace(this, "In ALTER checks, an incorrect objType was supplied!");
                        }
                    }
                    if (!(this.objName != null && this.objName.length() != 0 || this.verb == 0 || this.verb == 3 && this.objType == -2)) {
                        if (Trace.isOn) {
                            Trace.trace(this, "objName is null, or zero-length!");
                        }
                        this.numArgs = -1;
                    }
                    if (this.numArgs == -1) {
                        if (Trace.isOn) {
                            Trace.exit(this, "constructor");
                        }
                        return;
                    }
                    if (this.numArgs > 0) {
                        this.argName = new String[this.numArgs];
                        this.argValue = new String[this.numArgs];
                        for (int i = 0; i < this.numArgs; ++i) {
                            this.argName[i] = stringArray[4 + i * 2];
                            this.argValue[i] = stringArray[5 + i * 2];
                        }
                        if (!(this.verb != 5 && this.verb != 6 || this.argValue[0] != null && this.argValue[0].length() != 0)) {
                            if (Trace.isOn) {
                                Trace.trace(this, "targName is null, or zero-length!");
                            }
                            this.numArgs = -1;
                        }
                    }
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Finished rudimentary syntax checking");
                Trace.exit(this, "contructor");
            }
        }

        public int getVerb() {
            if (Trace.isOn) {
                Trace.entry(this, "getVerb");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getVerb");
            }
            return this.verb;
        }

        public String getVerbString() {
            if (Trace.isOn) {
                Trace.entry(this, "getVerbString");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getVerbString");
            }
            return this.verbString;
        }

        public int getObjType() {
            if (Trace.isOn) {
                Trace.entry(this, "getObjType");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getObjType");
            }
            return this.objType;
        }

        public String getObjName() {
            if (Trace.isOn) {
                Trace.entry(this, "getObjName");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getObjName");
            }
            return this.objName;
        }

        public int getTargType() {
            if (Trace.isOn) {
                Trace.entry(this, "getTargType");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getTargType");
            }
            return this.targType;
        }

        public String getTargName() {
            if (Trace.isOn) {
                Trace.entry(this, "getTargName");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getTargName");
            }
            return this.targName;
        }

        public String getArgName(int n) {
            if (Trace.isOn) {
                Trace.entry(this, "getArgName");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getArgName");
            }
            return this.argName[n];
        }

        public String getArgValue(int n) {
            if (Trace.isOn) {
                Trace.entry(this, "getArgValue");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getArgValue");
            }
            return this.argValue[n];
        }

        public int getArgCount() {
            if (Trace.isOn) {
                Trace.entry(this, "getArgCount");
            }
            if (Trace.isOn) {
                Trace.exit(this, "getArgCount");
            }
            return this.numArgs;
        }
    }
}

