/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;

public class MQSessionHandle
implements Session {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQSessionHandle.java, jms, j600, j600-101-060328 1.10.1.1 05/05/25 16:00:35";
    private MQSession session;
    private MQXASession xaSession;
    protected boolean closed = false;
    protected JMSException closedException;

    protected MQSessionHandle(MQSession mQSession, MQXASession mQXASession) {
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
        this.xaSession = mQXASession;
        String string = "MQJMS1024";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        this.closedException = new IllegalStateException(string2, string);
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createBytesMessage");
            }
            BytesMessage bytesMessage = this.session.createBytesMessage();
            return bytesMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createBytesMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMessage createMapMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMapMessage");
            }
            MapMessage mapMessage = this.session.createMapMessage();
            return mapMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createMapMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMessage");
            }
            Message message = this.session.createMessage();
            return message;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage");
            }
            ObjectMessage objectMessage = this.session.createObjectMessage();
            return objectMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createObjectMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage(object)");
            }
            ObjectMessage objectMessage = this.session.createObjectMessage(serializable);
            return objectMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createObjectMessage(object)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createStreamMessage");
            }
            StreamMessage streamMessage = this.session.createStreamMessage();
            return streamMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createStreamMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage");
            }
            TextMessage textMessage = this.session.createTextMessage();
            return textMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTextMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage(stringBuffer)");
            }
            TextMessage textMessage = this.session.createTextMessage(string);
            return textMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTextMessage(stringBuffer)");
            }
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConsumer(Destination, messageSelector");
            }
            MessageConsumer messageConsumer = this.session.createConsumer(destination, string);
            return messageConsumer;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConsumer(Destination, messageSelector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConsumer(Destination, messageSelector, noLocal");
            }
            MessageConsumer messageConsumer = this.session.createConsumer(destination, string, bl);
            return messageConsumer;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConsumer(Destination, messageSelector, noLocal");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createQueue");
            }
            Queue queue = this.session.createQueue(string);
            return queue;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createProducer");
            }
            MessageProducer messageProducer = this.session.createProducer(destination);
            return messageProducer;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createProducer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAcknowledgeMode() throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "getAcknowledgeMode");
            }
            int n = this.session.getAcknowledgeMode();
            return n;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "getAcknowledgeMode");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String string) throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "createTopic");
            }
            Topic topic = this.session.createTopic(string);
            return topic;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createTopic");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "createTemporaryTopic");
            }
            TemporaryTopic temporaryTopic = this.session.createTemporaryTopic();
            return temporaryTopic;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createTemporaryTopic");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String string) throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "unsubscribe");
            }
            this.session.unsubscribe(string);
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "unsubscribe");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "createDurableSubscriber(Topic t, String name)");
            }
            TopicSubscriber topicSubscriber = this.session.createDurableSubscriber(topic, string);
            return topicSubscriber;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createDurableSubscriber(Topic t, String name)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "createDurableSubscriber(Topic t, String nameString selector, boolean noLocal)");
            }
            TopicSubscriber topicSubscriber = this.session.createDurableSubscriber(topic, string, string2, bl);
            return topicSubscriber;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createDurableSubscriber(Topic t, String name, String selector, boolean noLocal)");
            }
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createSender");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueSender queueSender = this.session.createQSender(queue);
            return queueSender;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createSender");
            }
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createReceiver");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueReceiver queueReceiver = this.session.createQReceiver(queue, string);
            return queueReceiver;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createReceiver");
            }
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTemporaryQueue");
            }
            if (this.closed) {
                throw this.closedException;
            }
            TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
            return temporaryQueue;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTemporaryQueue");
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "CreateBrowser");
            }
            if (this.closed) {
                throw this.closedException;
            }
            QueueBrowser queueBrowser = this.session.createBrowser(queue, string);
            return queueBrowser;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueBrowser");
            }
        }
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.session.createTSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        return this.session.createTSubscriber(topic, string, bl);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.session.createTPublisher(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            if (this.closed) {
                if (Trace.isOn) {
                    Trace.trace(this, "already closed");
                }
            } else {
                if (this.session != null) {
                    this.session.closeAllChildren();
                }
                if (this.xaSession != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "XXX Callback mechanism not implemented");
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "xaSession is null - can't notify on close");
                }
                this.closed = true;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    public void commit() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS3027");
        throw new TransactionInProgressException(string);
    }

    public void rollback() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS3027");
        throw new TransactionInProgressException(string);
    }

    public void recover() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new IllegalStateException(string);
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public MessageListener getMessageListener() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "getMessageListener");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1010");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            if (Trace.isOn) {
                Trace.exit(this, "getMessageListener");
            }
            throw throwable;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setMessageListener");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1010");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageListener");
            }
            throw throwable;
        }
    }

    public void run() {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "run");
                }
                String string = ConfigEnvironment.getErrorMessage("MQJMS1010");
                RuntimeException runtimeException = new RuntimeException(string);
                throw runtimeException;
            }
            catch (RuntimeException runtimeException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + runtimeException);
                }
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            if (Trace.isOn) {
                Trace.exit(this, "run");
            }
            throw throwable;
        }
    }
}

