/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.MatchingException;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.DLH;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionBrowser;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SearchResults;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.jms.JMSException;

abstract class MQQueueAgentThread
implements Runnable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueAgentThread.java, jms, j600, j600-101-060328 1.46.1.1 05/05/25 15:45:39";
    protected static final long SWEEP_TIMEOUT = 30000L;
    protected static final long REDELIVER_INTERVAL = 60000L;
    protected boolean startSweep = true;
    protected long sweepStartedTime;
    protected long sweepTimeoutStart = 0L;
    MQQueueAgent mqQueueAgent;
    String qmgrName;
    String qName;
    MQConnection jmsConnection;
    MQSession jmsSession;
    MQQueueManager mqQueueManager;
    MQQueue mqQueue;
    private String mqBORQName = null;
    int backoutThreshold;
    boolean retainMessages = false;
    boolean redeliverUnwanted = false;
    private boolean fullMessages = true;
    private boolean active = false;
    private boolean quit = false;
    private JMSException exception = null;
    int oldCount;
    int newCount;
    int failedCount;
    private Thread thread;
    int browserChoice = 0;
    private boolean messagesToDeliver = false;
    protected MQGetMessageOptions mqGMO = null;
    protected int options;

    MQQueueAgentThread(MQQueueAgent mQQueueAgent, MQConnection mQConnection, String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.mqQueueAgent = mQQueueAgent;
        this.jmsConnection = mQConnection;
        this.qmgrName = string;
        this.qName = string2;
        String string3 = "MQQueueAgent (" + string2 + ")";
        this.thread = MQEnvironment.createThread(this, string3, true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void go() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "go");
        }
        this.thread.start();
        MQQueueAgentThread mQQueueAgentThread = this;
        // MONITORENTER : mQQueueAgentThread
        while (!this.active && this.exception == null) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "go() waiting for thread to start up");
                }
                this.wait();
                if (!Trace.isOn) continue;
                Trace.trace(this, "go() woken up");
            }
            catch (InterruptedException interruptedException) {}
        }
        // MONITOREXIT : mQQueueAgentThread
        if (!Trace.isOn) return;
        Trace.exit(this, "go");
    }

    void retainAllMessages() {
        if (Trace.isOn) {
            Trace.entry(this, "retainAllMessages");
        }
        this.retainMessages = true;
        if (Trace.isOn) {
            Trace.exit(this, "retainAllMessages");
        }
    }

    void redeliverUnwanted() {
        if (Trace.isOn) {
            Trace.entry(this, "redeliverUnwanted");
        }
        this.redeliverUnwanted = true;
        if (Trace.isOn) {
            Trace.exit(this, "redeliverUnwanted");
        }
    }

    void quit() {
        if (Trace.isOn) {
            Trace.entry(this, "quit");
        }
        this.quit = true;
        if (Trace.isOn) {
            Trace.exit(this, "quit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEnd() {
        if (Trace.isOn) {
            Trace.entry(this, "waitForEnd");
            Trace.trace(this, "Waiting for thread to finish");
        }
        MQQueueAgentThread mQQueueAgentThread = this;
        synchronized (mQQueueAgentThread) {
            while (this.active && this.exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "waitForEnd");
        }
    }

    void setup() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setup");
        }
        try {
            this.mqQueueManager = this.jmsConnection.createQMNonXA();
            this.jmsSession = this.jmsConnection instanceof MQQueueConnection ? new MQQueueSession((MQQueueConnection)this.jmsConnection, this.mqQueueManager, false, 0) : (this.jmsConnection instanceof MQTopicConnection ? new MQTopicSession((MQTopicConnection)this.jmsConnection, this.mqQueueManager, false, 0) : new MQSession(this.jmsConnection, this.mqQueueManager, false, 0));
            if (Trace.isOn) {
                Trace.trace(this, "session created");
            }
            try {
                this.mqQueue = this.mqQueueManager.accessQueue(this.qName, this.options);
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", this.qName);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + mQException);
                }
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            this.mqGMO.options |= 0x2000;
            this.mqGMO.matchOptions = 0;
            this.backoutThreshold = Utils.inquireInt(this.mqQueue, 22);
            if (this.backoutThreshold == -1) {
                if (Trace.isOn) {
                    Trace.trace(this, "Inquire on backoutThreshold failed. Defaulting to 20.");
                }
                this.backoutThreshold = 20;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            try {
                if (this.jmsSession != null) {
                    this.jmsSession.close();
                }
                if (this.mqQueueManager != null) {
                    this.mqQueueManager.disconnect();
                }
            }
            catch (JMSException jMSException2) {
            }
            catch (MQException mQException) {
                // empty catch block
            }
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            this.mqGMO = null;
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setup");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void shutdown() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "shutdown");
        }
        try {
            block6: {
                try {
                    if (this.jmsSession == null) break block6;
                    this.jmsSession.close();
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.exception(this, "shutdown", (Throwable)jMSException);
                    }
                    Object var3_2 = null;
                    this.jmsSession = null;
                    this.mqQueueManager = null;
                    this.mqQueue = null;
                    if (!Trace.isOn) return;
                    Trace.exit(this, "shutdown");
                    return;
                }
            }
            Object var3_1 = null;
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "shutdown");
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "shutdown");
            throw throwable;
        }
    }

    abstract MQMessageReference browse(int var1, long var2) throws JMSException;

    abstract boolean updateConfig() throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void processMessage(MQMessageReference var1_1) throws JMSException {
        var2_2 = this.mqQueueAgent.browsers;
        synchronized (var2_2) {
            block86: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "processMessage");
                    }
                    var3_3 = 0;
                    var4_5 = null;
                    var5_6 = null;
                    var6_7 = null;
                    var7_8 = var1_1.getMQJMSMessage();
                    var8_9 = true;
                    if (this.backoutThreshold != 0 && var1_1.getBackoutCount() >= this.backoutThreshold) {
                        if (Trace.isOn) {
                            Trace.trace(this, "backoutThreshold reached");
                        }
                        var8_9 = false;
                        try {
                            this.backoutRequeue(var1_1);
                        }
                        catch (JMSException var9_10) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Message requeue failed. Treating itas a bad message");
                            }
                            var11_20 = (var10_17 = var9_10.getLinkedException()) != null && var10_17 instanceof MQException != false ? ((MQException)var10_17).reasonCode : 2362;
                            try {
                                this.removeBadMessage(var1_1, var11_20);
                            }
                            catch (JMSException var12_22) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "removeBadMessage failed with exception:");
                                    Trace.trace(this, "" + (Object)var12_22);
                                    Trace.trace(this, "throwing exception from backoutRequeue");
                                }
                                throw var9_10;
                            }
                        }
                    }
                    if (var8_9 && var1_1.getDataQuantity() != 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Checking format of message");
                        }
                        try {
                            var9_11 = var1_1.getJMSMessage();
                        }
                        catch (JMSException var9_12) {
                            if (Trace.isOn) {
                                Trace.exception(this, "Message is badly formatted", (Throwable)var9_12);
                            }
                            var8_9 = false;
                            try {
                                this.removeBadMessage(var1_1, 2364);
                            }
                            catch (JMSException var10_18) {
                                if (Trace.isOn) {
                                    Trace.exception(this, "removeBadMessage failed with ", (Throwable)var10_18);
                                }
                                throw var10_18;
                            }
                        }
                    }
                    if (!var8_9) break block86;
                    var1_1.setReferenceQueue(this.qName);
                    var1_1.setDomain(this.mqQueueAgent.getDomain());
                    switch (this.mqQueueAgent.getDomain()) {
                        case 0: {
                            if (Trace.isOn) {
                                Trace.trace(this, "In the PtP domain");
                            }
                            var4_5 = new Vector();
                            if (this.mqQueueAgent.useSelectors > 0) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Selectors in use");
                                }
                                try {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Checking for suitable browsers");
                                    }
                                    var9_11 = new SearchResults();
                                    this.mqQueueAgent.getMatches(MQQueueAgent.PTPTOPIC, var1_1, (SearchResults)var9_11);
                                    if (var9_11.m_receivers.m_count <= 0) ** GOTO lbl89
                                    if (Trace.isOn) {
                                        Trace.trace(this, var9_11.m_receivers.m_count + " matches found");
                                    }
                                    var10_17 = var9_11.m_receivers;
                                    var4_5 = var10_17.makeVector();
                                }
                                catch (MatchingException var9_13) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "MatchingException thrown trying to get suitable browser matches");
                                        Trace.exception(this, "processMessage", (Throwable)var9_13);
                                    }
                                    var10_17 = ConfigEnvironment.newException("MQJMS6233", (Object)var9_13);
                                    var10_17.setLinkedException((Exception)var9_13);
                                    throw var10_17;
                                }
                                catch (BadMessageFormatMatchingException var9_14) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "BadMessageFormatException thrown trying to get suitable browser matches");
                                        Trace.exception(this, "processMessage", (Throwable)var9_14);
                                    }
                                    var10_17 = ConfigEnvironment.newException("MQJMS6233", (Object)var9_14);
                                    var10_17.setLinkedException((Exception)var9_14);
                                    throw var10_17;
                                }
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(this, "No Selectors in use, all browsers are suitable");
                                }
                                var4_5 = this.mqQueueAgent.getBrowsers();
                            }
lbl89:
                            // 3 sources

                            if (var4_5.size() == 0) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "No Suitable browsers found. Setting message unwanted");
                                }
                                var1_1.setIsWanted(false);
                                if (!this.retainMessages) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "MessageRetention off, removing the message");
                                    }
                                    this.removeBadMessage(var1_1, 2363);
                                    ** break;
lbl98:
                                    // 1 sources

                                } else if (Trace.isOn) {
                                    Trace.trace(this, "MessageRetention on, keeping message on queue");
                                    ** break;
                                }
lbl102:
                                // 3 sources

                            } else {
                                ++this.browserChoice;
                                var3_3 = this.browserChoice % var4_5.size();
                                if (Trace.isOn) {
                                    Trace.trace(this, "Choosing suitable browser: browserChoice = " + this.browserChoice + ", number of choices = " + var4_5.size() + ", choosing number " + var3_3);
                                }
                                var9_15 = false;
                                var10_19 = 0;
                                var11_20 = var4_5.size();
                                for (var12_23 = 0; var12_23 < var11_20 && !var9_15; ++var12_23) {
                                    var6_7 = (MQConnectionBrowser)var4_5.elementAt((var3_3 + var12_23) % var11_20);
                                    if (!var6_7.receiveFlag.receiving) continue;
                                    var9_15 = true;
                                    var10_19 = (var3_3 + var12_23) % var11_20;
                                }
                                if (var9_15) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Delivering to:\n" + var6_7.toString());
                                    }
                                    this.messagesToDeliver = true;
                                    this.deliverMsgRef(var6_7, var1_1);
                                    ** break;
                                }
                            }
lbl122:
                            // 3 sources

                            break;
                        }
                        case 1: {
                            if (Trace.isOn) {
                                Trace.trace(this, "In the PubSub domain");
                            }
                            var5_6 = new Hashtable();
                            var6_7 = null;
                            var5_6 = this.mqQueueAgent.getPubSubBrowserLookup();
                            if (this.mqQueueAgent.getUseCorrelId()) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Shared queue, searching for browser with correlId =" + Utils.bytesToHex(var1_1.getCorrelId()));
                                }
                                if (null == (var6_7 = (MQConnectionBrowser)var5_6.get(Utils.bytesToHex(var1_1.getCorrelId())))) {
                                    Trace.trace(this, "Could not find a suitable entry in the Hashtable");
                                }
                            } else {
                                var6_7 = (MQConnectionBrowser)var5_6.get("XXX-Exclusive-Subscriber-Key-XXX");
                            }
                            if (var6_7 == null && Trace.isOn) {
                                Trace.trace(this, "No suitable browsers found");
                            }
                            if (var6_7 != null && var6_7.getMessageSelector() != null) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiving subscription uses selectors");
                                }
                                try {
                                    if (Trace.isOn) {
                                        if (null == this.jmsConnection) {
                                            Trace.trace(this, "*** jmsConnection is null!");
                                        }
                                        Trace.trace(this, "msgSelection = " + this.jmsConnection.getMsgSelection());
                                    }
                                }
                                catch (Throwable var9_16) {
                                    // empty catch block
                                }
                                if (this.jmsConnection.getMsgSelection() != 1) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Using client side selectors");
                                    }
                                    if (!var1_1.matches(var6_7.getMessageSelector())) {
                                        var9_11 = new MQMessage();
                                        var9_11.messageId = var1_1.getMessageId();
                                        var10_17 = new MQGetMessageOptions();
                                        var10_17.options = 64;
                                        var10_17.matchOptions = 1;
                                        try {
                                            this.mqQueue.get((MQMessage)var9_11, (MQGetMessageOptions)var10_17, 0);
                                            ** break;
lbl161:
                                            // 1 sources

                                        }
                                        catch (MQException var11_21) {
                                            if (var11_21.reasonCode != 2033 && var11_21.reasonCode != 2079) {
                                                var12_24 = ConfigEnvironment.newException("MQJMS1031");
                                                var12_24.setLinkedException((Exception)var11_21);
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Unable to discard message:" + (Object)var12_24);
                                                }
                                                throw var12_24;
                                            }
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Ignoring reason code = " + var11_21.reasonCode);
                                                ** break;
                                            }
lbl172:
                                            // 3 sources

                                            break;
                                        }
                                    }
                                } else if (Trace.isOn) {
                                    Trace.trace(this, "Using Broker side selector, message should already be appropriate");
                                }
                            } else if (Trace.isOn) {
                                Trace.trace(this, "No Selectors in use, all browsers are suitable");
                            }
                            if (var6_7 != null) {
                                if (var6_7.receiveFlag.receiving) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Delivering to:\n" + var6_7.toString());
                                    }
                                    this.messagesToDeliver = true;
                                    this.deliverMsgRef(var6_7, var1_1);
                                    ** break;
lbl186:
                                    // 1 sources

                                } else if (Trace.isOn) {
                                    Trace.trace(this, "Receiver not yet active");
                                    ** break;
                                }
lbl190:
                                // 3 sources

                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(this, "No Suitable browser found. Setting message unwanted");
                                }
                                var1_1.setIsWanted(false);
                                ** break;
                            }
lbl195:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (Trace.isOn) {
                                Trace.trace(this, "Unknown domain, not doing anything");
                            }
                            break;
                        }
                    }
                }
                catch (JMSException var3_4) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Leaving via exception");
                    }
                    throw var3_4;
                }
                finally {
                    if (Trace.isOn) {
                        Trace.exit(this, "processMessage");
                    }
                }
            }
        }
    }

    protected void deliverMsgRef(MQConnectionBrowser mQConnectionBrowser, MQMessageReference mQMessageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "deliverMsgRef");
        }
        mQConnectionBrowser.deliver(mQMessageReference);
        if (Trace.isOn) {
            Trace.exit(this, "deliverMsgRef");
        }
    }

    void removeBadMessage(MQMessageReference mQMessageReference, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeBadMessage");
        }
        try {
            MQJMSMessage mQJMSMessage = mQMessageReference.getMQJMSMessage();
            if ((mQJMSMessage.getReport() & 0x8000000) == 0x8000000) {
                if (Trace.isOn) {
                    Trace.trace(this, "Discarding message as per MQMD.Report");
                }
                this.discard(mQMessageReference, n);
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Dead-lettering message as per MQMD.Report");
                }
                this.deadLetter(mQMessageReference, n);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeBadMessage");
            }
        }
    }

    private void deadLetter(MQMessageReference mQMessageReference, int n) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "deadLetter");
        }
        MQMessage mQMessage = null;
        MQMessage mQMessage2 = null;
        String string = null;
        String string2 = null;
        try {
            mQMessage = this.retrieveMessage(mQMessageReference);
            String string3 = Utils.inquireString(this.mqQueueManager, 2006);
            if (Trace.isOn) {
                Trace.trace(this, "DLQ = <" + string3 + ">");
            }
            if (string3 == null || string3.length() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unable to find DLQ name - is one defined?");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                throw jMSException;
            }
            if ((mQMessage.report & 0x7000000) != 0) {
                mQMessage2 = this.generateReport(mQMessage, n);
                string = mQMessage.replyToQueueName.trim();
                string2 = mQMessage.replyToQueueManagerName.trim();
            }
            if (Trace.isOn) {
                Trace.trace(this, "Constructing DLH");
            }
            object = new DLH();
            ((DLH)object).reason = n;
            ((DLH)object).destQName = this.qName;
            ((DLH)object).destQMgrName = this.qmgrName;
            ((DLH)object).putApplType = 28;
            ((DLH)object).putApplName = "MQ JMS ConnectionConsumer";
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            ((DLH)object).putDate = Utils.getDate(gregorianCalendar);
            ((DLH)object).putTime = Utils.getTime(gregorianCalendar);
            ((DLH)object).write(mQMessage);
            this.put1WithContext(mQMessage, string3, null);
            if (mQMessage2 != null) {
                try {
                    this.put1WithContext(mQMessage2, string, string2);
                }
                catch (MQException mQException) {
                    ((DLH)object).destQName = string;
                    ((DLH)object).destQMgrName = string2;
                    ((DLH)object).reason = mQException.reasonCode;
                    ((DLH)object).write(mQMessage2);
                    this.put1WithContext(mQMessage2, string3, null);
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to dead-letter has disappeared! Continue as normal");
                }
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exit(this, "deadLetter");
            }
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)jMSException);
                Trace.exit(this, "deadLetter");
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException) {
                // empty catch block
            }
            throw jMSException;
        }
        try {
            this.mqQueueManager.commit();
        }
        catch (MQException mQException) {
            object = ConfigEnvironment.newException("MQJMS1079");
            object.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)object);
                Trace.exception(this, "deadLetter - linked exception: ", (Throwable)mQException);
            }
            throw object;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deadLetter");
            }
        }
    }

    void backoutRequeue(MQMessageReference mQMessageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "backoutRequeue");
        }
        try {
            Object object;
            if (this.mqBORQName == null) {
                int n = Utils.inquireInt(this.mqQueue, 20);
                if (n == 3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Queue " + this.mqQueue.name + "is an ALIAS queue.");
                    }
                    object = Utils.inquireString(this.mqQueue, 2002);
                    if (Trace.isOn) {
                        Trace.trace(this, "Attempting to read Backout Requeue Queue from underlying LOCAL queue " + object);
                    }
                    try {
                        int n2 = 8232;
                        MQQueue mQQueue = this.mqQueueManager.accessQueue((String)object, n2);
                        this.mqBORQName = Utils.inquireString(mQQueue, 2019);
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                        if (Trace.isOn) {
                            Trace.trace(this, "Exception detected " + (Object)((Object)jMSException));
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + mQException);
                        }
                    }
                } else {
                    this.mqBORQName = Utils.inquireString(this.mqQueue, 2019);
                }
            }
            if (this.mqBORQName == null || this.mqBORQName.equals("")) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1080");
                throw jMSException;
            }
            this.mqBORQName = this.mqBORQName.trim();
            if (Trace.isOn) {
                Trace.trace(this, "BORQ = <" + this.mqBORQName + ">");
            }
            try {
                MQMessage mQMessage = this.retrieveMessage(mQMessageReference);
                this.put1WithContext(mQMessage, this.mqBORQName, null);
                this.mqQueueManager.commit();
            }
            catch (MQException mQException) {
                block27: {
                    if (mQException.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Message to requeue has disappeared! Continue as normal");
                        }
                    } else {
                        try {
                            this.mqQueueManager.backout();
                        }
                        catch (MQException mQException2) {
                            if (!Trace.isOn) break block27;
                            Trace.trace(this, "WARNING: backout after failed requeue failed!");
                            Trace.exception(this, "backoutRequeue", (Throwable)mQException2);
                        }
                    }
                }
                object = ConfigEnvironment.newException("MQJMS1081");
                object.setLinkedException((Exception)mQException);
                throw object;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "backoutRequeue");
            }
        }
    }

    private void discard(MQMessageReference mQMessageReference, int n) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "discard");
        }
        MQMessage mQMessage = null;
        MQMessage mQMessage2 = null;
        try {
            mQMessage = this.retrieveMessage(mQMessageReference);
            if ((mQMessage.report & 0x7000000) != 0) {
                mQMessage2 = this.generateReport(mQMessage, n);
                String string = mQMessage.replyToQueueName.trim();
                object = mQMessage.replyToQueueManagerName.trim();
                try {
                    this.put1WithContext(mQMessage2, string, (String)object);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Could not put report message to replyToQ");
                        Trace.exception(this, "discard", (Throwable)mQException);
                        Trace.trace(this, "Attempting to put to DLQ instead");
                    }
                    String string2 = Utils.inquireString(this.mqQueueManager, 2006);
                    if (Trace.isOn) {
                        Trace.trace(this, "DLQ = <" + string2 + ">");
                    }
                    if (string2 == null || string2.length() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Unable to find DLQ name - is one defined?");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                        throw jMSException;
                    }
                    DLH dLH = new DLH();
                    dLH.reason = mQException.reasonCode;
                    dLH.destQName = string;
                    dLH.destQMgrName = object;
                    dLH.putApplType = 28;
                    dLH.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dLH.putDate = Utils.getDate(gregorianCalendar);
                    dLH.putTime = Utils.getTime(gregorianCalendar);
                    dLH.write(mQMessage2);
                    this.put1WithContext(mQMessage2, string2, null);
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to discard has disappeared! Continue as normal");
                }
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1082");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)jMSException);
            }
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException) {
                // empty catch block
            }
            throw jMSException;
        }
        try {
            this.mqQueueManager.commit();
        }
        catch (MQException mQException) {
            object = ConfigEnvironment.newException("MQJMS1082");
            object.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + (Object)object);
                Trace.trace(this, "linked exception: " + mQException);
            }
            throw object;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
        }
    }

    private MQMessage generateReport(MQMessage mQMessage, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "generateReport");
        }
        MQMessage mQMessage2 = new MQMessage();
        mQMessage2.report = 0;
        mQMessage2.messageType = 4;
        mQMessage2.expiry = -1;
        mQMessage2.feedback = n;
        mQMessage2.encoding = mQMessage.encoding;
        mQMessage2.characterSet = mQMessage.characterSet;
        mQMessage2.format = mQMessage.format;
        mQMessage2.priority = mQMessage.priority;
        mQMessage2.persistence = mQMessage.persistence;
        if ((mQMessage.report & 0x80) == 128) {
            mQMessage2.messageId = mQMessage.messageId;
        }
        mQMessage2.correlationId = (mQMessage.report & 0x40) == 64 ? mQMessage.correlationId : mQMessage.messageId;
        mQMessage2.backoutCount = 0;
        mQMessage2.replyToQueueName = "";
        mQMessage2.replyToQueueManagerName = this.qmgrName;
        mQMessage2.putApplicationType = 28;
        mQMessage2.putApplicationName = "MQ JMS ConnectionConsumer";
        try {
            if ((mQMessage.report & 0x7000000) == 0x7000000) {
                byte[] byArray = new byte[mQMessage.getMessageLength()];
                mQMessage.seek(0);
                mQMessage.readFully(byArray);
                mQMessage2.write(byArray);
            } else if ((mQMessage.report & 0x3000000) == 0x3000000) {
                mQMessage.seek(0);
                int n2 = 0;
                String string = mQMessage.format;
                int n3 = mQMessage.characterSet;
                int n4 = mQMessage.encoding;
                boolean bl = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                String string2 = null;
                while (!bl) {
                    try {
                        if (string.startsWith("MQH")) {
                            mQMessage.skipBytes(8);
                            n5 = mQMessage.readInt();
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readStringOfByteLength(8);
                            mQMessage.skipBytes(n5 - 28);
                        } else if (string.equals("MQDEAD  ")) {
                            n5 = 172;
                            mQMessage.skipBytes(108);
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readStringOfByteLength(8);
                            mQMessage.skipBytes(48);
                        } else if (string.equals("MQXMIT  ")) {
                            n5 = 428;
                            mQMessage.skipBytes(128);
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readStringOfByteLength(8);
                            mQMessage.skipBytes(284);
                        } else if (string.equals("MQCICS  ")) {
                            mQMessage.skipBytes(8);
                            n5 = mQMessage.readInt();
                            mQMessage.skipBytes(8);
                            string2 = mQMessage.readStringOfByteLength(8);
                            n6 = mQMessage.encoding;
                            n7 = mQMessage.characterSet;
                            mQMessage.skipBytes(n5 - 36);
                        } else {
                            bl = true;
                        }
                        if (bl) continue;
                        n2 += n5;
                        string = string2;
                        mQMessage.encoding = n6;
                        mQMessage.characterSet = n7;
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                }
                mQMessage.encoding = n4;
                mQMessage.characterSet = n3;
                mQMessage.seek(0);
                byte[] byArray = new byte[Math.min(n2 + 100, mQMessage.getMessageLength())];
                mQMessage.readFully(byArray);
                mQMessage2.write(byArray);
            }
        }
        catch (IOException iOException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)iOException);
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + iOException);
                Trace.exit(this, "generateReport");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "generateReport");
        }
        return mQMessage2;
    }

    private MQMessage retrieveMessage(MQMessageReference mQMessageReference) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "retrieveMessage");
        }
        MQMessage mQMessage = new MQMessage();
        mQMessage.messageId = mQMessageReference.getMessageId();
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 2;
        mQGetMessageOptions.matchOptions = 1;
        this.mqQueue.get(mQMessage, mQGetMessageOptions);
        if (Trace.isOn) {
            Trace.exit(this, "retrieveMessage");
        }
        return mQMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put1WithContext(MQMessage mQMessage, String string, String string2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "put1WithContext");
        }
        MQManagedObject mQManagedObject = null;
        try {
            int n = 8720;
            mQManagedObject = this.mqQueueManager.accessQueue(string, n, string2, null, null);
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options = 514;
            mQPutMessageOptions.contextReference = this.mqQueue;
            ((MQQueue)mQManagedObject).put(mQMessage, mQPutMessageOptions);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var8_8 = null;
                if (mQManagedObject != null && mQManagedObject.isOpen()) {
                    try {
                        ((MQQueue)mQManagedObject).close();
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block10;
                        Trace.trace(this, "Could not close destination queue. Carrying on regardless.");
                        Trace.exception(this, "put1WithContext", (Throwable)mQException);
                    }
                }
            }
            throw throwable;
        }
        if (mQManagedObject != null && mQManagedObject.isOpen()) {
            try {
                ((MQQueue)mQManagedObject).close();
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not close destination queue. Carrying on regardless.");
                    Trace.exception(this, "put1WithContext", (Throwable)mQException);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "put1WithContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block64: {
            Object object2222;
            block60: {
                block59: {
                    if (Trace.isOn) {
                        Trace.entry(this, "run");
                    }
                    try {
                        this.setup();
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Exception thrown in setup");
                        }
                        throw jMSException;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "setup() returned");
                    }
                    int n = 5000;
                    MQQueueAgentThread mQQueueAgentThread = this;
                    synchronized (mQQueueAgentThread) {
                        this.active = true;
                        if (Trace.isOn) {
                            Trace.trace(this, "Notifying waiting thread");
                        }
                        this.notifyAll();
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Waiting thread notified");
                        Trace.trace(this, "quit flag is " + (this.quit ? "true" : "false"));
                    }
                    while (!this.quit) {
                        MQMessageReference mQMessageReference;
                        if (Trace.isOn) {
                            Trace.trace(this, "Starting to browse message");
                        }
                        boolean bl = false;
                        this.newCount = 0;
                        this.oldCount = 0;
                        this.failedCount = 0;
                        if (this.mqQueueAgent.configChangePending() && this.updateConfig()) {
                            this.mqQueueAgent.performConfigChange();
                        }
                        if ((mQMessageReference = this.browse(this.mqQueueAgent.getRequiredDataQuantity(), n)) != null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Got message to process");
                            }
                            this.processMessage(mQMessageReference);
                            continue;
                        }
                        if (!Trace.isOn) continue;
                        Trace.trace(this, "No message received");
                    }
                    Object var5_10 = null;
                    if (!Trace.isOn) break block59;
                    Trace.trace(this, "QueueAgent about to stop; start consumers");
                }
                this.mqQueueAgent.startBrowsers();
                if (Trace.isOn) {
                    Trace.trace(this, "new message count    : " + this.newCount);
                    Trace.trace(this, "old message count    : " + this.oldCount);
                    Trace.trace(this, "failed message count : " + this.failedCount);
                }
                try {
                    this.shutdown();
                }
                catch (JMSException object2222) {
                    if (this.exception == null) {
                        this.exception = object2222;
                    }
                }
                catch (Exception object2222) {
                    if (this.exception != null) break block60;
                    this.exception = ConfigEnvironment.newException("MQJMS1016");
                    this.exception.setLinkedException((Exception)object2222);
                }
            }
            object2222 = this;
            synchronized (object2222) {
                this.active = false;
                this.notifyAll();
            }
            if (this.exception != null) {
                this.mqQueueAgent.deliverException(this.exception);
            }
            if (Trace.isOn) {
                Trace.exit(this, "run");
            }
            break block64;
            {
                catch (JMSException jMSException) {
                    Object object32222;
                    block62: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Fatal error duing run() - leaving exception for another thread to pick up");
                            Trace.exception(this, "run", (Throwable)jMSException);
                        }
                        this.exception = jMSException;
                        Object var5_11 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "QueueAgent about to stop; start consumers");
                        }
                        this.mqQueueAgent.startBrowsers();
                        if (Trace.isOn) {
                            Trace.trace(this, "new message count    : " + this.newCount);
                            Trace.trace(this, "old message count    : " + this.oldCount);
                            Trace.trace(this, "failed message count : " + this.failedCount);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException object32222) {
                            if (this.exception == null) {
                                this.exception = object32222;
                            }
                        }
                        catch (Exception object32222) {
                            if (this.exception != null) break block62;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException((Exception)object32222);
                        }
                    }
                    object32222 = this;
                    synchronized (object32222) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                    break block64;
                }
                catch (Exception exception) {
                    Object object42222;
                    block65: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Unexpected exception thrown during run: " + exception);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        jMSException.setLinkedException(exception);
                        this.exception = jMSException;
                        Object var5_12 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "QueueAgent about to stop; start consumers");
                        }
                        this.mqQueueAgent.startBrowsers();
                        if (Trace.isOn) {
                            Trace.trace(this, "new message count    : " + this.newCount);
                            Trace.trace(this, "old message count    : " + this.oldCount);
                            Trace.trace(this, "failed message count : " + this.failedCount);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException object42222) {
                            if (this.exception == null) {
                                this.exception = object42222;
                            }
                        }
                        catch (Exception object42222) {
                            if (this.exception != null) break block65;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException((Exception)object42222);
                        }
                    }
                    object42222 = this;
                    synchronized (object42222) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                }
            }
            catch (Throwable throwable) {
                Object object52222;
                block67: {
                    Object var5_13 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "QueueAgent about to stop; start consumers");
                    }
                    this.mqQueueAgent.startBrowsers();
                    if (Trace.isOn) {
                        Trace.trace(this, "new message count    : " + this.newCount);
                        Trace.trace(this, "old message count    : " + this.oldCount);
                        Trace.trace(this, "failed message count : " + this.failedCount);
                    }
                    try {
                        this.shutdown();
                    }
                    catch (JMSException object52222) {
                        if (this.exception == null) {
                            this.exception = object52222;
                        }
                    }
                    catch (Exception object52222) {
                        if (this.exception != null) break block67;
                        this.exception = ConfigEnvironment.newException("MQJMS1016");
                        this.exception.setLinkedException((Exception)object52222);
                    }
                }
                object52222 = this;
                synchronized (object52222) {
                    this.active = false;
                    this.notifyAll();
                }
                if (this.exception != null) {
                    this.mqQueueAgent.deliverException(this.exception);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                throw throwable;
            }
        }
    }

    public void setFullMessages(boolean bl) {
        this.fullMessages = bl;
    }

    public boolean getFullMessages() {
        return this.fullMessages;
    }

    protected void deliverNow() {
        if (this.messagesToDeliver) {
            this.mqQueueAgent.startBrowsers();
            this.messagesToDeliver = false;
        }
    }
}

