/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQExternalReceiveExit;
import com.ibm.mq.MQExternalSecurityExit;
import com.ibm.mq.MQExternalSendExit;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQRRSQueueManager;
import com.ibm.mq.MQReceiveExitChain;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.MQSendExitChain;
import com.ibm.mq.jms.ConnectionBrowser;
import com.ibm.mq.jms.ExceptionDeliveryThread;
import com.ibm.mq.jms.IntErrorException;
import com.ibm.mq.jms.JMSServicesMgr;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQConnectionBrowser;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MQMigrateSubscriptionEngine;
import com.ibm.mq.jms.MQPubSubServices;
import com.ibm.mq.jms.MQQueueServices;
import com.ibm.mq.jms.MQQueueSubscriptionEngine;
import com.ibm.mq.jms.MQRRSQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQXAConnection;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.mq.jms.MessageReferenceHandler;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.net.ssl.SSLSocketFactory;

public class MQConnection
implements Connection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQConnection.java, jms, j600, j600-101-060328 1.147.1.2 05/08/30 14:49:28";
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CLOSED = 2;
    protected static final Object XAGROUP = new Object();
    protected static final Object NON_XAGROUP = new Object();
    protected String qmgrName;
    protected MQQueueManager qm;
    protected Hashtable mqProperties = new Hashtable();
    private boolean clientIDFixed = false;
    private String clientID = null;
    private int state = 0;
    private Vector sessions = new Vector();
    private Vector browsers = new Vector();
    private boolean syncpointAllGets;
    protected MQPoolToken poolToken = null;
    private int pollingInterval;
    private int rescanInterval;
    private int msgBatchSize;
    private boolean persistenceFromMD;
    protected boolean targetClientMatching = true;
    private ExceptionDeliveryThread exceptionDelivery;
    private int failIfQuiesce = 1;
    private long eoqTimeout = -1L;
    boolean mapNameStyle = true;
    protected MQQueueManager tempQqm = null;
    protected MQQueueManager initialQm = null;
    protected String qmName = null;
    protected int tmpQOpenOptions = 32;
    protected String temporaryModelQ;
    protected String tempQPrefix;
    protected int messageRetention;
    protected String connectionID = null;
    protected int tempTopicCount = 0;
    protected String brkControlQueue;
    protected String brkQueueManager;
    protected String brkPubQueue;
    protected String brkSubQueue;
    protected String brkCCSubQueue;
    protected int brkVersion;
    protected int messageSelection;
    protected int multicast;
    protected int brkOptLevel = 1;
    protected int pubAckInterval;
    protected int statusRefreshInterval;
    protected MQSubscriptionEngine subscriptionEngine;
    protected MQSession cbBrokerSession = null;
    protected Object cbBrokerSessionLock = new Object();
    protected boolean sparseSubscriptions;
    protected int receiveIsolation = 0;
    protected boolean outcomeNotification = true;
    protected int processDuration = 0;
    protected boolean optimisticPublication = false;
    private boolean supportsQAT2 = false;
    MQQueueServices qServices = null;
    MQPubSubServices psServices = null;
    JMSServicesMgr servicesMgr = null;
    protected MQConnectionFactory factory;
    private String resolvedQMName = "";

    MQConnection(MQConnectionFactory mQConnectionFactory) throws JMSException {
        this(mQConnectionFactory, null, null);
    }

    MQConnection(MQConnectionFactory mQConnectionFactory, String string, String string2) throws JMSException {
        try {
            Object object;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            MQException.log = null;
            if (mQConnectionFactory.getUseConnectionPooling()) {
                this.poolToken = MQEnvironment.addConnectionPoolToken();
            }
            this.factory = mQConnectionFactory;
            this.failIfQuiesce = mQConnectionFactory.getFailIfQuiesce();
            this.syncpointAllGets = mQConnectionFactory.getSyncpointAllGets();
            this.msgBatchSize = mQConnectionFactory.getMsgBatchSize();
            this.pollingInterval = mQConnectionFactory.getPollingInterval();
            this.rescanInterval = mQConnectionFactory.getRescanInterval();
            this.targetClientMatching = mQConnectionFactory.getTargetClientMatching();
            this.persistenceFromMD = false;
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("com.ibm.mq.jms.tuning.usePersistenceFromMD");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            });
            if (string3 != null) {
                if (string3.equalsIgnoreCase("ON")) {
                    this.persistenceFromMD = true;
                } else if (string3.equalsIgnoreCase("OFF")) {
                    this.persistenceFromMD = false;
                }
                if (Trace.isOn()) {
                    Trace.trace(this, "persistenceFromMD = " + this.persistenceFromMD);
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "cannot read tuning parameter system properties");
            }
            if (string != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting username = " + string);
                }
                this.mqProperties.put("userID", string);
                if (Trace.isOn) {
                    Trace.trace(this, "Setting AuthenticateBindings");
                }
                this.mqProperties.put("Bindings Authentication", new Boolean(true));
            }
            if (string2 != null) {
                this.mqProperties.put("password", string2);
            }
            switch (mQConnectionFactory.getTransportType()) {
                case 0: {
                    this.mqProperties.put("transport", "MQSeries Bindings");
                    if (mQConnectionFactory.getSSLCipherSuite() != null) {
                        this.mqProperties.put("SSL Cipher Suite", mQConnectionFactory.getSSLCipherSuite());
                    }
                    if (mQConnectionFactory.getConnTag() != null) {
                        this.mqProperties.put("ConnTag Property", mQConnectionFactory.getConnTag());
                    }
                    if (mQConnectionFactory.getMQConnectionOptions() == 0) break;
                    this.mqProperties.put("connectOptions", new Integer(mQConnectionFactory.getMQConnectionOptions()));
                    break;
                }
                case 3: {
                    this.mqProperties.put("transport", "MQJD");
                    break;
                }
                case 1: {
                    this.mqProperties.put("transport", "MQSeries");
                    this.mqProperties.put("CCSID", new Integer(mQConnectionFactory.getCCSID()));
                    this.mqProperties.put("channel", mQConnectionFactory.getChannel());
                    this.mqProperties.put("hostname", mQConnectionFactory.getHostName());
                    this.mqProperties.put("port", new Integer(mQConnectionFactory.getPort()));
                    this.mqProperties.put("KeyResetCount", new Integer(mQConnectionFactory.getSSLResetCount()));
                    this.mqProperties.put("SSL Fips Required", new Boolean(mQConnectionFactory.getSSLFipsRequired()));
                    if (mQConnectionFactory.getSSLCipherSuite() != null) {
                        this.mqProperties.put("SSL Cipher Suite", mQConnectionFactory.getSSLCipherSuite());
                    }
                    if (mQConnectionFactory.getSSLPeerName() != null) {
                        this.mqProperties.put("SSL Peer Name", mQConnectionFactory.getSSLPeerName());
                    }
                    if (mQConnectionFactory.getSSLCertStores() != null) {
                        this.mqProperties.put("SSL CertStores", mQConnectionFactory.getSSLCertStores());
                    }
                    if (mQConnectionFactory.getSSLSocketFactory() != null) {
                        if (mQConnectionFactory.getSSLSocketFactory() instanceof SSLSocketFactory) {
                            this.mqProperties.put("SSL Socket Factory", (SSLSocketFactory)mQConnectionFactory.getSSLSocketFactory());
                        } else {
                            throw ConfigEnvironment.newException("MQJMS1056", "sslSocketFactory");
                        }
                    }
                    if (mQConnectionFactory.getLocalAddress() != null && !mQConnectionFactory.getLocalAddress().equals("")) {
                        this.mqProperties.put("Local Address Property", mQConnectionFactory.getLocalAddress());
                    }
                    if (mQConnectionFactory.getHdrCompList() != null) {
                        this.mqProperties.put("Header Compression Property", mQConnectionFactory.getHdrCompList());
                    }
                    if (mQConnectionFactory.getMsgCompList() != null) {
                        this.mqProperties.put("Message Compression Property", mQConnectionFactory.getMsgCompList());
                    }
                    if ((object = (Object)mQConnectionFactory.getConnTag()) != null && !Utils.byteArraysEqual((byte[])object, MQConnectionOptions.MQCT_NONE)) {
                        if (Trace.isOn) {
                            Trace.trace(this, "connTag is not null");
                            Trace.trace(this, "connTag = " + object);
                            Trace.trace(this, "connTag contents = '" + Utils.bytesToHex((byte[])object) + "'");
                        }
                        this.mqProperties.put("ConnTag Property", mQConnectionFactory.getConnTag());
                    }
                    if (mQConnectionFactory.getMQConnectionOptions() != 0) {
                        this.mqProperties.put("connectOptions", new Integer(mQConnectionFactory.getMQConnectionOptions()));
                    }
                    this.supportThreeExits(mQConnectionFactory);
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(mQConnectionFactory.getTransportType()));
                    throw jMSException;
                }
            }
            if (null != (object = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Long.getLong("com.ibm.mq.jms.tuning.eoqTimeout");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            }))) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting eoqTimeout from System property = " + (Long)object);
                }
                this.eoqTimeout = (Long)object;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "cannot read eoqTimeout System property. Using default = -1");
                }
                this.eoqTimeout = -1L;
            }
        }
        catch (JMSException jMSException) {
            if (this.poolToken != null) {
                MQEnvironment.removeConnectionPoolToken(this.poolToken);
                this.poolToken = null;
            }
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQConnection(MQConnectionFactory mQConnectionFactory, String string, String string2, boolean bl) throws JMSException {
        this(mQConnectionFactory, string, string2);
        if (!bl) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1113");
            throw jMSException;
        }
        try {
            Object object;
            String string3;
            String string4;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            if ((string4 = mQConnectionFactory.getClientID()) != null) {
                this.setClientID(string4);
            }
            this.qmgrName = mQConnectionFactory.getQueueManager();
            this.temporaryModelQ = mQConnectionFactory.getTemporaryModel();
            this.messageRetention = mQConnectionFactory.getMessageRetention();
            this.tempQPrefix = mQConnectionFactory.getTempQPrefix();
            this.brkControlQueue = mQConnectionFactory.getBrokerControlQueue();
            this.brkQueueManager = mQConnectionFactory.getBrokerQueueManager();
            this.brkPubQueue = mQConnectionFactory.getBrokerPubQueue();
            this.brkSubQueue = mQConnectionFactory.getBrokerSubQueue();
            this.brkCCSubQueue = mQConnectionFactory.getBrokerCCSubQueue();
            this.brkVersion = mQConnectionFactory.getBrokerVersion();
            this.messageSelection = mQConnectionFactory.getMessageSelection();
            this.pubAckInterval = mQConnectionFactory.getPubAckInterval();
            this.statusRefreshInterval = mQConnectionFactory.getStatusRefreshInterval();
            this.sparseSubscriptions = mQConnectionFactory.getSparseSubscriptions();
            this.multicast = mQConnectionFactory.getMulticast();
            this.mapNameStyle = mQConnectionFactory.getMapNameStyle();
            if (!(mQConnectionFactory instanceof MQXAConnectionFactory) && !(mQConnectionFactory instanceof MQXATopicConnectionFactory)) {
                this.receiveIsolation = mQConnectionFactory.getReceiveIsolation();
                this.outcomeNotification = mQConnectionFactory.getOutcomeNotification();
                this.processDuration = mQConnectionFactory.getProcessDuration();
                this.optimisticPublication = mQConnectionFactory.getOptimisticPublication();
            }
            if (mQConnectionFactory != null && mQConnectionFactory.getFailIfQuiesce() == 1) {
                this.tmpQOpenOptions |= 0x2000;
            }
            if ((string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("MQJMS_SPARSE_SUBS");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            })) != null && (((String)(object = string3.toUpperCase())).equals("YES") || ((String)object).equals("TRUE"))) {
                if (Trace.isOn) {
                    Trace.trace(this, "sparseSubscriptions set by system property");
                }
                this.sparseSubscriptions = true;
            }
            if (this instanceof MQXAConnection) {
                this.initialQm = this.createQMXA();
                try {
                    this.initialQm.disconnect();
                    this.initialQm = null;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
                finally {
                    this.initialQm = null;
                }
            }
            if (this instanceof MQRRSQueueConnection) {
                this.initialQm = this.createQMNonXA();
                object = new MQRRSQueueManager(this.initialQm);
                try {
                    ((MQRRSQueueManager)object).honourRRS();
                    return;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                    jMSException.setLinkedException((Exception)mQException);
                    try {
                        this.initialQm.disconnect();
                    }
                    catch (MQException mQException2) {
                        // empty catch block
                    }
                    this.initialQm = null;
                    throw jMSException;
                }
            }
            this.initialQm = this.createQMNonXA();
            return;
        }
        catch (JMSException jMSException) {
            if (this.poolToken != null) {
                MQEnvironment.removeConnectionPoolToken(this.poolToken);
                this.poolToken = null;
            }
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor");
            }
        }
    }

    public void finalize() throws Throwable {
        block9: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS1032", exception.toString()));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
                if (!Trace.isOn) break block9;
                Trace.trace(this, "finalize caught " + exception);
            }
        }
        try {
            this.close();
            if (this.exceptionDelivery != null) {
                this.exceptionDelivery.requestShutdown();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public String getClientID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getClientID");
            Trace.trace(this, "returning clientID='" + this.clientID + "'");
            Trace.exit(this, "getClientID");
        }
        this.checkConnectionOpen();
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setClientID");
                Trace.trace(this, "Attempting setClientID( " + string + " )");
            }
            if (this.clientIDFixed) {
                String string2 = ConfigEnvironment.getErrorMessage("MQJMS3031");
                throw new IllegalStateException(string2);
            }
            if (string == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS0002");
                if (Trace.isOn) {
                    Trace.trace(this, "setClientID(null) is not allowed!");
                }
                throw jMSException;
            }
            if (this.clientID != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "clientID was already set to '" + this.clientID + "'");
                }
                String string3 = ConfigEnvironment.getErrorMessage("MQJMS3032");
                throw new IllegalStateException(string3);
            }
            this.clientID = string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setClientID");
            }
        }
    }

    public synchronized void start() throws JMSException {
        block14: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "start");
                }
                if (this.state == 2) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                if (this.state == 1) {
                    break block14;
                }
                if (this.state == 0) {
                    this.state = 1;
                    this.notifyBrowsers();
                    this.notifySessions();
                    this.setClientIDFixed();
                    break block14;
                }
                try {
                    Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_STARTED"));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STARTED");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "start throwing" + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "start");
                }
            }
        }
    }

    public synchronized void stop() throws JMSException {
        block14: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "stop");
                }
                if (this.state == 2) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                if (this.state == 1) {
                    this.state = 0;
                    this.notifyBrowsers();
                    this.notifySessions();
                    this.setClientIDFixed();
                    break block14;
                }
                if (this.state == 0) {
                    break block14;
                }
                try {
                    Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_STOPPED"));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STOPPED");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "stop throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "stop");
                }
            }
        }
    }

    public synchronized void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            if (this.qServices != null && this.tempQqm != null) {
                try {
                    this.tempQqm.disconnect();
                    this.tempQqm = null;
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2003");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            }
            if (this.state == 1 || this.state == 0) {
                this.state = 2;
                if (this.poolToken != null) {
                    MQEnvironment.removeConnectionPoolToken(this.poolToken);
                }
                this.notifyBrowsers();
                this.notifySessions();
                this.setClientIDFixed();
            } else if (this.state != 2) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_CLOSED"));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_CLOSED");
                throw jMSException;
            }
            if (this.initialQm != null) {
                try {
                    this.initialQm.disconnect();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
                this.initialQm = null;
            }
            if (this.qServices != null) {
                this.qServices = null;
            }
            if (this.psServices != null) {
                this.subscriptionEngine.close();
                this.psServices = null;
            }
            if (this.exceptionDelivery != null) {
                this.exceptionDelivery.requestShutdown();
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setExceptionListener");
        }
        this.checkConnectionOpen();
        if (this.exceptionDelivery != null) {
            if (exceptionListener == null) {
                this.exceptionDelivery.setExceptionListener(null);
                this.exceptionDelivery.requestShutdown();
            } else {
                this.exceptionDelivery.setExceptionListener(exceptionListener);
            }
        } else if (exceptionListener != null) {
            this.exceptionDelivery = new ExceptionDeliveryThread(this, exceptionListener);
        }
        this.setClientIDFixed();
        if (Trace.isOn) {
            Trace.exit(this, "setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getExceptionListener");
            Trace.exit(this, "getExceptionListener");
        }
        this.checkConnectionOpen();
        if (this.exceptionDelivery == null) {
            return null;
        }
        return this.exceptionDelivery.getExceptionListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionMetaData getMetaData() throws JMSException {
        try {
            MQConnectionMetaData mQConnectionMetaData;
            if (Trace.isOn) {
                Trace.entry(this, "getMetaData");
            }
            this.checkConnectionOpen();
            MQConnectionMetaData mQConnectionMetaData2 = mQConnectionMetaData = new MQConnectionMetaData(0);
            return mQConnectionMetaData2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMetaData");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStarted() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isStarted");
            }
            boolean bl = this.state == 1;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isStarted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            boolean bl = this.state == 2;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isClosed");
            }
        }
    }

    void addSession(MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "addSession");
        }
        this.sessions.addElement(mQSession);
        if (Trace.isOn) {
            Trace.exit(this, "addSession");
        }
    }

    void removeSession(MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "removeSession");
        }
        boolean bl = this.sessions.removeElement(mQSession);
        if (Trace.isOn) {
            if (bl) {
                Trace.trace(this, "session removed from vector");
            } else {
                Trace.trace(this, "session was not found in vector");
            }
            Trace.exit(this, "removeSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void addBrowser(MQConnectionBrowser mQConnectionBrowser) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addBrowser");
        }
        MQConnection mQConnection = this;
        // MONITORENTER : mQConnection
        try {
            this.browsers.addElement(mQConnectionBrowser);
            switch (this.state) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Connection started. Starting browser.");
                    }
                    mQConnectionBrowser.start();
                    mQConnectionBrowser.activateQueueAgent();
                    return;
                }
                case 0: 
                case 2: {
                    if (!Trace.isOn) return;
                    Trace.trace(this, "Connection not started. Leaving browser unstarted.");
                    return;
                }
            }
            return;
        }
        catch (JMSException jMSException) {
            this.browsers.removeElement(mQConnectionBrowser);
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "ConnectionBrowser start failed");
            Trace.exception(this, "addBrowser", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addBrowser");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowser(MQConnectionBrowser mQConnectionBrowser) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeBrowser");
            }
            boolean bl = this.browsers.removeElement(mQConnectionBrowser);
            if (Trace.isOn) {
                if (bl) {
                    Trace.trace(this, "browser removed from vector");
                } else {
                    Trace.trace(this, "browser was not found in vector");
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeBrowser");
            }
        }
    }

    void deliverException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "deliverException");
        }
        if (this.exceptionDelivery != null) {
            this.exceptionDelivery.deliverException(jMSException);
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientIDFixed() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setClientIDFixed");
            }
            this.clientIDFixed = true;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setClientIDFixed");
            }
        }
    }

    boolean getSyncpointAllGets() {
        return this.syncpointAllGets;
    }

    boolean getPersistenceFromMD() {
        return this.persistenceFromMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQQueueManager createQMXA() throws JMSException {
        try {
            MQQueueManager mQQueueManager;
            if (Trace.isOn) {
                Trace.entry(this, "createQMXA");
            }
            Object object = this.mqProperties;
            synchronized (object) {
                this.mqProperties.put("Group", XAGROUP);
                this.mqProperties.put("XAReq", new Boolean(true));
                this.mqProperties.put("Thread affinity", new Boolean(true));
                this.mqProperties.put("SPI", "SPI_ENABLE");
                this.mqProperties.put("Use QM CCSID", new Boolean(true));
                mQQueueManager = this.createQM();
            }
            object = mQQueueManager;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQMXA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQQueueManager createQMNonXA() throws JMSException {
        try {
            MQQueueManager mQQueueManager;
            if (Trace.isOn) {
                Trace.entry(this, "createQMNonXA");
            }
            Object object = this.mqProperties;
            synchronized (object) {
                this.mqProperties.put("Group", NON_XAGROUP);
                this.mqProperties.put("XAReq", new Boolean(false));
                this.mqProperties.put("Thread affinity", new Boolean(false));
                this.mqProperties.put("SPI", "SPI_ENABLE");
                this.mqProperties.put("Use QM CCSID", new Boolean(true));
                mQQueueManager = this.createQM();
            }
            object = mQQueueManager;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQMNonXA");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQQueueManager createQMNonXAOneThread() throws JMSException {
        try {
            MQQueueManager mQQueueManager;
            if (Trace.isOn) {
                Trace.entry(this, "createQMNonXA");
            }
            Object object = this.mqProperties;
            synchronized (object) {
                this.mqProperties.put("Group", NON_XAGROUP);
                this.mqProperties.put("XAReq", new Boolean(false));
                this.mqProperties.put("SPI", "SPI_ENABLE");
                this.mqProperties.put("Use QM CCSID", new Boolean(true));
                this.mqProperties.put("Thread access", "SINGLE_THREAD");
                mQQueueManager = this.createQM();
                this.mqProperties.remove("Thread access");
            }
            object = mQQueueManager;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQMNonXA");
            }
        }
    }

    int getMsgBatchSize() {
        return this.msgBatchSize;
    }

    int getPollingInterval() {
        return this.pollingInterval;
    }

    int getRescanInterval() {
        return this.rescanInterval;
    }

    int getFailIfQuiesce() {
        return this.failIfQuiesce;
    }

    private Object newExitInstance(String string, String string2) throws JMSException {
        try {
            Object t;
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "newExitInstance");
                object = string2 != null ? string2 : "<null>";
                Trace.trace(this, "classname= " + string + ", initString= " + (String)object);
            }
            object = Class.forName(string);
            Class<?> clazz = Class.forName("java.lang.String");
            Class[] classArray = new Class[]{clazz};
            Constructor constructor = ((Class)object).getConstructor(classArray);
            Object[] objectArray = new Object[]{string2};
            Object t2 = t = constructor.newInstance(objectArray);
            return t2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trace.isOn) {
                Trace.trace(this, "failed to find exit class " + classNotFoundException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
            jMSException.setLinkedException((Exception)classNotFoundException);
            throw jMSException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Trace.isOn) {
                Trace.trace(this, "failed to find string constructor of exit class " + noSuchMethodException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1009");
            jMSException.setLinkedException((Exception)noSuchMethodException);
            throw jMSException;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(this, "failed to setup exit, bad constructor? " + exception);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "newExitInstance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifySessions() throws JMSException, IntErrorException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "notifySessions");
                Trace.trace(this, "notifying " + this.sessions.size() + " sessions for state " + this.state);
            }
            Vector vector = (Vector)this.sessions.clone();
            Enumeration enumeration = vector.elements();
            block15: while (enumeration.hasMoreElements()) {
                MQSession mQSession = (MQSession)enumeration.nextElement();
                try {
                    switch (this.state) {
                        case 0: {
                            mQSession.stop();
                            continue block15;
                        }
                        case 1: {
                            mQSession.start();
                            continue block15;
                        }
                        case 2: {
                            mQSession.close();
                            continue block15;
                        }
                    }
                    String string = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1016", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    String string2 = "MQJMS1016";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    IntErrorException intErrorException = new IntErrorException(string3, string2);
                    throw intErrorException;
                }
                catch (SessionClosedException sessionClosedException) {
                    this.sessions.removeElement(mQSession);
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                    return;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) return;
            Trace.exception(this, "notifySessions", (Throwable)jMSException);
            return;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "notifySessions");
            }
        }
    }

    private void notifyBrowsers() throws IntErrorException, JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "notifyBrowsers");
                Trace.trace(this, "notifying " + this.browsers.size() + " browsers of state " + (this.state == 2 ? "CLOSED" : (this.state == 1 ? "STARTED" : (this.state == 0 ? "STOPPED" : "UNKNOWN (" + this.state + ")"))));
            }
            switch (this.state) {
                case 0: {
                    MQConnectionBrowser mQConnectionBrowser;
                    Enumeration enumeration = this.browsers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.deactivateQueueAgent();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.deactivateQueueAgent:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    enumeration = this.browsers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.stop();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.stop:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    break;
                }
                case 1: {
                    MQConnectionBrowser mQConnectionBrowser;
                    Enumeration enumeration = this.browsers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.start();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.start:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    enumeration = this.browsers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.activateQueueAgent();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.activateQueueAgent:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    break;
                }
                case 2: {
                    MQConnectionBrowser mQConnectionBrowser;
                    Vector vector = (Vector)this.browsers.clone();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.deactivateQueueAgent();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.deactivateQueueAgent:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionBrowser = (MQConnectionBrowser)enumeration.nextElement();
                        try {
                            mQConnectionBrowser.close();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from browser.close:");
                            Trace.exception(this, "notifyBrowsers", (Throwable)jMSException);
                        }
                    }
                    break;
                }
                default: {
                    String string = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1016", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    String string2 = "MQJMS1016";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    IntErrorException intErrorException = new IntErrorException(string3, string2);
                    throw intErrorException;
                }
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "notifyBrowsers");
            }
        }
    }

    private MQQueueManager createQM() throws JMSException {
        try {
            MQSPIQueueManager mQSPIQueueManager;
            Object object;
            String string;
            String string2;
            Enumeration enumeration;
            if (Trace.isOn) {
                Trace.entry(this, "createQM");
                Trace.trace(this, "qmgrName = '" + this.qmgrName + "'");
                if (this.mqProperties != null) {
                    Trace.trace(this, "mqProperties:");
                    enumeration = this.mqProperties.keys();
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (string2 == null) continue;
                        if (string2.equals("password")) {
                            Trace.trace(this, string2 + " = '********'");
                            continue;
                        }
                        string = this.mqProperties.get(string2);
                        object = string.toString();
                        Trace.trace(this, string2 + " = '" + (String)object + "'");
                    }
                } else {
                    Trace.trace(this, "mqProperties = null");
                }
                Trace.trace(this, "forceAllowClient = " + MQEnvironment.forceAllowClientConnection());
                Trace.trace(this, "runningInWS = " + MQEnvironment.runningInWS());
            }
            try {
                enumeration = this.factory.getCCDTURL();
                mQSPIQueueManager = enumeration == null ? new MQSPIQueueManager(this.qmgrName, this.mqProperties) : new MQSPIQueueManager(this.qmgrName, this.mqProperties, (URL)((Object)enumeration));
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "createQM failed because of " + mQException);
                }
                switch (mQException.reasonCode) {
                    case 2035: {
                        string2 = "MQJMS2013";
                        string = ConfigEnvironment.getErrorMessage(string2);
                        object = new JMSSecurityException(string, string2);
                        object.setLinkedException((Exception)mQException);
                        throw object;
                    }
                    case 2063: {
                        String string3 = "MQJMS2013";
                        String string4 = ConfigEnvironment.getErrorMessage(string3);
                        JMSSecurityException jMSSecurityException = new JMSSecurityException(string4, string3);
                        jMSSecurityException.setLinkedException((Exception)mQException);
                        throw jMSSecurityException;
                    }
                    case 2012: {
                        Object v = this.mqProperties.get("XAReq");
                        boolean bl = false;
                        if (v != null && v instanceof Boolean) {
                            bl = (Boolean)v;
                        }
                        if (!bl) break;
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2014");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                String string5 = null;
                String string6 = (String)this.mqProperties.get("transport");
                String string7 = (String)this.mqProperties.get("hostname");
                string5 = string6 != null && string6.equals("MQSeries") ? (string7 != null ? "'" + string7 + ":" + this.qmgrName + "'" : "'<null>:" + this.qmgrName + "'") : "'" + this.qmgrName + "'";
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", string5);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            enumeration = mQSPIQueueManager;
            return enumeration;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQM");
            }
        }
    }

    void checkConnectionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkConnectionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1004";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Connection is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkConnectionOpen");
        }
    }

    String getEntryName(String string) {
        int n;
        int n2;
        String string2 = null;
        String string3 = "getEntryName";
        if (Trace.isOn) {
            Trace.entry(this, string3);
        }
        if ((n2 = string.indexOf(40)) >= 0 && (n = string.indexOf(41, n2)) > n2) {
            string2 = string.substring(n2 + 1, n);
            if ((string2 = string2.trim()).length() == 0) {
                string2 = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, string3);
        }
        return string2;
    }

    String getLibraryName(String string) {
        int n;
        String string2 = null;
        String string3 = "getLibraryName";
        if (Trace.isOn) {
            Trace.entry(this, string3);
        }
        if ((n = string.indexOf(40)) > 0 && n < string.length()) {
            string2 = string.substring(0, n);
            if ((string2 = string2.trim()).length() == 0) {
                string2 = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, string3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void supportThreeExits(MQConnectionFactory mQConnectionFactory) throws JMSException {
        if (Trace.isOn()) {
            Trace.entry(this, "supportThreeExits");
        }
        if (mQConnectionFactory == null) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1093");
            throw jMSException;
        }
        String string = "<unset>";
        Vector<Object> vector = new Vector<Object>();
        try {
            String string2;
            Enumeration enumeration;
            Enumeration enumeration2;
            Object object;
            String string3;
            String string4;
            String string5;
            string = mQConnectionFactory.getSecurityExit();
            if (string != null) {
                Trace.trace(this, "setting up security exits");
                string5 = mQConnectionFactory.getSecurityExitInit();
                string4 = this.getLibraryName(string);
                string3 = this.getEntryName(string);
                if (string4 != null && string3 != null) {
                    object = new MQExternalSecurityExit(string4, string3, string5);
                } else {
                    this.checkExitType(string, "com.ibm.mq.MQSecurityExit");
                    object = this.newExitInstance(string, string5);
                }
                this.mqProperties.put("securityExit", object);
            }
            string = mQConnectionFactory.getReceiveExit();
            object = null;
            if (string != null) {
                Trace.trace(this, "setting up receive exits");
                string5 = mQConnectionFactory.getReceiveExitInit();
                enumeration2 = MQConnection.tokenise(string);
                enumeration = string5 != null ? MQConnection.tokenise(string5) : null;
                while (enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    string4 = this.getLibraryName(string2);
                    Trace.trace(this, "libraryName is " + string4);
                    string3 = this.getEntryName(string2);
                    Trace.trace(this, "entryName is " + string3);
                    string5 = "";
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        string5 = (String)enumeration.nextElement();
                    }
                    Trace.trace(this, "initString is " + string5);
                    if (string4 != null && string3 != null) {
                        object = new MQExternalReceiveExit(string4, string3, string5);
                    } else {
                        this.checkExitType(string2, "com.ibm.mq.MQReceiveExit");
                        object = this.newExitInstance(string2, string5);
                    }
                    vector.add(object);
                }
                if (vector.size() > 1) {
                    object = new MQReceiveExitChain(vector);
                }
                Trace.trace(this, "exitObj is " + object);
                this.mqProperties.put("receiveExit", object);
            }
            string = mQConnectionFactory.getSendExit();
            object = null;
            if (string != null) {
                Trace.trace(this, "setting up send exits");
                string5 = mQConnectionFactory.getSendExitInit();
                enumeration2 = MQConnection.tokenise(string);
                enumeration = string5 != null ? MQConnection.tokenise(string5) : null;
                vector.clear();
                while (enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    string4 = this.getLibraryName(string2);
                    Trace.trace(this, "libraryName is " + string4);
                    string3 = this.getEntryName(string2);
                    Trace.trace(this, "entryName is " + string3);
                    string5 = "";
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        string5 = (String)enumeration.nextElement();
                    }
                    Trace.trace(this, "initString is " + string5);
                    if (string4 != null && string3 != null) {
                        object = new MQExternalSendExit(string4, string3, string5);
                    } else {
                        this.checkExitType(string2, "com.ibm.mq.MQSendExit");
                        object = this.newExitInstance(string2, string5);
                    }
                    vector.add(object);
                }
                if (vector.size() > 1) {
                    object = new MQSendExitChain(vector);
                }
                Trace.trace(this, "exitObj is " + object);
                this.mqProperties.put("sendExit", object);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "supportThreeExits");
            }
        }
    }

    private static Enumeration tokenise(String string) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (bl2) {
                    if (c == '\'') {
                        stringBuffer.append(c);
                    } else if (c == ',') {
                        vector.add(new String(stringBuffer));
                        stringBuffer = new StringBuffer();
                        bl = false;
                    } else {
                        stringBuffer.append(c);
                        bl = false;
                    }
                    bl2 = false;
                    continue;
                }
                if (c == '\'') {
                    bl2 = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == ',') {
                vector.add(new String(stringBuffer));
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '\'') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        vector.add(new String(stringBuffer));
        return vector.elements();
    }

    public long getEoqTimeout() {
        return this.eoqTimeout;
    }

    public void setEoqTimeout(long l) {
        if ((l < -2L || l > 30000L) && Trace.isOn) {
            Trace.trace(this, "timeout being set to possible invalid value: " + l);
        }
        this.eoqTimeout = l;
    }

    MQTemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            MQQueue mQQueue;
            MQTemporaryQueue mQTemporaryQueue = null;
            if (Trace.isOn) {
                Trace.entry(this, "createTemporaryQueue");
            }
            if (this.tempQqm == null) {
                this.tempQqm = this.createQMNonXA();
                try {
                    int n = 2015;
                    this.qmName = this.tempQqm.getAttributeString(n, 48);
                    if (Trace.isOn) {
                        Trace.trace(this, "qmName = " + (null == this.qmName ? "<NULL>" : this.qmName));
                        if (null == this.tempQqm) {
                            Trace.trace(this, "tempQqm == null");
                        } else {
                            Trace.trace(this, "tempQqm.name == " + (null == this.tempQqm.name ? "<NULL>" : this.tempQqm.name));
                        }
                    }
                    this.qmName = null != this.qmName ? this.qmName.trim() : this.tempQqm.name;
                }
                catch (Exception exception) {
                    this.qmName = this.tempQqm.name;
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "tempQPrefix = " + (null == this.tempQPrefix ? "<NULL>" : "'" + this.tempQPrefix + "'"));
                }
                mQQueue = this.tempQPrefix != null && this.tempQPrefix.length() > 0 ? this.tempQqm.accessQueue(this.temporaryModelQ, this.tmpQOpenOptions, this.qmName, this.tempQPrefix, null) : this.tempQqm.accessQueue(this.temporaryModelQ, this.tmpQOpenOptions);
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3000", this.temporaryModelQ);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            MQTemporaryQueue mQTemporaryQueue2 = mQTemporaryQueue = new MQTemporaryQueue(this.qmName, mQQueue, this);
            return mQTemporaryQueue2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTemporaryQueue");
            }
        }
    }

    int getMessageRetention() throws JMSException {
        return this.messageRetention;
    }

    String getTempQPrefix() throws JMSException {
        return this.tempQPrefix;
    }

    protected String getTempModelQueue() {
        try {
            if (!this.factory.getTemporaryModel().equals(this.temporaryModelQ)) {
                this.temporaryModelQ = this.factory.getTemporaryModel();
            }
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("MQJMS1016");
        }
        return this.temporaryModelQ;
    }

    String getBrkControlQueue() throws JMSException {
        return this.brkControlQueue;
    }

    String getBrkQueueManager() throws JMSException {
        return this.brkQueueManager;
    }

    String getBrkPubQueue() throws JMSException {
        return this.brkPubQueue;
    }

    String getBrkSubQueue() throws JMSException {
        return this.brkSubQueue;
    }

    String getBrkCCSubQueue() throws JMSException {
        return this.brkCCSubQueue;
    }

    int getBrkVersion() throws JMSException {
        return this.brkVersion;
    }

    int getMsgSelection() throws JMSException {
        return this.messageSelection;
    }

    int getAndIncrementTempTopicCount() throws JMSException {
        return ++this.tempTopicCount;
    }

    int getPubAckInterval() throws JMSException {
        return this.pubAckInterval;
    }

    int getBrkOptLevel() throws JMSException {
        return this.brkOptLevel;
    }

    void setBrkOptLevel(int n) throws JMSException {
        this.brkOptLevel = n;
    }

    int getStatusRefreshInterval() throws JMSException {
        return this.statusRefreshInterval;
    }

    MQSubscriptionEngine getSubscriptionEngine() throws JMSException {
        return this.subscriptionEngine;
    }

    String getConnectionID() throws JMSException {
        return this.connectionID;
    }

    int getMulticast() throws JMSException {
        return this.multicast;
    }

    public int getReceiveIsolation() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "receiveIsolation = " + this.receiveIsolation);
        }
        return this.receiveIsolation;
    }

    public boolean getOutcomeNotification() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "outcomeNotification = " + this.outcomeNotification);
        }
        return this.outcomeNotification;
    }

    public int getProcessDuration() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "processDuration = " + this.processDuration);
        }
        return this.processDuration;
    }

    public boolean getOptimisticPublication() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "getOptimisticPublication = " + this.optimisticPublication);
        }
        return this.optimisticPublication;
    }

    byte[] getStatusMgrId() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getStatusMgrId");
        }
        try {
            if (this.subscriptionEngine instanceof MQQueueSubscriptionEngine) {
                byte[] byArray = ((MQQueueSubscriptionEngine)this.subscriptionEngine).getStatusMgrId();
                return byArray;
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3048");
            if (Trace.isOn) {
                Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getStatusMgrId");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MQSession getCBBrokerSession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getCBBrokerSession");
        }
        if (this.cbBrokerSession == null) {
            Object object = this.cbBrokerSessionLock;
            synchronized (object) {
                if (this.cbBrokerSession == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating cbBrokerSession");
                    }
                    this.cbBrokerSession = (MQSession)this.createSession(false, 1);
                    this.cbBrokerSession.addPubSubServices();
                }
            }
        }
        return this.cbBrokerSession;
    }

    boolean getSparseSubscriptions() {
        return this.sparseSubscriptions;
    }

    protected String createUniqueID(MQQueueManager mQQueueManager) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createUniqueID");
        }
        String string = null;
        try {
            MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 18);
            MQMessage mQMessage = new MQMessage();
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options |= 2;
            mQPutMessageOptions.options &= 0xFFFFFFFB;
            mQQueue.put(mQMessage, mQPutMessageOptions);
            try {
                mQQueueManager.backout();
            }
            catch (MQException mQException) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS1016", "failed to backout conID message from queue: " + mQException));
                }
                catch (LogException logException) {
                    System.err.println(ConfigEnvironment.getMessage("MQJMS1038") + logException);
                }
            }
            mQQueue.close();
            string = Utils.bytesToHex(mQMessage.messageId);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS5087", "SYSTEM.JMS.REPORT.QUEUE", String.valueOf(mQException.reasonCode));
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + mQException);
                Trace.exit(this, "createUniqueID");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "createUniqueID");
        }
        return string;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return this.createSession(bl, n, 0);
    }

    protected Session createSession(boolean bl, int n, int n2) throws JMSException {
        try {
            Object object;
            MQQueueManager mQQueueManager = null;
            if (Trace.isOn) {
                Trace.entry(this, "createQueueSession");
            }
            if (!bl) {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "acknowledge mode" + n);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "invalid acknowledge mode" + n);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "acknowledge mode", String.valueOf(n));
                        throw jMSException;
                    }
                }
            }
            switch (n2) {
                case 0: 
                case 1: 
                case 2: {
                    if (!Trace.isOn) break;
                    Trace.trace(this, "distributed transactional mode " + n2);
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Bad distributed transactional mode " + n2);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    throw jMSException;
                }
            }
            if (this.isClosed()) {
                String string = "MQJMS1004";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                throw new IllegalStateException(string2, string);
            }
            this.setClientIDFixed();
            if (this.initialQm != null) {
                mQQueueManager = this.initialQm;
                this.initialQm = null;
            } else {
                if (this.factory.getCCDTURL() != null) {
                    this.mqProperties.put("channel", "");
                }
                switch (n2) {
                    case 0: {
                        mQQueueManager = this.createQMNonXA();
                        break;
                    }
                    case 1: {
                        mQQueueManager = this.createQMXA();
                        break;
                    }
                    case 2: {
                        mQQueueManager = this.createQMNonXA();
                        object = new MQRRSQueueManager(mQQueueManager);
                        try {
                            ((MQRRSQueueManager)object).honourRRS();
                            break;
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                            jMSException.setLinkedException((Exception)mQException);
                            try {
                                mQQueueManager.disconnect();
                            }
                            catch (MQException mQException2) {
                                // empty catch block
                            }
                            mQQueueManager = null;
                            throw jMSException;
                        }
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Distibuted transactional mode unexpectedly changed! Now " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
            }
            if (mQQueueManager != null) {
                this.setSupportsQAT2(mQQueueManager.getSupportsQAT2());
            }
            object = new MQSession(this, mQQueueManager, bl, n);
            ((MQSession)object).setDistTransactionMode(n2);
            this.addSession((MQSession)object);
            if (this.isStarted()) {
                try {
                    ((MQSession)object).start();
                }
                catch (JMSException jMSException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1033", jMSException.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linkedException " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueSession");
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "createConnectionConsumer(destination, msgSelector, sesionPool, maxMsgs)");
            }
            if (destination == null) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (destination instanceof com.ibm.mq.jms.MQQueue) {
                ConnectionConsumer connectionConsumer = this.createConnectionConsumer((com.ibm.mq.jms.MQQueue)destination, string, serverSessionPool, n);
                return connectionConsumer;
            }
            if (destination instanceof MQTopic) {
                ConnectionConsumer connectionConsumer = this.createConnectionConsumer((MQTopic)destination, string, serverSessionPool, n);
                return connectionConsumer;
            }
            String string4 = "MQJMS0003";
            String string5 = ConfigEnvironment.getErrorMessage(string4);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
            throw invalidDestinationException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.entry(this, "createConnectionConsumer(destination, msgSelector, sesionPool, maxMsgs)");
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "createConnectionConsumer", "', topic = " + (null == topic ? "null" : topic.getTopicName()) + ", selector = ' " + (string == null ? "null" : string) + "', maxMessages = " + n);
            }
            if (topic == null) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (this.servicesMgr == null) {
                if (this.sessions != null && this.sessions.size() > 0) {
                    ((MQSession)this.sessions.elementAt(0)).addPubSubServices();
                } else {
                    object = this.createSession(false, 1);
                    ((MQSession)object).addPubSubServices();
                    object.close();
                }
            }
            Object object2 = object = new MQConnectionConsumer(this, (MQTopic)topic, string, serverSessionPool, n);
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnectionConsumer");
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        try {
            Object object;
            block15: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "createConnectionConsumer", "queue = " + (null == queue ? "null" : queue.getQueueName()) + ", selector = ' " + (null == string ? "null" : string) + "', maxMessages = " + n);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (!Trace.isOn) break block15;
                    Trace.entry(this, "createConnectionConsumer");
                }
            }
            if (queue == null) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (this.servicesMgr == null) {
                if (this.sessions != null && this.sessions.size() > 0) {
                    ((MQSession)this.sessions.elementAt(0)).addQueueServices();
                } else {
                    object = this.createSession(false, 1);
                    ((MQSession)object).addQueueServices();
                    object.close();
                }
            }
            if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                object = "MQJMS0003";
                String string4 = ConfigEnvironment.getErrorMessage((String)object);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, (String)object);
                throw invalidDestinationException;
            }
            ((com.ibm.mq.jms.MQQueue)queue).checkAccess(this);
            Object object2 = object = new MQConnectionConsumer(this, (com.ibm.mq.jms.MQQueue)queue, string, serverSessionPool, n);
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnectionConsumer");
            }
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "createDurableConnectionConsumer", "name ='" + string + "', topic = " + (null == topic ? "null" : topic.getTopicName()) + ", selector = ' " + (string2 == null ? "null" : string2) + "', maxMessages = " + n);
            }
            if (this.servicesMgr == null) {
                if (this.sessions != null && this.sessions.size() > 0) {
                    ((MQSession)this.sessions.elementAt(0)).addPubSubServices();
                } else {
                    object = this.createSession(false, 1);
                    ((MQSession)object).addPubSubServices();
                    object.close();
                }
            }
            if (topic == null || !(topic instanceof MQTopic)) {
                object = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(object);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, object);
                throw invalidDestinationException;
            }
            if (topic instanceof MQTemporaryTopic) {
                object = ConfigEnvironment.newException("MQJMS0003");
                throw object;
            }
            if (this.getClientID() == null) {
                object = ConfigEnvironment.newException("MQJMS3024");
                throw object;
            }
            if (string == null) {
                object = ConfigEnvironment.newException("MQJMS3039");
                throw object;
            }
            Object object2 = object = new MQConnectionConsumer(this, (MQTopic)topic, string2, serverSessionPool, n, string);
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing: " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createDurableConnectionConsumer");
            }
        }
    }

    public ConnectionBrowser createDurableConnectionBrowser(Topic topic, String string, String string2, MessageReferenceHandler messageReferenceHandler, int n, boolean bl) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createDurableConnectionBrowser", "name = '" + string + "', topic = " + (null == topic ? "null" : topic.getTopicName()) + ", selector = ' " + (string2 == null ? "null" : string2) + "', quantityHint = " + n);
            }
            try {
                Object object;
                if (this.servicesMgr == null) {
                    if (this.sessions != null && this.sessions.size() > 0) {
                        ((MQSession)this.sessions.elementAt(0)).addPubSubServices();
                    } else {
                        object = this.createSession(false, 1);
                        ((MQSession)object).addPubSubServices();
                        object.close();
                    }
                }
                if (topic == null || !(topic instanceof MQTopic)) {
                    object = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(object);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, object);
                    throw invalidDestinationException;
                }
                if (topic instanceof MQTemporaryTopic) {
                    object = ConfigEnvironment.newException("MQJMS0003");
                    throw object;
                }
                if (this.getClientID() == null) {
                    object = ConfigEnvironment.newException("MQJMS3024");
                    throw object;
                }
                if (string == null) {
                    object = ConfigEnvironment.newException("MQJMS3039");
                    throw object;
                }
                object = new MQConnectionBrowser(this, (MQTopic)topic, string2, messageReferenceHandler, n, string);
                this.addBrowser((MQConnectionBrowser)object);
                Object object2 = object;
                return object2;
            }
            catch (JMSException jMSException) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "Exception thrown while trying to create and add ConnectionBrowser");
                        Trace.exception(this, "createDurableConnectionBrowser", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
                catch (JMSException jMSException2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Leaving via exception");
                    }
                    throw jMSException2;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createDurableConnectionBrowser");
            }
        }
    }

    public ConnectionBrowser createConnectionBrowser(Queue queue, String string, MessageReferenceHandler messageReferenceHandler, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConnectionBrowser", "queue = " + queue.getQueueName() + ", selector = '" + string + "', quantityHint = " + n);
            }
            if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Checking queue is valid and could be accessed");
            }
            ((com.ibm.mq.jms.MQQueue)queue).checkAccess(this);
            if (Trace.isOn) {
                Trace.trace(this, "Creating new ConnectionBrowser");
            }
            MQConnectionBrowser mQConnectionBrowser = new MQConnectionBrowser(this, (com.ibm.mq.jms.MQQueue)queue, string, messageReferenceHandler, n);
            if (Trace.isOn) {
                Trace.trace(this, "Adding Browser to connection's list");
            }
            this.addBrowser(mQConnectionBrowser);
            MQConnectionBrowser mQConnectionBrowser2 = mQConnectionBrowser;
            return mQConnectionBrowser2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "createConnectionBrowser", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnectionBrowser");
            }
        }
    }

    public ConnectionBrowser createConnectionBrowser(Topic topic, String string, MessageReferenceHandler messageReferenceHandler, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createConnectionBrowser", "', topic = " + (null == topic ? "null" : topic.getTopicName()) + ", selector = ' " + (string == null ? "null" : string) + "', quantityHint = " + n);
        }
        try {
            if (topic == null || !(topic instanceof MQTopic)) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            MQConnectionBrowser mQConnectionBrowser = new MQConnectionBrowser(this, (MQTopic)topic, string, messageReferenceHandler, n);
            this.addBrowser(mQConnectionBrowser);
            MQConnectionBrowser mQConnectionBrowser2 = mQConnectionBrowser;
            return mQConnectionBrowser2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnectionBrowser");
            }
        }
    }

    protected JMSServicesMgr getMQQueueServices(MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        if (this.servicesMgr == null) {
            this.servicesMgr = new JMSServicesMgr();
        }
        if (this.qServices == null) {
            this.qServices = new MQQueueServices(this, mQQueueManager, bl, n);
        }
        this.servicesMgr.setQueueServices(this.qServices);
        return this.servicesMgr;
    }

    protected JMSServicesMgr getServicesMgr() {
        if (this.servicesMgr == null) {
            this.servicesMgr = new JMSServicesMgr();
        }
        return this.servicesMgr;
    }

    protected JMSServicesMgr getMQPubSubServices(boolean bl, int n, MQSession mQSession) throws JMSException {
        if (this.psServices == null) {
            this.setSubscriptionStores();
            this.psServices = new MQPubSubServices(this, bl, n, mQSession);
        }
        if (this.servicesMgr == null) {
            this.servicesMgr = new JMSServicesMgr();
        }
        this.servicesMgr.setPubSubServices(this.psServices);
        if (!mQSession.pubsubInit) {
            this.servicesMgr.initialisePubSub(mQSession, bl, n);
        }
        return this.servicesMgr;
    }

    private void setSubscriptionStores() throws JMSException {
        Object object;
        MQQueueManager mQQueueManager;
        if (this.qm != null && this.qm.isConnected() && this.qm.isOpen()) {
            mQQueueManager = this.qm;
        } else {
            object = this.factory.getCCDTURL();
            if (object != null && object.toString().length() > 0) {
                this.factory.setCCDTURL(null);
            }
            mQQueueManager = this.createQMNonXA();
            this.factory.setCCDTURL((URL)object);
        }
        try {
            this.connectionID = this.createUniqueID(mQQueueManager);
        }
        catch (JMSException jMSException) {
            Exception exception = jMSException.getLinkedException();
            if (exception != null & this.psServices == null) {
                if (exception instanceof MQException) {
                    MQException mQException = (MQException)jMSException.getLinkedException();
                    if (mQException.reasonCode == 2085) {
                        JMSException jMSException2 = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1111"));
                        jMSException2.setLinkedException((Exception)((Object)jMSException));
                        throw jMSException2;
                    }
                    throw jMSException;
                }
                throw jMSException;
            }
            throw jMSException;
        }
        this.resolvedQMName = mQQueueManager.name == null || mQQueueManager.name.trim().equals("") ? Utils.inquireString(mQQueueManager, 2015) : mQQueueManager.name;
        this.resolvedQMName = this.resolvedQMName == null ? "" : this.resolvedQMName.trim();
        switch (this.factory.getSubscriptionStore()) {
            case 0: {
                if (this.factory.getCloneSupport() == 1) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                    }
                    object = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                    throw object;
                }
                this.subscriptionEngine = new MQQueueSubscriptionEngine(this, mQQueueManager);
                break;
            }
            case 1: {
                this.subscriptionEngine = new MQBrokerSubscriptionEngine(this, this.factory, this.resolvedQMName);
                try {
                    mQQueueManager.disconnect();
                }
                catch (MQException mQException) {}
                break;
            }
            case 2: {
                this.subscriptionEngine = new MQMigrateSubscriptionEngine(this, this.factory, mQQueueManager, this.resolvedQMName);
                break;
            }
            default: {
                object = new JMSException(ConfigEnvironment.getMessage("MQJMS1016"));
                throw object;
            }
        }
    }

    protected boolean getMapNameStyle() {
        return this.mapNameStyle;
    }

    protected boolean getSupportsQAT2() {
        return this.supportsQAT2;
    }

    protected void setSupportsQAT2(boolean bl) {
        this.supportsQAT2 = bl;
    }

    private void checkExitType(String string, String string2) throws JMSException {
        try {
            if (!Class.forName(string2).isAssignableFrom(Class.forName(string))) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string + ", does not implement " + string2);
                throw jMSException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
            jMSException.setLinkedException((Exception)classNotFoundException);
            throw jMSException;
        }
    }

    static {
        try {
            Class.forName("com.ibm.mq.jms.services.ConfigEnvironment");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ERROR: couldn't load ConfigEnvironment class");
        }
    }
}

