/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class JMSMapMessage
extends JMSMessage
implements MapMessage {
    static final long serialVersionUID = 3908796707964271920L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSMapMessage.java, jms, j600, j600-101-060328 1.41.1.1 05/05/25 15:13:13";
    private Hashtable mapdata = new Hashtable();
    boolean readOnly = false;
    boolean inExportBody = false;
    public boolean mapNameStyle = true;

    public JMSMapMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (trace != null) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_map";
        this.jmsStrings = jMSStringResources;
        if (trace != null) {
            trace.exit(this, "constructor");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_exportBody");
        }
        this.inExportBody = true;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            Enumeration enumeration = this.getMapNames();
            stringBuffer.append("<map>");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object object = this.getObject(string2);
                this.eltFormatElement(string2, object, stringBuffer);
            }
            stringBuffer.append("</map>");
            this.inExportBody = false;
            byte[] byArray = stringBuffer.toString().getBytes(string);
            Object var10_9 = null;
            if (trace != null) {
                trace.exit(this, "_exportBody");
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                if (trace != null) {
                    trace.exit(this, "_exportBody (via Exception)");
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var10_10 = null;
                    if (trace == null) break block8;
                    trace.exit(this, "_exportBody");
                }
                throw throwable;
            }
        }
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_importBody");
        }
        try {
            try {
                String string2 = new String(byArray, n, byArray.length - n, string);
                Tokenizer tokenizer = new Tokenizer(string2);
                if (!tokenizer.nextToken().equals("map")) {
                    throw this.newMessageFormatException(1009);
                }
                String string3 = tokenizer.nextToken();
                while (!string3.equals("/map")) {
                    String string4;
                    String string5;
                    if (string3.length() > 3 && string3.substring(0, 3).equals("elt")) {
                        string3 = this._handleIllegalCharacters(string3);
                    }
                    int n3 = 0;
                    boolean bl = false;
                    try {
                        n3 = string3.indexOf(" xsi:nil");
                        bl = n3 != -1;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (string3.charAt(string3.length() - 1) == '/') {
                        bl2 = true;
                    }
                    if (bl) {
                        int n4 = 0;
                        n4 = string3.indexOf(" ");
                        string5 = "'string'";
                        string3 = string3.substring(0, n4);
                        if (!bl2) {
                            string4 = tokenizer.nextToken();
                            if (string4.charAt(0) != '/') {
                                string4 = tokenizer.nextToken();
                            }
                            if (string4.charAt(0) != '/') {
                                throw this.newMessageFormatException(1012);
                            }
                        }
                        this.setObject(string3, this.deformatElement(string5, null));
                    } else {
                        int n5 = string3.indexOf(" dt=");
                        if (n5 != -1) {
                            string5 = string3.substring(n5 + 4);
                            string3 = string3.substring(0, n5);
                            if (bl2) {
                                string5 = string5.substring(0, string5.length() - 1);
                            }
                        } else {
                            string5 = "'string'";
                            if (bl2) {
                                string3 = string3.substring(0, string3.length() - 1);
                            }
                        }
                        if (bl2) {
                            this.setObjectProperty(string3, this.deformatElement(string5, ""));
                        } else {
                            String string6 = tokenizer.nextToken();
                            if (string6.charAt(0) == '/' && (string6.equals("/elt") || string3.equals(string6.substring(1, string6.length())))) {
                                this.setObject(string3, this.deformatElement(string5, ""));
                            } else {
                                this.setObject(string3, this.deformatElement(string5, string6));
                                string4 = tokenizer.nextToken();
                                if (string4.charAt(0) != '/') {
                                    throw this.newMessageFormatException(1009);
                                }
                            }
                        }
                    }
                    string3 = tokenizer.nextToken();
                }
                this.propertiesReadOnly = true;
                this.readOnly = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            catch (Exception exception) {
                JMSException jMSException = this.newMessageFormatException(1009);
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            Object var18_22 = null;
            if (trace != null) {
                trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            if (trace != null) {
                trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (trace != null) {
            trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.mapdata.clear();
        if (trace != null) {
            trace.exit(this, "clearBody");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getBoolean");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            boolean bl = this.toBoolean(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getBoolean");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getBoolean");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getByte");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            byte by = this.toByte(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getByte");
            }
            return by;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getByte");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getBytes");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            byte[] byArray = this.toBytes(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getBytes");
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getBytes");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getChar(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getChar");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            char c = this.toChar(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getChar");
            }
            return c;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getChar");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getDouble");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            double d = this.toDouble(this.mapdata.get(string));
            Object var5_3 = null;
            if (trace != null) {
                trace.exit(this, "getDouble");
            }
            return d;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getDouble");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getFloat");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            float f = this.toFloat(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getFloat");
            }
            return f;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getFloat");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getInt");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            int n = this.toInt(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getInt");
            }
            return n;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getInt");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getLong");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            long l = this.toLong(this.mapdata.get(string));
            Object var5_3 = null;
            if (trace != null) {
                trace.exit(this, "getLong");
            }
            return l;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getLong");
            }
            throw throwable;
        }
    }

    public Enumeration getMapNames() throws JMSException {
        if (trace != null) {
            trace.entry(this, "getMapNames");
            trace.exit(this, "getMapNames");
        }
        return this.mapdata.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string) throws JMSException {
        Object v;
        block7: {
            if (trace != null) {
                trace.entry(this, "getObject");
            }
            try {
                if (string == null) {
                    throw this.newJMSException(1002, string);
                }
                v = this.mapdata.get(string);
                if (v != null && v != NULL) break block7;
                Object var3_3 = null;
                Object var5_5 = null;
                if (trace != null) {
                    trace.exit(this, "getObject");
                }
                return var3_3;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_7 = null;
                    if (trace == null) break block8;
                    trace.exit(this, "getObject");
                }
                throw throwable;
            }
        }
        Object v2 = v;
        Object var5_6 = null;
        if (trace != null) {
            trace.exit(this, "getObject");
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "getShort");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1002, string);
            }
            short s = this.toShort(this.mapdata.get(string));
            Object var4_3 = null;
            if (trace != null) {
                trace.exit(this, "getShort");
            }
            return s;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (trace == null) break block5;
                trace.exit(this, "getShort");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string) throws JMSException {
        Object v;
        block8: {
            if (trace != null) {
                trace.entry(this, "getString");
            }
            try {
                if (string == null) {
                    throw this.newJMSException(1002, string);
                }
                v = this.mapdata.get(string);
                if (v != null && v != NULL) break block8;
                String string2 = null;
                Object var5_5 = null;
                if (trace != null) {
                    trace.exit(this, "getString");
                }
                return string2;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var5_7 = null;
                    if (trace == null) break block9;
                    trace.exit(this, "getString");
                }
                throw throwable;
            }
        }
        if (v instanceof byte[]) {
            throw this.newMessageFormatException(1011);
        }
        String string3 = v.toString();
        Object var5_6 = null;
        if (trace != null) {
            trace.exit(this, "getString");
        }
        return string3;
    }

    private boolean isSettableMapName(String string) {
        if (trace != null) {
            trace.trace(this, "Checking element name " + string + "for validity");
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) continue;
                bl = false;
                break;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean itemExists(String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "itemExists");
        }
        if (string == null) {
            if (trace != null) {
                trace.exit(this, "itemExists (via Exception)");
            }
            throw this.newJMSException(1003);
        }
        boolean bl = this.mapdata.containsKey(string);
        if (trace != null) {
            trace.exit(this, "itemExists");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String string, boolean bl) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setBoolean");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Boolean(bl));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setBoolean");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(String string, byte by) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setByte");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Byte(by));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setByte");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setByte");
            }
            throw throwable;
        }
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (byArray == null) {
            this.setObject(string, byArray);
        } else if (byArray.length == 0) {
            this.setObject(string, byArray);
        } else {
            this.setBytes(string, byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setBytes");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (byArray.length == 0) {
                this.mapdata.put(string, new byte[0]);
            } else {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                this.mapdata.put(string, byArray2);
            }
            Object var7_7 = null;
            if (trace != null) {
                trace.exit(this, "setBytes");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (trace != null) {
                trace.exit(this, "setBytes");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChar(String string, char c) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setChar");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Character(c));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setChar");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setChar");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String string, double d) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setDouble");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Double(d));
            Object var6_4 = null;
            if (trace != null) {
                trace.exit(this, "setDouble");
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (trace != null) {
                trace.exit(this, "setDouble");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(String string, float f) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setFloat");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Float(f));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setFloat");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setFloat");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String string, int n) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setInt");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Integer(n));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setInt");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setInt");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String string, long l) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setLong");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Long(l));
            Object var6_4 = null;
            if (trace != null) {
                trace.exit(this, "setLong");
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (trace != null) {
                trace.exit(this, "setLong");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String string, Object object) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setObject");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (object == null) {
                this.mapdata.put(string, NULL);
            } else {
                if (!(object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
                    throw this.newMessageFormatException(1018, object.getClass());
                }
                this.mapdata.put(string, object);
            }
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setObject");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setObject");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(String string, short s) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setShort");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string2 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string2);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            this.mapdata.put(string, new Short(s));
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setShort");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setShort");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String string, String string2) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setString");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (string == null || string.trim().length() == 0) {
                String string3 = this.jmsStrings.getErrorMessage(1020, string);
                throw new IllegalArgumentException(string3);
            }
            if (!this.mapNameStyle && !this.isSettableMapName(string)) {
                throw this.newMessageFormatException(1021, string);
            }
            if (string2 == null) {
                this.mapdata.put(string, NULL);
            } else {
                this.mapdata.put(string, string2);
            }
            Object var5_4 = null;
            if (trace != null) {
                trace.exit(this, "setString");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (trace != null) {
                trace.exit(this, "setString");
            }
            throw throwable;
        }
    }

    public String toString() {
        if (trace != null) {
            trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.mapdata.toString());
        if (trace != null) {
            trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    public String _handleIllegalCharacters(String string) throws JMSException {
        block13: {
            int n;
            int n2;
            if (trace != null) {
                trace.entry(this, "_handleIllegalCharacters");
            }
            if (string.length() <= 3 || !string.substring(0, 3).equals("elt")) break block13;
            String string2 = string;
            String string3 = "";
            String string4 = "";
            boolean bl = false;
            int n3 = 0;
            n3 = string2.indexOf(" xsi:nil");
            bl = n3 != -1;
            String string5 = "";
            if (bl) {
                string5 = string2.substring(n3, n3 + 15);
            }
            if ((n2 = string2.indexOf(" dt=")) != -1) {
                string4 = string2.substring(0, string2.indexOf("name=") + 5);
                n = string4.length() + 1;
                int n4 = string2.indexOf("dt=") - 2;
                string3 = string2.substring(n, n4);
                string3 = string3 + string2.substring(n2, string2.length());
                string2 = string3 + string5;
                if (trace != null) {
                    trace.trace(this, "Trace : Altered Name = " + string2);
                }
            } else {
                string4 = string2.substring(0, string2.indexOf("name=") + 5);
                n = string4.length() + 1;
                string3 = bl ? string2.substring(n, string2.indexOf("xsi:nil") - 2) : string2.substring(n, string2.length() - 1);
                string2 = string3 + string5;
                if (trace != null) {
                    trace.trace(this, "Trace : (String) Altered Name = " + string2);
                }
            }
            String string6 = string2;
            Object var12_15 = null;
            if (trace != null) {
                trace.exit(this, "_handleIllegalCharacters");
            }
            return string6;
        }
        try {
            String string7 = string;
            Object var12_16 = null;
            if (trace != null) {
                trace.exit(this, "_handleIllegalCharacters");
            }
            return string7;
        }
        catch (Exception exception) {
            try {
                JMSException jMSException = this.newMessageFormatException(1012);
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var12_17 = null;
                    if (trace == null) break block14;
                    trace.exit(this, "_handleIllegalCharacters");
                }
                throw throwable;
            }
        }
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    boolean getInExportBody() {
        return this.inExportBody;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.messageClass.equals("jms_map")) {
            this.messageClass = "jms_map";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eltFormatElement(String string, Object object, StringBuffer stringBuffer) throws JMSException {
        if (trace != null) {
            trace.entry(this, "eltFormatElement");
        }
        try {
            boolean bl = false;
            stringBuffer.append("<");
            if (this.mapNameStyle) {
                stringBuffer.append("elt name=\"" + string + "\"");
            } else {
                stringBuffer.append(string);
            }
            if (object instanceof String) {
                stringBuffer.append(">");
                this.backReference(stringBuffer, (String)object);
                bl = true;
            } else if (object instanceof Integer) {
                stringBuffer.append(" dt='i4'>");
            } else if (object instanceof Short) {
                stringBuffer.append(" dt='i2'>");
            } else if (object instanceof Byte) {
                stringBuffer.append(" dt='i1'>");
            } else if (object instanceof Long) {
                stringBuffer.append(" dt='i8'>");
            } else if (object instanceof Float) {
                stringBuffer.append(" dt='r4'>");
            } else if (object instanceof Double) {
                stringBuffer.append(" dt='r8'>");
            } else if (object instanceof byte[]) {
                stringBuffer.append(" dt='bin.hex'>");
                JMSMapMessage.binToHex((byte[])object, 0, ((byte[])object).length, stringBuffer);
                bl = true;
            } else if (object instanceof Boolean) {
                stringBuffer.append(" dt='boolean'>");
                object = ((Boolean)object).booleanValue() ? "1" : "0";
            } else if (object instanceof Character) {
                stringBuffer.append(" dt='char'>");
                this.backReference(stringBuffer, ((Character)object).toString());
                bl = true;
            } else if (object == null || object == NULL) {
                stringBuffer.append(" xsi:nil='true'>");
                stringBuffer.append("</");
                if (this.mapNameStyle) {
                    stringBuffer.append("elt");
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append(">");
                Object var6_5 = null;
                if (trace != null) {
                    trace.exit(this, "eltFormatElement");
                }
                return;
            }
            if (!bl) {
                stringBuffer.append(object.toString());
            }
            stringBuffer.append("</");
            if (this.mapNameStyle) {
                stringBuffer.append("elt");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(">");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (trace != null) {
                trace.exit(this, "eltFormatElement");
            }
            throw throwable;
        }
        Object var6_6 = null;
        if (trace != null) {
            trace.exit(this, "eltFormatElement");
        }
    }

    private class Tokenizer {
        private Vector tokens = new Vector();

        private Tokenizer(String string) {
            String string2;
            int n = string.length();
            boolean bl = false;
            int n2 = 0;
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (bl) continue;
                if (bl2) {
                    if (c != '>') continue;
                    if (i > n2 && (string2 = string.substring(n2 + 1, i)).length() > 0) {
                        this.tokens.add(string2);
                    }
                    bl2 = false;
                    n2 = i;
                    continue;
                }
                if (c != '<') continue;
                if (i > n2 && (string2 = string.substring(n2 + 1, i)).length() > 0) {
                    this.tokens.add(string2);
                }
                bl2 = true;
                n2 = i;
            }
            if (n - n2 > 2) {
                string2 = string.substring(n2 + 1, n - 1);
                this.tokens.add(string2);
            }
        }

        private String nextToken() {
            if (this.tokens.size() <= 0) {
                throw new NoSuchElementException();
            }
            String string = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            return string;
        }

        private String nextElement() {
            if (this.tokens.size() <= 0) {
                throw new NoSuchElementException();
            }
            String string = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            return string;
        }
    }
}

