/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class MQJavaLevel {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQJavaLevel.java, jms, j600, j600-101-060328 1.17.1.3 05/10/19 11:30:24";
    private static final String VERSION_TITLE = "Version:     ";
    private static final String CMVCLEVEL_TITLE = "CMVC Level:  ";
    private static final String BUILDTYPE_TITLE = "Build Type:  ";
    private static final String NAME_TITLE = "Name:        ";
    protected static final String[] TITLES = new String[]{"Name:        ", "Version:     ", "CMVC Level:  ", "Build Type:  "};
    public static final int mqjCMVCLEVEL = 2;
    private static String[] values = new String[TITLES.length];
    private static boolean valuesDefined = false;
    private static final int DEFAULT_FIELDS = 15;
    protected static int fields = 15;
    protected static boolean withTitles = true;

    public static void main(String[] stringArray) {
        MQJavaLevel.parseCommandLine(stringArray);
        MQJavaLevel.printMQVERInfo();
        System.exit(0);
    }

    protected static final void parseCommandLine(String[] stringArray) {
        if (stringArray.length == 0) {
            fields = 15;
        } else {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.startsWith("-")) continue;
                if (string.charAt(1) == 'b') {
                    withTitles = false;
                    continue;
                }
                if (string.charAt(1) != 'f') continue;
                bl = true;
                String string2 = null;
                string2 = string.length() > 2 ? string.substring(2) : stringArray[i + 1];
                try {
                    fields = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    fields = 15;
                }
            }
            if (!bl) {
                fields = 15;
            }
        }
    }

    protected static void printMQVERInfo() {
        int n = 0;
        int n2 = 1;
        while (n < 4) {
            if ((fields & n2) != 0) {
                if (withTitles) {
                    System.out.print(TITLES[n]);
                }
                System.out.println(MQJavaLevel.queryValue(n));
            }
            ++n;
            n2 *= 2;
        }
    }

    public static void traceBuildInfo() {
        if (Trace.isOn) {
            String string = MQJavaLevel.queryValue(0);
            String string2 = MQJavaLevel.queryValue(1);
            String string3 = MQJavaLevel.queryValue(2);
            String string4 = MQJavaLevel.queryValue(3);
            Trace.trace("*** BuildInfo ***", string + " (" + string2 + ")");
            Trace.trace("*** BuildInfo ***", string3 + " (" + string4 + ")");
        }
    }

    protected static String queryValue(int n) {
        Package package_ = Package.getPackage("com.ibm.mq");
        if (package_ != null) {
            return MQJavaLevel.queryValue(n, package_);
        }
        return "package error";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final String queryValue(int n, Package package_) {
        String string = null;
        if (package_ == null) return "missing package data";
        String string2 = package_.getImplementationVersion();
        if (string2 == null) {
            return "Unable to retrieve ImplementationVersion data";
        }
        if (valuesDefined) return values[n];
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
            MQJavaLevel.values[0] = package_.getImplementationTitle();
            MQJavaLevel.values[1] = stringTokenizer.nextToken();
            MQJavaLevel.values[2] = stringTokenizer.nextToken() + "-" + stringTokenizer.nextToken();
            MQJavaLevel.values[3] = "Production";
        }
        catch (NoSuchElementException noSuchElementException) {
            for (int i = 0; i < TITLES.length; ++i) {
                if (values[i] != null) continue;
                MQJavaLevel.values[i] = "UNKNOWN";
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            MQJavaLevel.values[i] = values[i].trim();
        }
        valuesDefined = true;
        return values[n];
    }
}

