/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.DuplicateLeafException;
import com.ibm.mq.QMTreeException;
import com.ibm.mq.TreeElt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class AbstractTree {
    private final Collection leaves = new ArrayList();
    private final Collection nodes = new ArrayList();
    private TreeElt root = null;

    public AbstractTree() {
        this(null);
    }

    public AbstractTree(TreeElt treeElt) {
        if (treeElt == null) {
            treeElt = new TreeElt();
        } else {
            this.root = treeElt;
        }
        this.nodes.add(treeElt);
        this.leaves.add(treeElt);
    }

    public TreeElt root() {
        return this.root;
    }

    public Collection leaves() {
        return this.leaves;
    }

    public TreeElt parent(TreeElt treeElt) {
        return treeElt.getParent();
    }

    public Collection children(TreeElt treeElt) {
        return treeElt.children();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TreeElt treeElt, Object object) throws QMTreeException {
        TreeElt treeElt2 = this.root;
        synchronized (treeElt2) {
            if (this.leafContains(object)) {
                throw new DuplicateLeafException();
            }
            TreeElt treeElt3 = new TreeElt(treeElt, object);
            treeElt.addChild(treeElt3);
            if (treeElt.children().size() == 1) {
                this.leaves.remove(treeElt);
            }
            this.nodes.add(treeElt3);
            this.leaves.add(treeElt3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeElt getChild(TreeElt treeElt, Object object) {
        TreeElt treeElt2 = null;
        TreeElt treeElt3 = this.root;
        synchronized (treeElt3) {
            if (treeElt != null && object != null) {
                Collection collection = treeElt.children();
                Iterator iterator = collection.iterator();
                while (treeElt2 == null && iterator.hasNext()) {
                    TreeElt treeElt4 = (TreeElt)iterator.next();
                    Object object2 = treeElt4.getElement();
                    if (!object.equals(object2)) continue;
                    treeElt2 = treeElt4;
                }
            }
        }
        return treeElt2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(TreeElt treeElt, Object object) throws QMTreeException {
        TreeElt treeElt2 = this.root;
        synchronized (treeElt2) {
            Collection collection = treeElt.children();
            if (object != null && collection.size() != 0) {
                Iterator iterator = collection.iterator();
                TreeElt treeElt3 = null;
                boolean bl = false;
                while (!bl && iterator.hasNext()) {
                    treeElt3 = (TreeElt)iterator.next();
                    bl = object.equals(treeElt3.getElement());
                }
                if (treeElt3 != null) {
                    this.removeDescendants(treeElt3);
                    treeElt.removeChild(treeElt3);
                    this.nodes.remove(treeElt3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leafContains(Object object) {
        boolean bl = false;
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            if (object != null) {
                Iterator iterator = this.leaves.iterator();
                while (!bl && iterator.hasNext()) {
                    TreeElt treeElt2 = (TreeElt)iterator.next();
                    Object object2 = treeElt2.getElement();
                    if (!object.equals(object2)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int size() {
        return this.nodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            stringBuffer.append("Root  : " + this.root + "\n");
            stringBuffer.append("Leaves: " + this.leaves + "\n");
            stringBuffer.append("Nodes : " + this.nodes + "\n\n");
            if (this.root != null) {
                this.printChildren(this.root, stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    private void removeDescendants(TreeElt treeElt) {
        Collection collection = treeElt.children();
        if (collection.size() != 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                TreeElt treeElt2 = (TreeElt)iterator.next();
                this.removeDescendants(treeElt2);
            }
        }
        this.nodes.remove(treeElt);
        if (this.leaves.contains(treeElt)) {
            this.leaves.remove(treeElt);
            if (treeElt.getParent() != null && treeElt.getParent().children().size() == 1) {
                this.leaves.add(treeElt.getParent());
            }
        }
    }

    private void printChildren(TreeElt treeElt, StringBuffer stringBuffer) {
        stringBuffer.append("node '" + treeElt + "', depth " + treeElt.depth() + " ");
        Collection collection = treeElt.children();
        if (collection.size() == 0) {
            stringBuffer.append(", no children\n");
        } else {
            stringBuffer.append(", " + collection.size() + " children " + collection + "\n");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                TreeElt treeElt2 = (TreeElt)iterator.next();
                this.printChildren(treeElt2, stringBuffer);
            }
        }
    }
}

