/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class MQObjectInputStream
extends ObjectInputStream {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQObjectInputStream.java, jms, j600, j600-101-060328 1.7.1.3 05/08/25 15:00:13";
    ClassLoader cl = null;

    protected MQObjectInputStream(ClassLoader classLoader) throws IOException, SecurityException {
        this.cl = classLoader;
    }

    public MQObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.cl = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "resolveClass");
            Trace.trace(this, "v = " + objectStreamClass.toString());
        }
        try {
            if (Trace.isOn) {
                Trace.trace(this, "Attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.cl);
            }
            Class<?> clazz = Class.forName(objectStreamClass.getName(), true, this.cl);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "forName() failed to resolve the class " + objectStreamClass.getName() + " with the classloader " + this.cl);
                    Trace.trace(this, "exception : " + classNotFoundException.toString());
                    Trace.trace(this, "Now attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.getClass().getClassLoader());
                }
                Class<?> clazz = Class.forName(objectStreamClass.getName());
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (Trace.isOn) {
                    Trace.trace(this, "forName() failed to resolve the class " + objectStreamClass.getName() + " with the classloader " + this.getClass().getClassLoader());
                    Trace.trace(this, "exception : " + classNotFoundException2.toString());
                    Trace.trace(this, "Attempting to resolve class " + objectStreamClass.getName() + " using loadClass() with the classloader  " + this.cl);
                }
                Class<?> clazz = this.cl.loadClass(objectStreamClass.getName());
                return clazz;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "resolveClass");
            }
        }
    }
}

