/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APMSEL
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APMSEL.java, jms, j600, j600-101-060328 1.8.1.1 05/05/25 15:52:02";
    private static final String CLASSNAME = "APMSEL";
    public static final String LONGNAME = "MSGSELECTION";
    public static final String SHORTNAME = "MSEL";
    public static final String MSEL_CLIENT = "CLIENT";
    public static final String MSEL_BROKER = "BROKER";

    public static String valToString(int n) throws JMSException {
        String string;
        if (n == 0) {
            string = MSEL_CLIENT;
        } else if (n == 1) {
            string = MSEL_BROKER;
        } else {
            String string2 = "message selection unexpected value " + n;
            String string3 = "MQJMS1016";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
            JMSException jMSException = new JMSException(string4, string3);
            throw jMSException;
        }
        return string;
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(MSEL_CLIENT)) {
            n = 0;
        } else if (string2.equals(MSEL_BROKER)) {
            n = 1;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int objToInt(Object object) throws BAOException, JMSException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "objToInt");
            }
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof String) {
                String string = (String)object;
                n = APMSEL.stringToVal(string);
            } else {
                String string = "value supplied as an unexpected object type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "objToInt");
            }
        }
    }

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block13: {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = APMSEL.getProperty(SHORTNAME, hashtable)) == null) break block13;
                int n = APMSEL.objToInt(object2);
                if (object instanceof MQTopicConnectionFactory || object instanceof MQConnectionFactory) {
                    try {
                        ((MQConnectionFactory)object).setMessageSelection(n);
                        break block13;
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                        throw bAOException;
                    }
                }
                String string = "object supplied as an unexpected type " + object.getClass();
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            catch (BAOException bAOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + bAOException);
                }
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQTopicConnectionFactory) && !(object instanceof MQConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQConnectionFactory)object).getMessageSelection();
            String string = APMSEL.valToString(n);
            hashtable.put(LONGNAME, string);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

