/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: TrackResult.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;



/**
 * Contains the track and the names of all albums where the song is found.
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class TrackResult {
	/**
	 * The name of all albums.
	 */
	private String[] albums = new String[0];
	/**
	 * The track.
	 */
	private Track track;

	/**
	 * Returns all albums.
	 * @return all albums.
	 */
	public String[] getAlbums() {
		return albums;
	}

	/**
	 * Sets the albums.
	 * @param albums The albums.
	 */
	public void setAlbums(String[] albums) {
		this.albums = albums;
	}

	/**
	 * Adds a album.
	 * @param album A album publishing the track.
	 */
	public void addAlbum(String album) {
		String[] newAlbums = new String[albums.length + 1];
		System.arraycopy(albums, 0, newAlbums, 0, albums.length);
		newAlbums[albums.length] = album;
		albums = newAlbums;
	}

	/**
	 * Returns the track.
	 * @return the track.
	 */
	public Track getTrack() {
		return track;
	}

	/**
	 * Sets the track.
	 * @param track The track.
	 */
	public void setTrack(Track track) {
		this.track = track;
	}
}
