/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Order.java,v 1.3 2010/12/20 09:21:20 pmuessig Exp $
 */
package ch.e2e.examples.list;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * With this class you can order a list of Products.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the method:<br>
 * <ul>
 * <code><li><a href="#order(java.util.ArrayList, java.lang.String)">public Bill order(ArrayList productOrders, String customerID)</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public class Order {
	/**
	 * Sends an order to the server and receives the bill for this order.
	 * @param productOrders The list of product id and quantity of the
	 * requested products. All elements in this list must be of
	 * type <code>ch.e2e.examples.list.ProductOrder</code>.
	 * @param customerID The customer id of the purchaser.
	 * @return The bill of this order.
	 */
	public static Bill order(List<ProductOrder> productOrders, String customerID) {
		double total = 0;
		ArrayList<Product> products = new ArrayList<Product>();
        ProductDB productDB = ProductDB.getInstance();
		for (ProductOrder productOrder : productOrders) {
            Product product = productDB.findProduct(productOrder.getProductId());
			total += product.getPrice() * productOrder.getQuantity();
			products.add(product);
		}
		Bill result = new Bill();
		result.setDate(new GregorianCalendar());
		result.setTotal(total);
		result.setProducts(products);
		result.setProductOrders(productOrders);
		Customer customer = CustomerDB.getInstance().findCustomer(customerID);
		result.setCustomer(customer);
		return result;
	}
}
