/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.filesystem.nativefs.impl;

import java.io.File;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFtpFile;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemView
implements FileSystemView {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemView.class);
    private String rootDir;
    private String currDir;
    private User user;
    private boolean caseInsensitive = false;

    protected NativeFileSystemView(User user) throws FtpException {
        this(user, false);
    }

    public NativeFileSystemView(User user, boolean caseInsensitive) throws FtpException {
        if (user == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        if (user.getHomeDirectory() == null) {
            throw new IllegalArgumentException("User home directory can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        String rootDir = user.getHomeDirectory();
        if (!(rootDir = NativeFtpFile.normalizeSeparateChar(rootDir)).endsWith("/")) {
            rootDir = rootDir + '/';
        }
        this.LOG.debug("Native filesystem view created for user \"{}\" with root \"{}\"", (Object)user.getName(), (Object)rootDir);
        this.rootDir = rootDir;
        this.user = user;
        this.currDir = "/";
    }

    public FtpFile getHomeDirectory() {
        return new NativeFtpFile("/", new File(this.rootDir), this.user);
    }

    public FtpFile getWorkingDirectory() {
        NativeFtpFile fileObj = null;
        if (this.currDir.equals("/")) {
            fileObj = new NativeFtpFile("/", new File(this.rootDir), this.user);
        } else {
            File file = new File(this.rootDir, this.currDir.substring(1));
            fileObj = new NativeFtpFile(this.currDir, file, this.user);
        }
        return fileObj;
    }

    public FtpFile getFile(String file) {
        String physicalName = NativeFtpFile.getPhysicalName(this.rootDir, this.currDir, file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring(this.rootDir.length() - 1);
        return new NativeFtpFile(userFileName, fileObj, this.user);
    }

    public boolean changeWorkingDirectory(String dir) {
        File dirObj = new File(dir = NativeFtpFile.getPhysicalName(this.rootDir, this.currDir, dir, this.caseInsensitive));
        if (!dirObj.isDirectory()) {
            return false;
        }
        if ((dir = dir.substring(this.rootDir.length() - 1)).charAt(dir.length() - 1) != '/') {
            dir = dir + '/';
        }
        this.currDir = dir;
        return true;
    }

    public boolean isRandomAccessible() {
        return true;
    }

    public void dispose() {
    }
}

