/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;

public class Cleanup
extends MQConnectionFactory
implements Runnable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/Cleanup.java, jms, j600, j600-101-060328 1.41.1.2 05/06/30 08:40:56";
    private static final String CLSNAME = "Cleanup";
    private static final String reportQueueName = "SYSTEM.JMS.REPORT.QUEUE";
    private static long assumeOld = 60000L;
    private static final int CAT_SUCC_DEREG = 1;
    private static final int CAT_SUCC_STOP = 2;
    private static final int CAT_SUCCESS = 3;
    private static final int CAT_UNSUCCESS = 4;
    private static final int CAT_PCF_RESPONSE = 5;
    private static final int CAT_UNSUCCESS_DEREG = 6;
    private static final int CAT_UNRECOGNISED = 99;
    private static final int RESP_DONE = 0;
    private static final int RESP_TRY_LATER = 1;
    private static final int RESP_FAILED = 2;
    private static final byte[] dummyMessageText = new byte[]{77, 81, 32, 74, 77, 83, 32, 67, 108, 101, 97, 110, 117, 112, 32, 84, 101, 109, 112, 111, 114, 97, 114, 121, 32, 77, 101, 115, 115, 97, 103, 101};
    private static final String[] defaultNDQueues = new String[]{"SYSTEM.JMS.ND.SUBSCRIBER.QUEUE", "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE"};
    private static final byte[] blankMessageId = new byte[24];
    private boolean endCleanup = false;
    private ExceptionListener exceptionListener = null;
    private Object runLock = new Object();
    private boolean isRunning = false;
    private String userID = "";
    private String password = "";
    private long cleanupInterval = 3600000L;
    private int cleanupLevel = 1;

    public Cleanup() {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor)");
        }
        if (Trace.isOn) {
            Trace.exit(this, "Cleanup (constructor)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cleanup(MQConnectionFactory mQConnectionFactory) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor - MQConnectionFactory)");
        }
        try {
            int n;
            block24: {
                block25: {
                    String string;
                    Object object;
                    block23: {
                        if (mQConnectionFactory.getQueueManager() == null || mQConnectionFactory.getQueueManager().trim().equals("")) {
                            MQConnection mQConnection;
                            block22: {
                                mQConnection = null;
                                object = null;
                                try {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Cleanup - QueueManager has null or empty name. Need to resolve it");
                                    }
                                    mQConnection = (MQConnection)mQConnectionFactory.createConnection();
                                    object = new MQQueueManager("", mQConnection.mqProperties);
                                }
                                catch (MQException mQException) {
                                    if (!Trace.isOn) break block22;
                                    Trace.trace(this, "Cleanup - Error creating queue manager\n" + mQException);
                                }
                            }
                            string = Utils.inquireString(object, 2015);
                            if (Trace.isOn) {
                                Trace.trace(this, "Cleanup - Got resolved QueueManager name = '" + string + "'");
                            }
                            if (!(string = string == null ? "" : string.trim()).equals(((MQQueueManager)object).name)) {
                                ((MQQueueManager)object).name = string;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Cleanup - Close the queue manager and connection");
                            }
                            try {
                                ((MQQueueManager)object).disconnect();
                                mQConnection.close();
                            }
                            catch (MQException mQException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Cleanup - Error  closing queue manager\n" + mQException);
                                }
                                break block23;
                            }
                        }
                        string = mQConnectionFactory.getQueueManager();
                    }
                    this.setQueueManager(string);
                    this.setTransportType(mQConnectionFactory.getTransportType());
                    this.setHostName(mQConnectionFactory.getHostName());
                    this.setPort(mQConnectionFactory.getPort());
                    this.setChannel(mQConnectionFactory.getChannel());
                    this.setCCSID(mQConnectionFactory.getCCSID());
                    this.setReceiveExit(mQConnectionFactory.getReceiveExit());
                    this.setReceiveExitInit(mQConnectionFactory.getReceiveExitInit());
                    this.setSecurityExit(mQConnectionFactory.getSecurityExit());
                    this.setSecurityExitInit(mQConnectionFactory.getSecurityExitInit());
                    this.setSendExit(mQConnectionFactory.getSendExit());
                    this.setSendExitInit(mQConnectionFactory.getSendExitInit());
                    this.setCleanupInterval(mQConnectionFactory.getCleanupInterval());
                    n = mQConnectionFactory.getCleanupLevel();
                    if (n != -1) break block24;
                    object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return System.getProperty("com.ibm.mq.jms.cleanup");
                            }
                            catch (AccessControlException accessControlException) {
                                return "";
                            }
                        }
                    });
                    if (object == null) break block25;
                    if (((String)(object = ((String)object).trim().toUpperCase())).equals("NONE")) {
                        n = 0;
                        break block24;
                    } else if (((String)object).equals("SAFE")) {
                        n = 1;
                        break block24;
                    } else {
                        if (!((String)object).equals("STRONG")) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", String.valueOf(n));
                            throw jMSException;
                        }
                        n = 2;
                    }
                    break block24;
                }
                n = 1;
            }
            this.setCleanupLevel(n);
            return;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exception(this, "Cleanup (constructor - MQConnectionFactory)", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Cleanup (constructor - MQConnectionFactory)");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cleanup(MQConnectionFactory mQConnectionFactory, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor - MQConnectionFactory)");
        }
        try {
            int n;
            block14: {
                block15: {
                    String string2 = mQConnectionFactory.getQueueManager();
                    if (null == string2 || string2.equals("")) {
                        this.setQueueManager(string);
                    } else {
                        this.setQueueManager(mQConnectionFactory.getQueueManager());
                    }
                    this.setTransportType(mQConnectionFactory.getTransportType());
                    this.setHostName(mQConnectionFactory.getHostName());
                    this.setPort(mQConnectionFactory.getPort());
                    this.setChannel(mQConnectionFactory.getChannel());
                    this.setCCSID(mQConnectionFactory.getCCSID());
                    this.setReceiveExit(mQConnectionFactory.getReceiveExit());
                    this.setReceiveExitInit(mQConnectionFactory.getReceiveExitInit());
                    this.setSecurityExit(mQConnectionFactory.getSecurityExit());
                    this.setSecurityExitInit(mQConnectionFactory.getSecurityExitInit());
                    this.setSendExit(mQConnectionFactory.getSendExit());
                    this.setSendExitInit(mQConnectionFactory.getSendExitInit());
                    this.setCleanupInterval(mQConnectionFactory.getCleanupInterval());
                    n = mQConnectionFactory.getCleanupLevel();
                    if (n != -1) break block14;
                    String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return System.getProperty("com.ibm.mq.jms.cleanup");
                            }
                            catch (AccessControlException accessControlException) {
                                return "";
                            }
                        }
                    });
                    if (string3 == null) break block15;
                    if ((string3 = string3.trim().toUpperCase()).equals("NONE")) {
                        n = 0;
                        break block14;
                    } else if (string3.equals("SAFE")) {
                        n = 1;
                        break block14;
                    } else {
                        if (!string3.equals("STRONG")) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", String.valueOf(n));
                            throw jMSException;
                        }
                        n = 2;
                    }
                    break block14;
                }
                n = 1;
            }
            this.setCleanupLevel(n);
            return;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exception(this, "Cleanup (constructor - MQConnectionFactory)", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Cleanup (constructor - MQConnectionFactory)");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cleanup(MQConnectionFactory mQConnectionFactory, Hashtable hashtable, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor - MQConnectionFactory)");
        }
        try {
            int n;
            block14: {
                block15: {
                    String string2 = mQConnectionFactory.getQueueManager();
                    if (null == string2 || string2.equals("")) {
                        this.setQueueManager(string);
                    } else {
                        this.setQueueManager(mQConnectionFactory.getQueueManager());
                    }
                    this.setTransportType(mQConnectionFactory.getTransportType());
                    this.setHostName(mQConnectionFactory.getHostName());
                    this.setPort(mQConnectionFactory.getPort());
                    this.setChannel(mQConnectionFactory.getChannel());
                    this.setCCSID(mQConnectionFactory.getCCSID());
                    this.setReceiveExit(mQConnectionFactory.getReceiveExit());
                    this.setReceiveExitInit(mQConnectionFactory.getReceiveExitInit());
                    this.setSecurityExit(mQConnectionFactory.getSecurityExit());
                    this.setSecurityExitInit(mQConnectionFactory.getSecurityExitInit());
                    this.setSendExit(mQConnectionFactory.getSendExit());
                    this.setSendExitInit(mQConnectionFactory.getSendExitInit());
                    this.setCleanupInterval(mQConnectionFactory.getCleanupInterval());
                    this.setUserID((String)hashtable.get("userID"));
                    this.setPassword((String)hashtable.get("password"));
                    n = mQConnectionFactory.getCleanupLevel();
                    if (n != -1) break block14;
                    String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return System.getProperty("com.ibm.mq.jms.cleanup");
                            }
                            catch (AccessControlException accessControlException) {
                                return "";
                            }
                        }
                    });
                    if (string3 == null) break block15;
                    if ((string3 = string3.trim().toUpperCase()).equals("NONE")) {
                        n = 0;
                        break block14;
                    } else if (string3.equals("SAFE")) {
                        n = 1;
                        break block14;
                    } else {
                        if (!string3.equals("STRONG")) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", String.valueOf(n));
                            throw jMSException;
                        }
                        n = 2;
                    }
                    break block14;
                }
                n = 1;
            }
            this.setCleanupLevel(n);
            return;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exception(this, "Cleanup (constructor - MQConnectionFactory)", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Cleanup (constructor - MQConnectionFactory)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupInterval(long l) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setCleanupInterval");
        }
        try {
            if (l < 0L) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupInterval", String.valueOf(l));
                throw jMSException;
            }
            Object object = this.runLock;
            synchronized (object) {
                if (this.isRunning && (this.getCleanupLevel() == 3 || this.getCleanupLevel() == 4)) {
                    String string = ConfigEnvironment.getMessage("MQJMS3043");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                this.cleanupInterval = l;
                if (this.isRunning) {
                    this.runLock.notifyAll();
                }
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "setCleanupInterval", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCleanupInterval");
            }
        }
    }

    public long getCleanupInterval() {
        if (Trace.isOn) {
            Trace.entry(this, "getCleanupInterval");
            Trace.exit(this, "getCleanupInterval");
        }
        return this.cleanupInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupLevel(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setCleanupLevel");
        }
        try {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", String.valueOf(n));
                    throw jMSException;
                }
            }
            Object object = this.runLock;
            synchronized (object) {
                if (this.isRunning && (n == 3 || n == 4) && this.getCleanupInterval() > 0L) {
                    String string = ConfigEnvironment.getMessage("MQJMS3043");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                this.cleanupLevel = n;
                if (this.isRunning) {
                    this.runLock.notifyAll();
                }
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "setCleanupLevel", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCleanupLevel");
            }
        }
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.entry(this, "getCleanupLevel");
            Trace.exit(this, "getCleanupLevel");
        }
        return this.cleanupLevel;
    }

    public void setPassword(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setPassword");
        }
        this.password = string;
        if (Trace.isOn) {
            Trace.exit(this, "setPassword");
        }
    }

    private String getPassword() {
        if (Trace.isOn) {
            Trace.entry(this, "getPassword");
            Trace.exit(this, "getPassword");
        }
        return this.password;
    }

    public void setUserID(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setUserID");
        }
        this.userID = string;
        if (Trace.isOn) {
            Trace.exit(this, "setUserID");
        }
    }

    private String getUserID() {
        if (Trace.isOn) {
            Trace.entry(this, "getUserID");
            Trace.exit(this, "getUserID");
        }
        return this.userID;
    }

    public static void main(String[] stringArray) throws UnsupportedEncodingException {
        Object object;
        boolean bl = false;
        String string = "";
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        String string2 = null;
        int n3 = 0;
        String string3 = null;
        String string4 = null;
        Locale locale = Locale.getDefault();
        String string5 = locale.getLanguage();
        String string6 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("os.name");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        PrintWriter printWriter = !(!string6.equals("Windows NT") && !string6.equals("OS/2") && !string6.equals("Windows 2000") && !string6.equals("Windows XP") && !string6.equals("WIndows 2003") || !string5.equals("en") && !string5.equals("fr") && !string5.equals("de") && !string5.equals("es") && !string5.equals("it") && !string5.equals("pt")) ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "Cp850")) : new PrintWriter(new OutputStreamWriter(System.out));
        final PrintWriter printWriter2 = printWriter;
        MQConnectionMetaData mQConnectionMetaData = new MQConnectionMetaData();
        String string7 = mQConnectionMetaData.getProviderVersion();
        printWriter2.println();
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS1003"));
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS1002") + " " + string7);
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS5079"));
        printWriter2.println();
        printWriter2.flush();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i].toLowerCase();
                string4 = stringArray[i];
                if (((String)object).equals("-client")) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals("safe")) {
                    n2 = 1;
                    continue;
                }
                if (((String)object).equals("strong")) {
                    n2 = 2;
                    continue;
                }
                if (((String)object).equals("force")) {
                    n2 = 3;
                    continue;
                }
                if (((String)object).equals("nondur")) {
                    n2 = 4;
                    continue;
                }
                if (((String)object).equals("-m")) {
                    string = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-r")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (((String)object).equals("-host")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-port")) {
                    n3 = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (((String)object).equals("-channel")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (((String)object).equals("-t")) {
                    bl2 = true;
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string8 = ConfigEnvironment.getMessage("MQJMS5073", string4);
            printWriter2.println(string8);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string9 = ConfigEnvironment.getMessage("MQJMS5074", string4);
            printWriter2.println(string9);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string10 = ConfigEnvironment.getMessage("MQJMS5075", string4);
            printWriter2.println(string10);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (n2 == 0) {
            object = ConfigEnvironment.getMessage("MQJMS5076");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (bl && string2 == null) {
            object = ConfigEnvironment.getMessage("MQJMS5077");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (!(bl || string2 == null && n3 == 0 && string3 == null)) {
            object = ConfigEnvironment.getMessage("MQJMS5078");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (n3 < 0) {
            object = ConfigEnvironment.getMessage("MQJMS1006", "-port", String.valueOf(n3));
            printWriter2.println((String)object);
            printWriter2.println();
            printWriter2.flush();
            return;
        }
        if (n < 0) {
            object = ConfigEnvironment.getMessage("MQJMS1006", "-r", String.valueOf(n));
            printWriter2.println((String)object);
            printWriter2.println();
            printWriter2.flush();
            return;
        }
        if ((n2 == 3 || n2 == 4) && n > 0) {
            object = ConfigEnvironment.getMessage("MQJMS3043");
            printWriter2.println((String)object);
            printWriter2.println();
            printWriter2.flush();
            return;
        }
        if (bl) {
            if (n3 == 0) {
                n3 = 1414;
            }
            if (string3 == null) {
                string3 = "SYSTEM.DEF.SVRCONN";
            }
        }
        MQException.log = null;
        if (bl2) {
            ConfigEnvironment.start();
            Trace.entry(CLSNAME, "main");
            Trace.trace(CLSNAME, "Trace started from main by -t flag");
        }
        object = new Cleanup();
        try {
            ((MQConnectionFactory)object).setQueueManager(string);
            if (bl) {
                ((MQConnectionFactory)object).setTransportType(1);
                ((MQConnectionFactory)object).setHostName(string2);
                ((MQConnectionFactory)object).setChannel(string3);
                ((MQConnectionFactory)object).setPort(n3);
            } else {
                ((MQConnectionFactory)object).setTransportType(0);
            }
            ((Cleanup)object).setCleanupInterval(n * 60000);
            ((Cleanup)object).setCleanupLevel(n2);
        }
        catch (JMSException jMSException) {
            printWriter2.println(jMSException.getMessage());
            Cleanup.displayUsage(printWriter2);
        }
        if (n > 0) {
            ((Cleanup)object).setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jMSException) {
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5085"));
                    printWriter2.println((Object)jMSException);
                    if (jMSException.getLinkedException() != null) {
                        printWriter2.println(ConfigEnvironment.getMessage("MQJMS5086"));
                        printWriter2.println(jMSException.getLinkedException());
                        printWriter2.flush();
                    }
                }
            });
            ((Cleanup)object).run();
        } else {
            block34: {
                try {
                    ((Cleanup)object).cleanup();
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5084"));
                }
                catch (JMSException jMSException) {
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5085"));
                    printWriter2.println((Object)jMSException);
                    if (jMSException.getLinkedException() == null) break block34;
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5086"));
                    printWriter2.println(jMSException.getLinkedException());
                }
            }
            printWriter2.println();
            printWriter2.flush();
        }
    }

    private static void displayUsage(PrintWriter printWriter) {
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5080"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5081"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5082"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5083"));
        printWriter.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        block62: {
            block57: {
                if (Trace.isOn) {
                    Trace.entry(this, "run");
                }
                var1_1 = null;
                MQException.log = null;
                var6_2 = this.runLock;
                synchronized (var6_2) {
                    this.isRunning = true;
                    var2_4 = this.getCleanupLevel();
                    var3_6 = this.getCleanupInterval();
                    if (var2_4 == 0) {
                        var7_8 = ConfigEnvironment.getMessage("MQJMS3044");
                        throw new IllegalStateException(var7_8);
                    }
                    if ((var2_4 == 3 || var2_4 == 4) && var3_6 > 0L) {
                        var7_9 = ConfigEnvironment.getMessage("MQJMS3043");
                        throw new IllegalStateException(var7_9);
                    }
                    this.endCleanup = false;
                    var5_10 = false;
                }
                while (!var5_10) {
                    block56: {
                        var6_3 = System.currentTimeMillis();
                        if (Trace.isOn) {
                            Trace.trace(this, "Cleanup started at " + var6_3);
                        }
                        try {
                            var1_1 = this.connect();
                            this.performCleanup(var1_1, var2_4);
                            var11_17 = null;
                            ** if (var1_1 == null) goto lbl-1000
                        }
                        catch (Throwable var10_16) {
                            var11_17 = null;
                            if (var1_1 != null) {
                                try {
                                    var1_1.disconnect();
                                    var1_1 = null;
                                }
                                catch (MQException var12_18) {
                                    Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                    Trace.exception(this, "run", (Throwable)var12_18);
                                }
                            }
                            throw var10_16;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var1_1.disconnect();
                                var1_1 = null;
                            }
                            catch (MQException var12_18) {
                                Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                Trace.exception(this, "run", (Throwable)var12_18);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block56;
                            catch (JMSException var8_13) {
                                if (Trace.isOn) {
                                    Trace.exception(this, "run - informing ExceptionListener", (Throwable)var8_13);
                                }
                                if ((var9_14 /* !! */  = this.exceptionListener) != null) {
                                    var9_14 /* !! */ .onException(var8_13);
                                }
                                var11_17 = null;
                                if (var1_1 != null) {
                                    try {
                                        var1_1.disconnect();
                                        var1_1 = null;
                                    }
                                    catch (MQException var12_18) {
                                        Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                        Trace.exception(this, "run", (Throwable)var12_18);
                                    }
                                }
                            }
                        }
                    }
                    var8_12 = false;
                    var9_14 /* !! */  = this.runLock;
                    synchronized (var9_14 /* !! */ ) {
                        while (!var8_12) {
                            var3_6 = this.getCleanupInterval();
                            var2_4 = this.getCleanupLevel();
                            if (this.endCleanup || var3_6 == 0L) {
                                var8_12 = true;
                                var5_10 = true;
                                continue;
                            }
                            var10_15 = var6_3 + var3_6 - System.currentTimeMillis();
                            if (var10_15 > 0L) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Sleeping for " + var10_15);
                                }
                                try {
                                    this.runLock.wait(var10_15);
                                }
                                catch (InterruptedException var12_19) {}
                                continue;
                            }
                            var8_12 = true;
                        }
                    }
                }
                var15_21 = null;
                try {
                    if (var1_1 != null) {
                        var1_1.disconnect();
                    }
                    var1_1 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "Disconnected");
                    }
                }
                catch (MQException var16_24) {
                    if (!Trace.isOn) break block57;
                    Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                    Trace.exception(this, "run", (Throwable)var16_24);
                }
            }
            var16_24 = this.runLock;
            synchronized (var16_24) {
                this.isRunning = false;
                this.runLock.notifyAll();
            }
            if (Trace.isOn) {
                Trace.exit(this, "run");
            }
            break block62;
            {
                catch (JMSException var2_5) {
                    block59: {
                        if (Trace.isOn) {
                            Trace.exception(this, "run - informing ExceptionListener", (Throwable)var2_5);
                        }
                        if ((var3_7 = this.exceptionListener) != null) {
                            var3_7.onException(var2_5);
                        }
                        var15_22 = null;
                        try {
                            if (var1_1 != null) {
                                var1_1.disconnect();
                            }
                            var1_1 = null;
                            if (Trace.isOn) {
                                Trace.trace(this, "Disconnected");
                            }
                        }
                        catch (MQException var16_25) {
                            if (!Trace.isOn) break block59;
                            Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                            Trace.exception(this, "run", (Throwable)var16_25);
                        }
                    }
                    var16_25 = this.runLock;
                    synchronized (var16_25) {
                        this.isRunning = false;
                        this.runLock.notifyAll();
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                }
            }
            catch (Throwable var14_30) {
                block61: {
                    var15_23 = null;
                    try {
                        if (var1_1 != null) {
                            var1_1.disconnect();
                        }
                        var1_1 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "Disconnected");
                        }
                    }
                    catch (MQException var16_26) {
                        if (!Trace.isOn) break block61;
                        Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                        Trace.exception(this, "run", (Throwable)var16_26);
                    }
                }
                var16_26 = this.runLock;
                synchronized (var16_26) {
                    this.isRunning = false;
                    this.runLock.notifyAll();
                }
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                throw var14_30;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "stop");
        }
        Object object = this.runLock;
        synchronized (object) {
            if (this.isRunning && !this.endCleanup) {
                this.endCleanup = true;
                this.runLock.notifyAll();
            }
            while (this.isRunning) {
                if (Trace.isOn) {
                    Trace.trace(this, "Cleanup still running: wait");
                }
                try {
                    this.runLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "stop");
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (Trace.isOn) {
            Trace.entry(this, "setExceptionListener");
        }
        this.exceptionListener = exceptionListener;
        if (Trace.isOn) {
            Trace.exit(this, "setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() {
        if (Trace.isOn) {
            Trace.entry(this, "getExceptionListener");
            Trace.exit(this, "getExceptionListener");
        }
        return this.exceptionListener;
    }

    public boolean isRunning() {
        if (Trace.isOn) {
            Trace.entry(this, "isRunning");
            Trace.exit(this, "isRunning");
        }
        return this.isRunning;
    }

    /*
     * Loose catch block
     */
    public void cleanup() throws JMSException {
        block16: {
            MQQueueManager mQQueueManager;
            block14: {
                if (Trace.isOn) {
                    Trace.entry(this, "cleanup");
                }
                MQException.log = null;
                mQQueueManager = null;
                int n = this.getCleanupLevel();
                if (n == 0) {
                    String string = ConfigEnvironment.getMessage("MQJMS3044");
                    throw new IllegalStateException(string);
                }
                mQQueueManager = this.connect();
                this.performCleanup(mQQueueManager, n);
                Object var5_5 = null;
                try {
                    if (mQQueueManager != null) {
                        mQQueueManager.disconnect();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block14;
                    Trace.trace(this, "Ignoring exception from qmgr.disconnect");
                    Trace.exception(this, "cleanup", (Throwable)mQException);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "cleanup");
            }
            break block16;
            {
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block15: {
                    Object var5_6 = null;
                    try {
                        if (mQQueueManager != null) {
                            mQQueueManager.disconnect();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block15;
                        Trace.trace(this, "Ignoring exception from qmgr.disconnect");
                        Trace.exception(this, "cleanup", (Throwable)mQException);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "cleanup");
                }
                throw throwable;
            }
        }
    }

    private MQQueueManager connect() throws JMSException {
        Trace.entry(this, "connect");
        try {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            switch (this.getTransportType()) {
                case 0: {
                    hashtable.put("transport", "MQSeries Bindings");
                    break;
                }
                case 3: {
                    hashtable.put("transport", "MQJD");
                    break;
                }
                case 1: {
                    hashtable.put("transport", "MQSeries");
                    hashtable.put("CCSID", new Integer(this.getCCSID()));
                    hashtable.put("channel", this.getChannel());
                    hashtable.put("hostname", this.getHostName());
                    hashtable.put("port", new Integer(this.getPort()));
                    object = this.getUserID();
                    String string = this.getPassword();
                    if (object != null) {
                        hashtable.put("userID", this.getUserID());
                    }
                    if (string != null) {
                        hashtable.put("password", this.getPassword());
                    }
                    String string2 = "<unset>";
                    try {
                        Object object2;
                        String string3;
                        string2 = this.getReceiveExit();
                        if (string2 != null) {
                            string3 = this.getReceiveExitInit();
                            object2 = (MQReceiveExit)this.newExitInstance(string2, string3);
                            hashtable.put("receiveExit", object2);
                        }
                        if ((string2 = this.getSecurityExit()) != null) {
                            string3 = this.getSecurityExitInit();
                            object2 = (MQSecurityExit)this.newExitInstance(string2, string3);
                            hashtable.put("securityExit", object2);
                        }
                        if ((string2 = this.getSendExit()) == null) break;
                        string3 = this.getSendExitInit();
                        object2 = (MQSendExit)this.newExitInstance(string2, string3);
                        hashtable.put("sendExit", object2);
                        break;
                    }
                    catch (JMSException jMSException) {
                        throw jMSException;
                    }
                    catch (Exception exception) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string2);
                        jMSException.setLinkedException(exception);
                        throw jMSException;
                    }
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(this.getTransportType()));
                    throw jMSException;
                }
            }
            hashtable.put("Group", MQConnection.NON_XAGROUP);
            hashtable.put("SPI", "SPI_ENABLE");
            hashtable.put("Use QM CCSID", new Boolean(true));
            MQQueueManager mQQueueManager = new MQQueueManager(this.getQueueManager(), hashtable);
            object = mQQueueManager;
            return object;
        }
        catch (MQException mQException) {
            Object var3_4 = null;
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.getQueueManager());
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + mQException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "connect");
            }
        }
    }

    private Object newExitInstance(String string, String string2) throws JMSException {
        try {
            Object obj;
            Constructor<?> constructor;
            Object[] objectArray;
            if (Trace.isOn) {
                Trace.entry(this, "newExitInstance");
            }
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName("java.lang.String");
            try {
                objectArray = new Class[]{clazz2};
                constructor = clazz.getConstructor((Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1009");
                jMSException.setLinkedException((Exception)noSuchMethodException);
                throw jMSException;
            }
            objectArray = new Object[]{string2};
            Object obj2 = obj = constructor.newInstance(objectArray);
            return obj2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + exception);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "newExitInstance");
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCleanup(MQQueueManager var1_1, int var2_2) throws JMSException {
        block81: {
            block78: {
                block80: {
                    block76: {
                        if (Trace.isOn) {
                            Trace.entry(this, "performCleanup IY52745");
                        }
                        var3_3 = null;
                        var4_4 = 0L;
                        try {
                            try {
                                if (var2_2 == 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Cleanup level is NONE; skipping cleanup");
                                    }
                                    var24_5 = null;
                                    break block76;
                                }
                                var6_11 = 8216;
                                switch (var2_2) {
                                    case 1: 
                                    case 2: {
                                        var6_11 |= 2;
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        var6_11 |= 4;
                                        break;
                                    }
                                    default: {
                                        var7_13 = ConfigEnvironment.newException("MQJMS1016", "Bad level " + var2_2 + " encountered in Cleanup");
                                        throw var7_13;
                                    }
                                }
                                try {
                                    var3_3 = var1_1.accessQueue("SYSTEM.JMS.REPORT.QUEUE", var6_11);
                                }
                                catch (MQException var7_14) {
                                    if (var7_14.reasonCode != 2042) {
                                        var8_20 = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.REPORT.QUEUE");
                                        var8_20.setLinkedException((Exception)var7_14);
                                        throw var8_20;
                                    }
                                    if ((var6_11 & 2) == 2) {
                                        var8_18 = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                                        var8_18.setLinkedException((Exception)var7_14);
                                        throw var8_18;
                                    }
                                    var8_19 = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                                    var8_19.setLinkedException((Exception)var7_14);
                                    throw var8_19;
                                }
                                try {
                                    var7_15 = new MQMsg2();
                                    var7_15.setMessageData(Cleanup.dummyMessageText);
                                    var7_15.setCharacterSet(1208);
                                    var7_15.setPersistence(0);
                                    var8_21 = new MQPutMessageOptions();
                                    var8_21.options = 8194;
                                    var3_3.putMsg2(var7_15, (MQPutMessageOptions)var8_21);
                                    var4_4 = var7_15.getPutTimeMillis();
                                    var1_1.backout();
                                }
                                catch (MQException var7_16) {
                                    var8_22 = ConfigEnvironment.newException("MQJMS2007");
                                    var8_22.setLinkedException((Exception)var7_16);
                                    throw var8_22;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Current MQ clock is " + var4_4);
                                }
                                var7_17 = false;
                                var8_21 = new MQMsg2();
                                var9_23 = new MQGetMessageOptions();
                                var10_24 = true;
                                while (!var7_17) {
                                    block77: {
                                        var11_25 = false;
                                        var12_26 = 0;
                                        var9_23.options = 8704;
                                        var9_23.options = var10_24 ? (var9_23.options |= 16) : (var9_23.options |= 32);
                                        var9_23.matchOptions = 0;
                                        try {
                                            var3_3.getMsg2((MQMsg2)var8_21, var9_23);
                                            var11_25 = true;
                                        }
                                        catch (MQException var13_27) {
                                            if (var13_27.reasonCode != 2033) {
                                                var14_49 = ConfigEnvironment.newException("MQJMS2002");
                                                var14_49.setLinkedException((Exception)var13_27);
                                                throw var14_49;
                                            }
                                            var7_17 = true;
                                        }
                                        if (var7_17) continue;
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Found message on report queue");
                                        }
                                        var13_28 = 0L;
                                        try {
                                            var13_28 = var4_4 - var8_21.getPutTimeMillis();
                                        }
                                        catch (MQException var15_30) {
                                            var16_32 = "Unexpected error from getPutTimeMillis (" + var15_30 + ")";
                                            var17_38 = ConfigEnvironment.newException("MQJMS1016", var16_32);
                                            var17_38.setLinkedException((Exception)var15_30);
                                            throw var17_38;
                                        }
                                        var15_29 = null;
                                        try {
                                            var15_29 = MQBrokerMessage.fromMessage((MQMsg2)var8_21);
                                        }
                                        catch (JMSException var16_33) {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Message is not a broker message");
                                            }
                                            var12_26 = 99;
                                        }
                                        try {
                                            if (var15_29 == null) break block77;
                                            var16_34 = var15_29.get("MQPSCommand");
                                            var17_39 = var15_29.get("MQPSCompCode");
                                            var18_43 /* !! */  = var15_29.get("MQPSReason");
                                            var19_46 = var15_29.get("MQPSReasonText");
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Message has command '" + var16_34 + "'");
                                                Trace.trace(this, "Message has completion code '" + var17_39 + "'");
                                                Trace.trace(this, "Message has reason code '" + var18_43 /* !! */  + "'");
                                                Trace.trace(this, "Message has reason text '" + var19_46 + "'");
                                            }
                                            if ("DeregSub".equals(var16_34) || var19_46.equals("MQRCCF_NOT_REGISTERED")) {
                                                if (var17_39 != null && var17_39.equals("0")) {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "Message is response to dereg sub w. full data");
                                                    }
                                                    var12_26 = 1;
                                                    break block77;
                                                } else {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "Message is response to unsuccessful dereg sub");
                                                    }
                                                    var12_26 = 6;
                                                }
                                                break block77;
                                            }
                                            if ("RegSub".equals(var16_34)) {
                                                if (var17_39 != null && var17_39.equals("0")) {
                                                    var20_47 = var15_29.isOptionSet("MQPSRegOpts", "PubOnReqOnly");
                                                    if (var20_47) {
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "Message is response to reg sub w. poro");
                                                        }
                                                        var12_26 = 2;
                                                        break block77;
                                                    } else {
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "Message appears to be response to reg sub");
                                                        }
                                                        var12_26 = 99;
                                                    }
                                                    break block77;
                                                }
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message is response to unsuccessful reg sub");
                                                }
                                                var12_26 = 4;
                                                break block77;
                                            }
                                            if (var16_34 == null) {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message has no command field");
                                                }
                                                var12_26 = var17_39 == null ? 99 : (var17_39.equals("0") ? 3 : 4);
                                            } else {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message has unrecognised command field");
                                                }
                                                var12_26 = 99;
                                            }
                                        }
                                        catch (JMSException var16_35) {
                                            var18_44 = "Error dealing with MQBrokerMessage (" + var16_35.toString() + ")";
                                            var17_40 = ConfigEnvironment.newException("MQJMS1016", var18_44);
                                            var17_40.setLinkedException((Exception)var16_35);
                                            throw var17_40;
                                        }
                                    }
                                    try {
                                        if (var12_26 == 99 && var8_21.getFormat().equals("MQADMIN ") && var8_21.getMessageType() == 2) {
                                            var12_26 = 5;
                                        }
                                    }
                                    catch (MQException var16_36) {
                                        var18_43 /* !! */  = "Could not fetch header data from MQMsg2 (" + var16_36 + ")";
                                        var17_41 = ConfigEnvironment.newException("MQJMS1016", var18_43 /* !! */ );
                                        var17_41.setLinkedException((Exception)var16_36);
                                        throw var17_41;
                                    }
                                    v0 = var16_31 = var13_28 >= Cleanup.assumeOld;
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Message is of category " + var12_26);
                                        if (var16_31) {
                                            Trace.trace(this, "Message is sufficiently old");
                                        } else {
                                            Trace.trace(this, "Message is not sufficiently old");
                                        }
                                    }
                                    var17_37 = false;
                                    switch (var2_2) {
                                        case 1: {
                                            if (var16_31 && (var12_26 == 1 || var12_26 == 2 || var12_26 == 3 || var12_26 == 5)) {
                                                var17_37 = true;
                                                break;
                                            }
                                            var17_37 = false;
                                            break;
                                        }
                                        case 2: {
                                            if (var16_31) {
                                                var17_37 = true;
                                                break;
                                            }
                                            var17_37 = false;
                                            break;
                                        }
                                        case 3: 
                                        case 4: {
                                            var17_37 = true;
                                            break;
                                        }
                                        default: {
                                            var18_43 /* !! */  = ConfigEnvironment.newException("MQJMS1016", "Bad level " + var2_2 + " encountered in Cleanup");
                                            throw var18_43 /* !! */ ;
                                        }
                                    }
                                    var18_42 = false;
                                    var19_45 = 1;
                                    if (var17_37) {
                                        var19_45 = this.processMessage(var1_1, (MQMsg2)var8_21, var15_29, var12_26);
                                    }
                                    if (var18_42 = var2_2 == 4 ? true : (var19_45 == 0 ? true : var12_26 == 6)) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Removing message");
                                        }
                                        try {
                                            var9_23.options = 8512;
                                            var3_3.getMsg2((MQMsg2)var8_21, var9_23, 1);
                                        }
                                        catch (MQException var20_48) {
                                            if (var20_48.reasonCode == 2079) ** GOTO lbl203
                                            var22_50 = "Couldn't get locked message from queue (" + var20_48 + ")";
                                            var21_51 = ConfigEnvironment.newException("MQJMS1016");
                                            var21_51.setLinkedException((Exception)var20_48);
                                            throw var21_51;
                                        }
                                    } else if (Trace.isOn) {
                                        Trace.trace(this, "Leaving message on queue");
                                    }
lbl203:
                                    // 5 sources

                                    var10_24 = false;
                                }
                                if (var2_2 == 4) {
                                    this.cleanupNonDur(var1_1, var3_3);
                                }
                                break block78;
                            }
                            catch (JMSException var6_12) {
                                if (Trace.isOn == false) throw var6_12;
                                Trace.trace(this, "Throwing " + (Object)var6_12);
                                throw var6_12;
                            }
                        }
                        catch (Throwable var23_52) {
                            block79: {
                                var24_7 = null;
                                try {
                                    if (var3_3 != null) {
                                        var3_3.close();
                                    }
                                }
                                catch (MQException var25_10) {
                                    if (!Trace.isOn) break block79;
                                    Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var25_10);
                                }
                            }
                            Trace.exit(this, "performCleanup");
                            throw var23_52;
                        }
                    }
                    ** try [egrp 10[TRYBLOCK] [13 : 1613->1624)] { 
lbl227:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    break block80;
lbl230:
                    // 1 sources

                    catch (MQException var25_8) {
                        if (!Trace.isOn) break block80;
                        Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var25_8);
                    }
                }
                Trace.exit(this, "performCleanup");
                return;
            }
            var24_6 = null;
            ** try [egrp 10[TRYBLOCK] [13 : 1613->1624)] { 
lbl239:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block81;
lbl242:
            // 1 sources

            catch (MQException var25_9) {
                if (!Trace.isOn) break block81;
                Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var25_9);
            }
        }
        Trace.exit(this, "performCleanup");
    }

    private int processMessage(MQQueueManager mQQueueManager, MQMsg2 mQMsg2, MQBrokerMessage mQBrokerMessage, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "processMessage");
        }
        int n2 = 2;
        try {
            if (Trace.isOn) {
                Trace.trace(this, "Category " + n + " message");
            }
            switch (n) {
                case 1: 
                case 2: {
                    String string;
                    if (Trace.isOn) {
                        Trace.trace(this, "Cleaning up any orphaned message");
                    }
                    if (mQBrokerMessage.isOptionSet("MQPSRegOpts", "CorrelAsId")) {
                        try {
                            string = mQBrokerMessage.get("MQPSQMgrName");
                            String string2 = mQBrokerMessage.get("MQPSQName");
                            String string3 = mQBrokerMessage.get("MQPSCorrelId");
                            byte[] byArray = Utils.hexToBytes(string3);
                            if (string != null && string.equals(mQQueueManager.name) && string2 != null && string3 != null && byArray != null && byArray.length == 24) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Removing messages with correlId " + string3 + " from " + string2);
                                }
                                Cleanup.removeMessages(mQQueueManager, string2, byArray);
                                n2 = 0;
                                break;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Response message has surprising information - ignoring");
                            }
                            n2 = 2;
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.exception(this, "processMessage", (Throwable)jMSException);
                            }
                            n2 = 2;
                        }
                        break;
                    }
                    try {
                        string = mQBrokerMessage.get("MQPSQMgrName");
                        String string4 = mQBrokerMessage.get("MQPSQName");
                        if (string != null && string.trim().equals(mQQueueManager.name.trim()) && string4 != null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Removing dynamic queue " + string4);
                            }
                            Cleanup.removeDynamicQueue(mQQueueManager, string4);
                            n2 = 0;
                            break;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Reponse message has surprising information - ignoring");
                        }
                        n2 = 2;
                    }
                    catch (TransactionInProgressException transactionInProgressException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "processMessage", (Throwable)transactionInProgressException);
                            Trace.trace(this, "Will retry this cleanup later");
                        }
                        n2 = 1;
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "processMessage", (Throwable)jMSException);
                        }
                        n2 = 2;
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 99: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Nothing to do");
                    }
                    n2 = 0;
                    break;
                }
                default: {
                    String string = "Bad category " + n + " encountered in Cleanup";
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    throw jMSException;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "processMessage returning " + n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "processMessage");
            }
        }
    }

    /*
     * Loose catch block
     */
    static void removeMessages(MQQueueManager mQQueueManager, String string, byte[] byArray) throws JMSException {
        block23: {
            MQQueue mQQueue;
            block21: {
                if (Trace.isOn) {
                    Trace.entry(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                }
                mQQueue = null;
                try {
                    mQQueue = mQQueueManager.accessQueue(string, 8193);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2085) {
                        block20: {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Queue doesn't exist. No messages to remove.");
                            }
                            Object var7_6 = null;
                            try {
                                if (mQQueue != null) {
                                    mQQueue.close();
                                }
                            }
                            catch (MQException mQException2) {
                                if (!Trace.isOn) break block20;
                                Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException2);
                                Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                        }
                        return;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3014", string);
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                }
                Cleanup.removeMessages(mQQueue, byArray);
                Object var7_7 = null;
                try {
                    if (mQQueue != null) {
                        mQQueue.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block21;
                    Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException);
                    Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                }
            }
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
            }
            break block23;
            {
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var7_8 = null;
                    try {
                        if (mQQueue != null) {
                            mQQueue.close();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block22;
                        Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException);
                        Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeMessages(MQQueue mQQueue, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeMessages(MQQueue, byte[])");
        }
        try {
            MQMsg2 mQMsg2 = new MQMsg2();
            mQMsg2.setCorrelationId(byArray);
            MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 8260;
            mQGetMessageOptions.matchOptions = 2;
            int n = 0;
            boolean bl = false;
            while (!bl) {
                try {
                    mQQueue.getMsg2(mQMsg2, mQGetMessageOptions, 1);
                    ++n;
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2079) {
                        ++n;
                        continue;
                    }
                    if (mQException.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Removed " + n + " messages");
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Got 2033 - no more messages");
                        }
                        bl = true;
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Removed " + n + " messages");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                    return;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeMessages(MQQueue, byte[])");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeMessages(MQQueue mQQueue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeMessages(MQQueue)");
        }
        try {
            MQMsg2 mQMsg2 = new MQMsg2();
            MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 8260;
            int n = 0;
            boolean bl = false;
            while (!bl) {
                try {
                    mQMsg2.setMessageId(blankMessageId);
                    mQMsg2.setCorrelationId(blankMessageId);
                    mQQueue.getMsg2(mQMsg2, mQGetMessageOptions, 1);
                    ++n;
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2079) {
                        ++n;
                        continue;
                    }
                    if (mQException.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Removed " + n + " messages");
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Got 2033 - no more messages");
                        }
                        bl = true;
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Removed " + n + " messages");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                    return;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeMessages(MQQueue)");
            }
        }
    }

    /*
     * Exception decompiling
     */
    static void removeDynamicQueue(MQQueueManager var0, String var1_1) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanupNonDur(MQQueueManager mQQueueManager, MQQueue mQQueue) {
        String[] stringArray;
        if (Trace.isOn) {
            Trace.entry(this, "cleanupNonDur");
        }
        if ((stringArray = Utils.listMatchingQueues(mQQueueManager, mQQueue, "SYSTEM.JMS.ND.*")) == null) {
            if (Trace.isOn) {
                Trace.trace(this, "listMatchingQueues failed; only clearing out known SYSTEM.JMS.ND.* queues");
            }
            stringArray = defaultNDQueues;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            MQQueue mQQueue2;
            block27: {
                block26: {
                    String string = stringArray[i];
                    mQQueue2 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "Dealing with queue " + string);
                    }
                    try {
                        mQQueue2 = mQQueueManager.accessQueue(string, 8228);
                        if (Trace.isOn) {
                            Trace.trace(this, "Opened queue for input and inquire");
                        }
                        int n = mQQueue2.getDefinitionType();
                        if (Trace.isOn) {
                            Trace.trace(this, "Definition type is " + n);
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        switch (n) {
                            case 1: 
                            case 3: {
                                bl = false;
                                break;
                            }
                            case 2: {
                                String string2 = string.trim();
                                int n2 = string2.length() - 16;
                                if (n2 < 0) {
                                    bl = false;
                                    break;
                                }
                                String string3 = string2.substring(n2);
                                char[] cArray = string3.toCharArray();
                                bl = true;
                                for (int j = 0; j < 16 && bl; ++j) {
                                    if (cArray[j] >= '0' && cArray[j] <= '9' || cArray[j] >= 'a' && cArray[j] <= 'z' || cArray[j] >= 'A' && cArray[j] <= 'Z') continue;
                                    bl = false;
                                }
                                break;
                            }
                            default: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "WARNING: Unrecognised definition type");
                                }
                                bl2 = true;
                                bl = false;
                            }
                        }
                        if (!bl2 && !bl) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Removing messages from queue");
                            }
                            Cleanup.removeMessages(mQQueue2);
                        } else if (!bl2 && bl) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Setting queue.closeOptions to DELETE_PURGE");
                            }
                            mQQueue2.closeOptions = 2;
                        }
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Ignoring exception while performing NONDUR cleanup:");
                            Trace.exception(this, "cleanupNonDur", (Throwable)mQException);
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block26;
                        Trace.trace(this, "Ignoring exception while performing NONDUR cleanup:");
                        Trace.exception(this, "cleanupNonDur", (Throwable)jMSException);
                    }
                }
                try {
                    if (mQQueue2 != null) {
                        mQQueue2.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block27;
                    Trace.trace(this, "Ignoring exception on queue.close");
                    Trace.exception(this, "cleanupNonDur", (Throwable)mQException);
                }
            }
            mQQueue2 = null;
        }
    }
}

