/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import com.ibm.mq.jms.services.psk.LogServiceProvider;
import com.ibm.mq.jms.services.psk.MessageCatalogue;
import com.ibm.mq.jms.services.psk.PSK;
import com.ibm.mq.jms.services.psk.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

public class Logger {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/Logger.java, jms, j600, j600-101-060328 1.4.1.1 05/05/25 15:12:15";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Hashtable m_serviceProviders;
    private static MessageCatalogue[] m_msgCats;

    public static void addLogCatalogue(MessageCatalogue messageCatalogue) {
        Trace.entry("Logger", "addLogCatalogue");
        int n = 1;
        if (m_msgCats != null) {
            n += m_msgCats.length;
        }
        MessageCatalogue[] messageCatalogueArray = new MessageCatalogue[n];
        if (m_msgCats != null) {
            System.arraycopy(m_msgCats, 0, messageCatalogueArray, 0, m_msgCats.length);
        }
        messageCatalogueArray[messageCatalogueArray.length - 1] = messageCatalogue;
        Logger.setLogCatalogueSearchOrder(messageCatalogueArray);
        Trace.exit("Logger", "addLogCatalogue");
    }

    public static void addLogServiceProvider(LogServiceProvider logServiceProvider) {
        Trace.entry("Logger", "addLogServiceProvider");
        m_serviceProviders.put(logServiceProvider.getServiceName(), logServiceProvider);
        logServiceProvider.setLogCatalogueSearchOrder(m_msgCats);
        Trace.exit("Logger", "addLogServiceProvider");
    }

    public static synchronized void closeLogs() throws LogException {
        Trace.entry("Logger", "closeLogs");
        LogException logException = null;
        Enumeration enumeration = m_serviceProviders.elements();
        while (enumeration.hasMoreElements()) {
            LogServiceProvider logServiceProvider = (LogServiceProvider)enumeration.nextElement();
            try {
                logServiceProvider.closeLog();
            }
            catch (LogException logException2) {
                logException = logException2;
            }
        }
        if (logException != null) {
            throw logException;
        }
        Trace.exit("Logger", "closeLogs");
    }

    public static synchronized void log(LogMessage logMessage) throws LogException {
        LogException logException = null;
        Enumeration enumeration = m_serviceProviders.elements();
        while (enumeration.hasMoreElements()) {
            LogServiceProvider logServiceProvider = (LogServiceProvider)enumeration.nextElement();
            try {
                logServiceProvider.log(logMessage);
            }
            catch (LogException logException2) {
                logException = logException2;
            }
        }
        if (logException != null) {
            throw logException;
        }
    }

    public static boolean removeLogServiceProvider(String string) {
        Trace.entry("Logger", "removeLogServiceProvider");
        boolean bl = false;
        if (m_serviceProviders.containsKey(string)) {
            bl = true;
        }
        m_serviceProviders.remove(string);
        Trace.exit("Logger", "removeLogServiceProvider");
        return bl;
    }

    public static void setLogCatalogueSearchOrder(MessageCatalogue[] messageCatalogueArray) {
        Trace.entry("Logger", "setLogCatalogueSearchOrder");
        m_msgCats = messageCatalogueArray;
        Enumeration enumeration = m_serviceProviders.elements();
        while (enumeration.hasMoreElements()) {
            LogServiceProvider logServiceProvider = (LogServiceProvider)enumeration.nextElement();
            logServiceProvider.setLogCatalogueSearchOrder(messageCatalogueArray);
        }
        Trace.exit("Logger", "setLogCatalogueSearchOrder");
    }

    static {
        m_msgCats = null;
        m_serviceProviders = new Hashtable();
        PSK.validateRunTimeLicence();
    }
}

