/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTH
extends AbstractCommand {
    private static final String SSL_SESSION_FILTER_NAME = "sslSessionFilter";
    private final Logger LOG = LoggerFactory.getLogger(AUTH.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        if (!request.hasArgument()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "AUTH", null));
            return;
        }
        if (session.getListener().getSslConfiguration() == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 431, "AUTH", null));
            return;
        }
        if (session.getFilterChain().contains(SslFilter.class)) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 534, "AUTH", null));
            return;
        }
        String authType = request.getArgument().toUpperCase();
        if (authType.equals("SSL")) {
            try {
                this.secureSession(session, "SSL");
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 234, "AUTH.SSL", null));
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else if (authType.equals("TLS")) {
            try {
                this.secureSession(session, "TLS");
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 234, "AUTH.TLS", null));
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 502, "AUTH", null));
        }
    }

    private void secureSession(FtpIoSession session, String type) throws GeneralSecurityException, FtpException {
        SslFilter sslFilter;
        SslConfiguration ssl = session.getListener().getSslConfiguration();
        if (ssl != null) {
            session.setAttribute(SslFilter.DISABLE_ENCRYPTION_ONCE);
            sslFilter = new SslFilter(ssl.getSSLContext());
            if (ssl.getClientAuth() == ClientAuth.NEED) {
                sslFilter.setNeedClientAuth(true);
            } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                sslFilter.setWantClientAuth(true);
            }
            if (ssl.getEnabledCipherSuites() != null) {
                sslFilter.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
            }
        } else {
            throw new FtpException("Socket factory SSL not configured");
        }
        session.getFilterChain().addFirst(SSL_SESSION_FILTER_NAME, (IoFilter)sslFilter);
    }
}

