/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.UUID;
import org.apache.ftpserver.ftplet.DataConnectionFactory;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Structure;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.impl.FtpIoSession;

public class DefaultFtpSession
implements FtpSession {
    private FtpIoSession ioSession;

    public DefaultFtpSession(FtpIoSession ioSession) {
        this.ioSession = ioSession;
    }

    public boolean isLoggedIn() {
        return this.ioSession.isLoggedIn();
    }

    public DataConnectionFactory getDataConnection() {
        return this.ioSession.getDataConnection();
    }

    public FileSystemView getFileSystemView() {
        return this.ioSession.getFileSystemView();
    }

    public Date getConnectionTime() {
        return new Date(this.ioSession.getCreationTime());
    }

    public Date getLoginTime() {
        return this.ioSession.getLoginTime();
    }

    public Date getLastAccessTime() {
        return this.ioSession.getLastAccessTime();
    }

    public long getFileOffset() {
        return this.ioSession.getFileOffset();
    }

    public FtpFile getRenameFrom() {
        return this.ioSession.getRenameFrom();
    }

    public String getUserArgument() {
        return this.ioSession.getUserArgument();
    }

    public String getLanguage() {
        return this.ioSession.getLanguage();
    }

    public User getUser() {
        return this.ioSession.getUser();
    }

    public InetSocketAddress getClientAddress() {
        if (this.ioSession.getRemoteAddress() instanceof InetSocketAddress) {
            return (InetSocketAddress)this.ioSession.getRemoteAddress();
        }
        return null;
    }

    public Object getAttribute(String name) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal lookup of internal attribute");
        }
        return this.ioSession.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal setting of internal attribute");
        }
        this.ioSession.setAttribute(name, value);
    }

    public int getMaxIdleTime() {
        return this.ioSession.getMaxIdleTime();
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.ioSession.setMaxIdleTime(maxIdleTime);
    }

    public DataType getDataType() {
        return this.ioSession.getDataType();
    }

    public Structure getStructure() {
        return this.ioSession.getStructure();
    }

    public Certificate[] getClientCertificates() {
        return this.ioSession.getClientCertificates();
    }

    public InetSocketAddress getServerAddress() {
        if (this.ioSession.getLocalAddress() instanceof InetSocketAddress) {
            return (InetSocketAddress)this.ioSession.getLocalAddress();
        }
        return null;
    }

    public int getFailedLogins() {
        return this.ioSession.getFailedLogins();
    }

    public void removeAttribute(String name) {
        if (name.startsWith("org.apache.ftpserver.")) {
            throw new IllegalArgumentException("Illegal removal of internal attribute");
        }
        this.ioSession.removeAttribute(name);
    }

    public void write(FtpReply reply) throws FtpException {
        this.ioSession.write(reply);
    }

    public boolean isSecure() {
        return this.ioSession.isSecure();
    }

    public void increaseWrittenDataBytes(int increment) {
        this.ioSession.increaseWrittenDataBytes(increment);
    }

    public void increaseReadDataBytes(int increment) {
        this.ioSession.increaseReadDataBytes(increment);
    }

    public UUID getSessionId() {
        return this.ioSession.getSessionId();
    }
}

