/*
 * E2E technologies Ltd
 * Project:
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * $Id: e2eheader.java,v 1.3 2006/01/18 10:44:45 tzimber Exp $
 */
package ch.e2e.examples.ftpservice;

import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;

import java.util.List;
import java.util.ArrayList;

/**
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 *
 * @author tzimber
 * @version $Revision: 1.3 $
 */
public class BridgeUserManager implements UserManager {
	private FtpServerCallback callback;

	public BridgeUserManager(FtpServerCallback callback) {
		this.callback = callback;
	}

	public User getUserByName(String username) throws FtpException {
		return null;
	}

	public String[] getAllUserNames() throws FtpException {
		return new String[]{};
	}

	public void delete(String username) throws FtpException {
	}

	public void save(User user) throws FtpException {
	}

	public boolean doesExist(String username) throws FtpException {
		return callback.doesExists(username);
	}

	public User authenticate(Authentication authentication) throws AuthenticationFailedException {
		BridgeUser bridgeUser;
		if (authentication instanceof UsernamePasswordAuthentication) {
			UsernamePasswordAuthentication userLogin = (UsernamePasswordAuthentication)authentication;
			bridgeUser = callback.login(userLogin.getUsername(), userLogin.getPassword());
		} else {
			bridgeUser = callback.login("anonymous", "");
		}
		BaseUser user = null;
		if (bridgeUser != null) {
			user = new BaseUser();
			user.setName(bridgeUser.getName());
			user.setPassword(bridgeUser.getPassword());
			user.setHomeDirectory(bridgeUser.getHomeDirectory());
			user.setMaxIdleTime(bridgeUser.getMaxIdleTime());
			user.setEnabled(bridgeUser.isEnabled());
			List<Authority> authorities = new ArrayList<Authority>();
			if (bridgeUser.getWritePermission()) {
				authorities.add(new WritePermission());
			}
			authorities.add(new ConcurrentLoginPermission(bridgeUser.getMaxLogins(), bridgeUser.getMaxLoginsPerIP()));
			authorities.add(new TransferRatePermission(bridgeUser.getMaxDownloadRate(), bridgeUser.getMaxUploadRate()));
			user.setAuthorities(authorities);
		}
		return user;
	}

	public String getAdminName() throws FtpException {
		return null;
	}

	public boolean isAdmin(String username) throws FtpException {
		return false;
	}
}
