/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.AnonymousAuthentication;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.impl.AbstractUserManager;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.apache.ftpserver.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUserManager
extends AbstractUserManager {
    private final Logger LOG = LoggerFactory.getLogger(DbUserManager.class);
    private String insertUserStmt;
    private String updateUserStmt;
    private String deleteUserStmt;
    private String selectUserStmt;
    private String selectAllStmt;
    private String isAdminStmt;
    private String authenticateStmt;
    private DataSource dataSource;

    public DbUserManager(DataSource dataSource, String selectAllStmt, String selectUserStmt, String insertUserStmt, String updateUserStmt, String deleteUserStmt, String authenticateStmt, String isAdminStmt, PasswordEncryptor passwordEncryptor, String adminName) {
        super(adminName, passwordEncryptor);
        this.dataSource = dataSource;
        this.selectAllStmt = selectAllStmt;
        this.selectUserStmt = selectUserStmt;
        this.insertUserStmt = insertUserStmt;
        this.updateUserStmt = updateUserStmt;
        this.deleteUserStmt = deleteUserStmt;
        this.authenticateStmt = authenticateStmt;
        this.isAdminStmt = isAdminStmt;
        try {
            this.createConnection();
            this.LOG.info("Database connection opened.");
        }
        catch (SQLException ex) {
            this.LOG.error("Failed to open connection to user database", (Throwable)ex);
            throw new FtpServerConfigurationException("Failed to open connection to user database", ex);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSqlUserInsert() {
        return this.insertUserStmt;
    }

    public void setSqlUserInsert(String sql) {
        this.insertUserStmt = sql;
    }

    public String getSqlUserDelete() {
        return this.deleteUserStmt;
    }

    public void setSqlUserDelete(String sql) {
        this.deleteUserStmt = sql;
    }

    public String getSqlUserUpdate() {
        return this.updateUserStmt;
    }

    public void setSqlUserUpdate(String sql) {
        this.updateUserStmt = sql;
    }

    public String getSqlUserSelect() {
        return this.selectUserStmt;
    }

    public void setSqlUserSelect(String sql) {
        this.selectUserStmt = sql;
    }

    public String getSqlUserSelectAll() {
        return this.selectAllStmt;
    }

    public void setSqlUserSelectAll(String sql) {
        this.selectAllStmt = sql;
    }

    public String getSqlUserAuthenticate() {
        return this.authenticateStmt;
    }

    public void setSqlUserAuthenticate(String sql) {
        this.authenticateStmt = sql;
    }

    public String getSqlUserAdmin() {
        return this.isAdminStmt;
    }

    public void setSqlUserAdmin(String sql) {
        this.isAdminStmt = sql;
    }

    public boolean isAdmin(String login) throws FtpException {
        if (login == null) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(login));
            String sql = StringUtils.replaceString(this.isAdminStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            boolean bl = rs.next();
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.LOG.error("DbUserManager.isAdmin()", (Throwable)ex);
                throw new FtpException("DbUserManager.isAdmin()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeQuitely(rs);
                this.closeQuitely(stmt);
                throw throwable;
            }
        }
    }

    protected Connection createConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }

    public void delete(String name) throws FtpException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userid", this.escapeString(name));
        String sql = StringUtils.replaceString(this.deleteUserStmt, map);
        this.LOG.info(sql);
        Statement stmt = null;
        try {
            stmt = this.createConnection().createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.delete()", (Throwable)ex);
            throw new FtpException("DbUserManager.delete()", (Throwable)ex);
        }
        finally {
            this.closeQuitely(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(User user) throws FtpException {
        if (user.getName() == null) {
            throw new NullPointerException("User name is null.");
        }
        Statement stmt = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(user.getName()));
            String password = null;
            if (user.getPassword() != null) {
                password = this.getPasswordEncryptor().encrypt(user.getPassword());
            } else {
                ResultSet rs = null;
                try {
                    BaseUser userWithPassword = this.selectUserByName(user.getName());
                    if (userWithPassword != null) {
                        password = userWithPassword.getPassword();
                    }
                }
                finally {
                    this.closeQuitely(rs);
                }
            }
            map.put("userpassword", this.escapeString(password));
            String home = user.getHomeDirectory();
            if (home == null) {
                home = "/";
            }
            map.put("homedirectory", this.escapeString(home));
            map.put("enableflag", String.valueOf(user.getEnabled()));
            map.put("writepermission", String.valueOf(user.authorize((AuthorizationRequest)new WriteRequest()) != null));
            map.put("idletime", user.getMaxIdleTime());
            TransferRateRequest transferRateRequest = new TransferRateRequest();
            transferRateRequest = (TransferRateRequest)user.authorize((AuthorizationRequest)transferRateRequest);
            if (transferRateRequest != null) {
                map.put("uploadrate", transferRateRequest.getMaxUploadRate());
                map.put("downloadrate", transferRateRequest.getMaxDownloadRate());
            } else {
                map.put("uploadrate", 0);
                map.put("downloadrate", 0);
            }
            ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
            concurrentLoginRequest = (ConcurrentLoginRequest)user.authorize((AuthorizationRequest)concurrentLoginRequest);
            if (concurrentLoginRequest != null) {
                map.put("maxloginnumber", concurrentLoginRequest.getMaxConcurrentLogins());
                map.put("maxloginperip", concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
            } else {
                map.put("maxloginnumber", 0);
                map.put("maxloginperip", 0);
            }
            String sql = null;
            sql = !this.doesExist(user.getName()) ? StringUtils.replaceString(this.insertUserStmt, map) : StringUtils.replaceString(this.updateUserStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            stmt.executeUpdate(sql);
            this.closeQuitely(stmt);
        }
        catch (SQLException ex) {
            try {
                this.LOG.error("DbUserManager.save()", (Throwable)ex);
                throw new FtpException("DbUserManager.save()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeQuitely(stmt);
                throw throwable;
            }
        }
    }

    private void closeQuitely(Statement stmt) {
        if (stmt != null) {
            Connection con = null;
            try {
                con = stmt.getConnection();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.closeQuitely(con);
        }
    }

    private void closeQuitely(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void closeQuitely(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseUser selectUserByName(String name) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userid", this.escapeString(name));
        String sql = StringUtils.replaceString(this.selectUserStmt, map);
        this.LOG.info(sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            BaseUser thisUser = null;
            if (rs.next()) {
                thisUser = new BaseUser();
                thisUser.setName(rs.getString("userid"));
                thisUser.setPassword(rs.getString("userpassword"));
                thisUser.setHomeDirectory(rs.getString("homedirectory"));
                thisUser.setEnabled(rs.getBoolean("enableflag"));
                thisUser.setMaxIdleTime(rs.getInt("idletime"));
                ArrayList<Authority> authorities = new ArrayList<Authority>();
                if (rs.getBoolean("writepermission")) {
                    authorities.add(new WritePermission());
                }
                authorities.add(new ConcurrentLoginPermission(rs.getInt("maxloginnumber"), rs.getInt("maxloginperip")));
                authorities.add(new TransferRatePermission(rs.getInt("downloadrate"), rs.getInt("uploadrate")));
                thisUser.setAuthorities(authorities);
            }
            BaseUser baseUser = thisUser;
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
            return baseUser;
        }
        catch (Throwable throwable) {
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
            throw throwable;
        }
    }

    public User getUserByName(String name) throws FtpException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            BaseUser user = this.selectUserByName(name);
            if (user != null) {
                user.setPassword(null);
            }
            BaseUser baseUser = user;
            return baseUser;
        }
        catch (SQLException ex) {
            this.LOG.error("DbUserManager.getUserByName()", (Throwable)ex);
            throw new FtpException("DbUserManager.getUserByName()", (Throwable)ex);
        }
        finally {
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
        }
    }

    public boolean doesExist(String name) throws FtpException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userid", this.escapeString(name));
            String sql = StringUtils.replaceString(this.selectUserStmt, map);
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            boolean bl = rs.next();
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.LOG.error("DbUserManager.doesExist()", (Throwable)ex);
                throw new FtpException("DbUserManager.doesExist()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeQuitely(rs);
                this.closeQuitely(stmt);
                throw throwable;
            }
        }
    }

    public String[] getAllUserNames() throws FtpException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = this.selectAllStmt;
            this.LOG.info(sql);
            stmt = this.createConnection().createStatement();
            rs = stmt.executeQuery(sql);
            ArrayList<String> names = new ArrayList<String>();
            while (rs.next()) {
                names.add(rs.getString("userid"));
            }
            String[] stringArray = names.toArray(new String[0]);
            this.closeQuitely(rs);
            this.closeQuitely(stmt);
            return stringArray;
        }
        catch (SQLException ex) {
            try {
                this.LOG.error("DbUserManager.getAllUserNames()", (Throwable)ex);
                throw new FtpException("DbUserManager.getAllUserNames()", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeQuitely(rs);
                this.closeQuitely(stmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            UsernamePasswordAuthentication upauth = (UsernamePasswordAuthentication)authentication;
            String user = upauth.getUsername();
            String password = upauth.getPassword();
            if (user == null) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            if (password == null) {
                password = "";
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userid", this.escapeString(user));
                String sql = StringUtils.replaceString(this.authenticateStmt, map);
                this.LOG.info(sql);
                stmt = this.createConnection().createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) throw new AuthenticationFailedException("Authentication failed");
                try {
                    String storedPassword = rs.getString("userpassword");
                    if (!this.getPasswordEncryptor().matches(password, storedPassword)) throw new AuthenticationFailedException("Authentication failed");
                    User user2 = this.getUserByName(user);
                    this.closeQuitely(rs);
                    this.closeQuitely(stmt);
                    return user2;
                }
                catch (FtpException e) {
                    throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
                }
            }
            catch (SQLException ex) {
                this.LOG.error("DbUserManager.authenticate()", (Throwable)ex);
                throw new AuthenticationFailedException("Authentication failed", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.closeQuitely(rs);
                this.closeQuitely(stmt);
                throw throwable;
            }
        }
        if (!(authentication instanceof AnonymousAuthentication)) {
            throw new IllegalArgumentException("Authentication not supported by this user manager");
        }
        try {
            if (!this.doesExist("anonymous")) throw new AuthenticationFailedException("Authentication failed");
            return this.getUserByName("anonymous");
        }
        catch (AuthenticationFailedException e) {
            throw e;
        }
        catch (FtpException e) {
            throw new AuthenticationFailedException("Authentication failed", (Throwable)e);
        }
    }

    private String escapeString(String input) {
        if (input == null) {
            return input;
        }
        StringBuffer valBuf = new StringBuffer(input);
        for (int i = 0; i < valBuf.length(); ++i) {
            char ch = valBuf.charAt(i);
            if (ch != '\'' && ch != '\\' && ch != '$' && ch != '^' && ch != '[' && ch != ']' && ch != '{' && ch != '}') continue;
            valBuf.insert(i, '\\');
            ++i;
        }
        return valBuf.toString();
    }
}

