/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class TemporaryTopicImpl
extends MQTopic
implements TemporaryTopic,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/TemporaryTopicImpl.java, disthub, j600, j600-101-060328 1.14.1.1 05/05/25 15:42:55";
    private static final DebugObject debug = new DebugObject("TemporaryTopicImpl");
    private SessionImpl session;
    private int useCount = 0;
    private boolean deleted = false;

    TemporaryTopicImpl(SessionImpl sessionImpl, String string) throws JMSException {
        super(string);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"TemporaryTopicImpl", (Object)sessionImpl, (Object)string);
        }
        this.session = sessionImpl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"TemporaryTopicImpl");
        }
    }

    TemporaryTopicImpl(String string) throws JMSException {
        super(string);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"TemporaryTopicImpl", (Object)string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"TemporaryTopicImpl");
        }
    }

    synchronized void incUse() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"incUse");
        }
        if (this.deleted) {
            if (Trace.isOn) {
                Trace.entry(this, "incUse");
                Trace.trace(this, "JMS Exception - deleted");
                Trace.exit(this, "incUse");
            }
            String string = "MQJMS3019";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        ++this.useCount;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"incUse");
        }
    }

    synchronized void decUse() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"decUse");
        }
        Assert.condition((!this.deleted ? 1 : 0) != 0);
        --this.useCount;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"decUse");
        }
    }

    boolean isCreatedOnThisConnection(SessionImpl sessionImpl) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isCreatedOnThisConnection", (Object)sessionImpl);
        }
        boolean bl2 = bl = this.session != null && (this.session == sessionImpl || this.session.getConnection() == sessionImpl.getConnection());
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isCreatedOnThisConnection", (Object)new Boolean(bl));
        }
        return bl;
    }

    boolean isDeleted() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isDeleted");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isDeleted", (Object)new Boolean(this.deleted));
        }
        return this.deleted;
    }

    public void delete() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"delete");
        }
        if (this.useCount > 0) {
            if (Trace.isOn) {
                Trace.entry(this, "delete");
                Trace.trace(this, "JMS Exception - useCount > 0");
                Trace.exit(this, "delete");
            }
            String string = "MQJMS3025";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        this.session = null;
        this.deleted = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"delete");
        }
    }
}

