/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.ConnectorImpl;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.formats.SchemaRegistry;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.jms.JMSStringResources;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.MQJMSStringResources;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SerialMessage;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
extends com.ibm.disthub2.impl.client.MessageImpl
implements Message,
Serializable,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MessageImpl.java, disthub, j600, j600-101-060328 1.41.1.1 05/05/25 15:42:28";
    private static final DebugObject debug = new DebugObject("MessageImpl");
    private static final long serialVersionUID = -4266952183484564154L;
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    String messageClass = "jms_none";
    private SessionImpl session;
    private MessageConsumerImpl consumer;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    long expiration = 0L;
    boolean redelivered = false;
    Dictionary props;
    String messageId;
    boolean isDisposable = true;
    private int encoding;
    private String charset;
    static final StringBuffer NULL = new StringBuffer("<null>");
    transient JMSStringResources jmsStrings = new MQJMSStringResources();

    public static MessageImpl construct(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"construct", (Object)messageHandle, (Object)connectionImpl);
        }
        MessageImpl messageImpl = null;
        switch (messageHandle.getChoice(157)) {
            case 2: {
                messageImpl = new ObjectMessageImpl(messageHandle, connectionImpl);
                break;
            }
            case 3: {
                messageImpl = new BytesMessageImpl(messageHandle, connectionImpl);
                break;
            }
            case 4: {
                messageImpl = new TextMessageImpl(messageHandle, connectionImpl);
                break;
            }
            case 5: {
                messageImpl = new StreamMessageImpl(messageHandle, connectionImpl);
                break;
            }
            case 6: {
                messageImpl = new MapMessageImpl(messageHandle, connectionImpl);
                break;
            }
            default: {
                messageImpl = new MessageImpl(messageHandle, connectionImpl);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"construct", (Object)messageImpl);
        }
        return messageImpl;
    }

    public static MessageImpl construct(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"construct", (Object)new Integer(n));
        }
        MessageImpl messageImpl = null;
        switch (n) {
            case 2: {
                messageImpl = new ObjectMessageImpl();
                break;
            }
            case 3: {
                messageImpl = new BytesMessageImpl();
                break;
            }
            case 4: {
                messageImpl = new TextMessageImpl();
                break;
            }
            case 5: {
                messageImpl = new StreamMessageImpl();
                break;
            }
            case 6: {
                messageImpl = new MapMessageImpl();
                break;
            }
            default: {
                messageImpl = new MessageImpl();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"construct", (Object)messageImpl);
        }
        return messageImpl;
    }

    MessageImpl duplicate() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"duplicate");
        }
        byte[] byArray = Framing.preFrame((MessageHandle)this.cursor, (int)Framing.overhead((byte)1, null, (boolean)false), null);
        Framing.frameMessage((byte[])byArray, (short)this.cursor.getInterpreterId(), (long)this.cursor.getEncodingSchema().getId(), (int)byArray.length);
        MessageHandle messageHandle = SchemaRegistry.getMessageHandle((byte[])byArray, null);
        MessageImpl messageImpl = MessageImpl.construct(messageHandle, (ConnectionImpl)this.conn);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"duplicate", (Object)messageImpl);
        }
        return messageImpl;
    }

    MessageImpl(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        super(messageHandle, (ConnectorImpl)connectionImpl);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageImpl", (Object)messageHandle);
        }
        this.readOnly = true;
        this.propertiesReadOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageImpl");
        }
    }

    public MessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageImpl");
        }
        this.readOnly = false;
        this.propertiesReadOnly = false;
        this.props = new Hashtable();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageImpl");
        }
    }

    void setSession(SessionImpl sessionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setSession", (Object)sessionImpl);
        }
        this.session = sessionImpl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setSession");
        }
    }

    void setDisposable(boolean bl) {
        this.isDisposable = bl;
    }

    boolean getDisposable() {
        return this.isDisposable;
    }

    void setConsumer(MessageConsumerImpl messageConsumerImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setConsumer", (Object)messageConsumerImpl);
        }
        this.consumer = messageConsumerImpl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setConsumer");
        }
    }

    public void setTopic(MQTopic mQTopic) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setTopic", (Object)mQTopic);
        }
        String string = mQTopic.getBaseTopicName();
        this.setTopicString(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTopic");
        }
    }

    MessageConsumerImpl getConsumer() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getConsumer");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getConsumer", (Object)this.consumer);
        }
        return this.consumer;
    }

    void dispatch() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dispatch");
        }
        this.consumer.dispatch(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dispatch");
        }
    }

    boolean isFor(MessageConsumer messageConsumer) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isFor", (Object)messageConsumer);
        }
        boolean bl2 = bl = this.consumer == messageConsumer;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isFor", (Object)new Boolean(bl));
        }
        return bl;
    }

    static void validateDeliveryMode(int n) throws JMSInvalidParameterException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"validateDeliveryMode", (Object)new Integer(n));
        }
        if (n != 1 && n != 2) {
            String string = "MQJMS1042";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSInvalidParameterException(string2);
        }
        if (n == 2) {
            String string = "MQJMS6401";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"validateDeliveryMode");
        }
    }

    static void validatePriority(int n) throws JMSInvalidParameterException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"validatePriority", (Object)new Integer(n));
        }
        if (n < 0 || n > 9) {
            throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-522107999, (Object[])new Object[]{new Integer(n)}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"validatePriority");
        }
    }

    public String getJMSMessageID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSMessageID");
        }
        String string = null;
        if (this.messageId == null) {
            int n;
            string = Long.toHexString(this.getMessageID());
            for (int i = n = string.length(); i < 48; ++i) {
                string = "0" + string;
            }
            this.messageId = "ID:" + string;
        }
        if (this.messageId.equals("ID:000000000000000000000000000000000000000000000000")) {
            this.messageId = null;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSMessageID", (Object)this.messageId);
        }
        return this.messageId;
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSMessageID", (Object)string);
        }
        this.messageId = string;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSMessageID");
        }
    }

    public long getJMSTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSTimestamp");
        }
        long l = this.getTimestamp();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSTimestamp", (Object)new Long(l));
        }
        return l;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSTimestamp", (Object)new Long(l));
        }
        this.setTimestamp(l);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSTimestamp");
        }
    }

    public void resetJMSTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"resetJMSTimestamp");
        }
        this.setTimestamp(0L);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"resetJMSTimestamp");
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCorrelationIDAsBytes");
        }
        byte[] byArray = null;
        if (this.getJMSCorrelationID() != null) {
            byArray = this.getJMSCorrelationID().getBytes();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCorrelationIDAsBytes");
        }
        return byArray;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCorrelationIDAsBytes", (Object)byArray);
        }
        this.setCorrelationID(new String(byArray));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCorrelationIDAsBytes");
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCorrelationID");
        }
        String string = this.getCorrelationID();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCorrelationID", (Object)string);
        }
        return string;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSReplyTo");
        }
        String string = this.getReplyString();
        MQTopic mQTopic = null;
        if (string != null) {
            mQTopic = new MQTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSReplyTo", (Object)mQTopic);
        }
        return mQTopic;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException, InvalidDestinationException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSReplyTo", (Object)destination);
        }
        if (destination == null) {
            this.setReplyString(null);
        } else if (destination instanceof MQTopic) {
            this.setReplyString(((MQTopic)destination).toString());
        } else {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new InvalidDestinationException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSReplyTo");
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSDestination");
        }
        String string = this.getTopicString();
        MQTopic mQTopic = null;
        if (string != null) {
            mQTopic = new MQTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSDestination", (Object)mQTopic);
        }
        return mQTopic;
    }

    String getJMSDestinationString() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSDestinationString");
        }
        String string = this.getTopicString();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSDestinationString", (Object)string);
        }
        return string;
    }

    public void setJMSDestination(Destination destination) throws InvalidDestinationException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSDestination", (Object)destination);
        }
        if (!(destination instanceof MQTopic)) {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new InvalidDestinationException(string2, string);
        }
        this.setTopicString(((MQTopic)destination).toStringInternal());
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSDestination");
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSDeliveryMode");
        }
        int n = 1;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSDeliveryMode", (Object)new Integer(n));
        }
        return n;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSDeliveryMode", (Object)new Integer(n));
        }
        MessageImpl.validateDeliveryMode(n);
        this.setPersistent(n == 2);
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSRedelivered");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSRedelivered", (Object)new Boolean(this.redelivered));
        }
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSRedelivered", (Object)new Boolean(bl));
        }
        this.redelivered = bl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSRedelivered");
        }
    }

    public long getJMSExpiration() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSExpiration");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSExpiration", (Object)new Long(this.expiration));
        }
        return this.getJMSExpirationField();
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSExpiration", (Object)new Long(l));
        }
        this.expiration = l;
        this.setJMSExpirationField(l);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSExpiration");
        }
    }

    public int getJMSPriority() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSPriority");
        }
        int n = this.getPriority();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSPriority", (Object)new Integer(n));
        }
        return n;
    }

    public void setJMSPriority(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSPriority", (Object)new Integer(n));
        }
        this.setPriority(n);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSPriority");
        }
    }

    public void setJMSType(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSType", (Object)string);
        }
        if (string != null && string.startsWith("mcd://") && this.messageClass != CLASS_TEXT && this.messageClass != CLASS_BYTES) {
            throw new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1006", "JMSType", string));
        }
        this.setJMSTypeField(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSType");
        }
    }

    public String getJMSType() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSType");
        }
        String string = this.getJMSTypeField();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSType");
        }
        return string;
    }

    public void setJMSEncoding(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSEncoding", (Object)new Integer(n));
        }
        this.encoding = n;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSEncoding");
        }
    }

    public int getJMSEncoding() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSEncoding");
        }
        int n = this.encoding;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSEncoding");
        }
        return n;
    }

    public void setJMSCharset(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCharset", (Object)string);
        }
        this.charset = string;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCharset");
        }
    }

    public String getJMSCharset() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCharset");
        }
        String string = this.charset;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCharset");
        }
        return string;
    }

    public void clearProperties() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearProperties");
        }
        super.clearProperties();
        this.props = new Hashtable();
        this.propertiesReadOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearProperties");
        }
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBooleanProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object v = this.props.get(string);
        Boolean bl = null;
        if (v == null) {
            bl = Boolean.valueOf(null);
        } else if (v instanceof String) {
            bl = Boolean.valueOf((String)v);
        } else if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBooleanProperty", (Object)bl);
        }
        return bl;
    }

    public byte getByteProperty(String string) throws JMSException {
        Byte by;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getByteProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            by = Byte.valueOf(null);
        } else if (v instanceof String) {
            by = Byte.valueOf((String)v);
        } else if (v instanceof Byte) {
            by = (Byte)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getShortProperty", (Object)by);
        }
        return by;
    }

    public short getShortProperty(String string) throws JMSException {
        short s;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getShortProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            s = Short.valueOf(null);
        } else if (v instanceof String) {
            s = Short.valueOf((String)v);
        } else if (v instanceof Short) {
            s = (Short)v;
        } else if (v instanceof Byte) {
            s = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getShortProperty", (Object)new Short(s));
        }
        return s;
    }

    public int getIntProperty(String string) throws JMSException {
        int n;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getIntProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            n = Integer.valueOf(null);
        } else if (v instanceof String) {
            n = Integer.valueOf((String)v);
        } else if (v instanceof Integer) {
            n = (Integer)v;
        } else if (v instanceof Short) {
            n = ((Short)v).shortValue();
        } else if (v instanceof Byte) {
            n = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getIntProperty", (Object)new Integer(n));
        }
        return n;
    }

    public long getLongProperty(String string) throws JMSException {
        long l;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getLongProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            l = Long.valueOf(null);
        } else if (v instanceof String) {
            l = Long.valueOf((String)v);
        } else if (v instanceof Long) {
            l = (Long)v;
        } else if (v instanceof Integer) {
            l = ((Integer)v).intValue();
        } else if (v instanceof Short) {
            l = ((Short)v).shortValue();
        } else if (v instanceof Byte) {
            l = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getLongProperty", (Object)new Long(l));
        }
        return l;
    }

    public float getFloatProperty(String string) throws JMSException {
        Float f;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getFloatProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            f = Float.valueOf(null);
        } else if (v instanceof String) {
            f = Float.valueOf((String)v);
        } else if (v instanceof Float) {
            f = (Float)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getFloatProperty", (Object)f);
        }
        return f.floatValue();
    }

    public double getDoubleProperty(String string) throws JMSException {
        Double d;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDoubleProperty", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((v = this.props.get(string)) == null) {
            d = Double.valueOf(null);
        } else if (v instanceof String) {
            d = Double.valueOf((String)v);
        } else if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof Float) {
            d = new Double(((Float)v).doubleValue());
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDoubleProperty", (Object)d);
        }
        return d;
    }

    public String getStringProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getStringProperty", (Object)string);
        }
        if (string == null) {
            throw new JMSException("MQJMS1029", string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object v = this.props.get(string);
        String string2 = null;
        if (v != null && v != NULL) {
            string2 = v.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getStringProperty", (Object)string2);
        }
        return string2;
    }

    public Object getObjectProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getObjectProperty", (Object)string);
        }
        if (string == null) {
            throw new JMSException("MQJMS1029", string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object v = this.props.get(string);
        Object var3_3 = null;
        if (v != null && v != NULL) {
            var3_3 = v;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObjectProperty", var3_3);
        }
        return var3_3;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getPropertyNames");
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Enumeration enumeration = this.props.keys();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getPropertyNames", enumeration);
        }
        return enumeration;
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBooleanProperty", (Object)string, (Object)new Boolean(bl));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Boolean(bl));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBooleanProperty");
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setByteProperty", (Object)string, (Object)new Byte(by));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Byte(by));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setByteProperty");
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setShortProperty", (Object)string, (Object)new Short(s));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Short(s));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setShortProperty");
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setIntProperty", (Object)string, (Object)new Integer(n));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Integer(n));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setIntProperty");
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setLongProperty", (Object)string, (Object)new Long(l));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Long(l));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setLongProperty");
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setFloatProperty", (Object)string, (Object)new Float(f));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Float(f));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setFloatProperty");
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDoubleProperty", (Object)string, (Object)new Double(d));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        this.props.put(string, new Double(d));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDoubleProperty");
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setStringProperty", (Object)string, (Object)string2);
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = "MQJMS1058";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string);
            throw new IllegalArgumentException(string4);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        if (string2 == null) {
            this.props.put(string, NULL);
        } else {
            this.props.put(string, string2);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setStringProperty");
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObjectProperty", (Object)string, object);
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = "MQJMS1058";
            String string3 = ConfigEnvironment.getErrorMessage(string2, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            throw new MessageFormatException("MQJMS1058", string);
        }
        if (object == null) {
            this.props.put(string, NULL);
        } else if (object instanceof byte[]) {
            this.props.put(string, "");
        } else {
            if (!(object instanceof String || object instanceof Number || object instanceof Boolean)) {
                String string4 = "MQJMS0006";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                throw new MessageFormatException(string5, string4);
            }
            this.props.put(string, object);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObjectProperty");
        }
    }

    public void acknowledge() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledge");
        }
        if (this.session != null && !this.session.getTransacted() && this.session.getAcknowledgeMode() != 1 && this.session.getAcknowledgeMode() != 3) {
            String string = "MQJMS6404";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledge");
        }
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBudy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJMSCorrelationID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCorrelationID", (Object)string);
        }
        if (string != null) {
            if (string.startsWith("ID:")) {
                byte[] byArray = this.hexToBin(string, 3);
            }
            this.setCorrelationID(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCorrelationID");
        }
    }

    public boolean propertyExists(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"propertyExists", (Object)string);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        boolean bl = ((Hashtable)this.props).containsKey(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"propertyExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    public int length() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"length");
        }
        int n = this.cursor.getEncodedLength(null);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"length", (Object)new Integer(n));
        }
        return n;
    }

    public Object writeReplace() {
        return new SerialMessage(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\nJMS Message class: " + this.messageClass);
            stringBuffer.append("\n  JMSDeliveryMode: " + this.getJMSDeliveryMode());
            stringBuffer.append("\n  JMSExpiration:   " + this.getJMSExpiration());
            stringBuffer.append("\n  JMSPriority:     " + this.getJMSPriority());
            stringBuffer.append("\n  JMSMessageID:    " + this.getJMSMessageID());
            stringBuffer.append("\n  JMSTimestamp:    " + this.getJMSTimestamp());
            stringBuffer.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            stringBuffer.append("\n  JMSDestination:  " + this.getJMSDestination());
            stringBuffer.append("\n  JMSReplyTo:      " + this.getJMSReplyTo());
            stringBuffer.append("\n  JMSRedelivered:  " + this.getJMSRedelivered());
            Enumeration enumeration = this.getPropertyNames();
            int n = 999;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n  " + string + ":" + this.getObjectProperty(string));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    byte[] hexToBin(String string, int n) throws JMSException {
        int n2 = string.length() - n;
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 0 || n2 % 2 != 0) {
            throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-297750435, (Object[])new Object[]{new String(string)}));
        }
        byte[] byArray = new byte[n2 /= 2];
        for (int i = 0; i < n2; ++i) {
            int n3 = Character.digit(string.charAt(2 * i + n), 16) << 4;
            int n4 = Character.digit(string.charAt(2 * i + n + 1), 16);
            if (n3 < 0 || n4 < 0) {
                throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-297750435, (Object[])new Object[]{new String(string)}));
            }
            byArray[i] = (byte)(n3 + n4);
        }
        return byArray;
    }

    private boolean isSettablePropertyName(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"Checking property name for validity", (Object)string);
        }
        if (string == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        if (string.startsWith("JMS")) {
            if (string.equals("JMS_IBM_Encoding") || string.equals("JMS_IBM_Character_Set")) {
                return true;
            }
            if (string.equals("JMSXGroupID") || string.equals("JMSXGroupSeq")) {
                return true;
            }
            return this.jmsStrings.getJMS_IBM_names().containsKey(string);
        }
        return true;
    }
}

