/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.MinimalIOException;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSListenerSetException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.SubscriptionInfoImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
implements MessageConsumer,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MessageConsumerImpl.java, disthub, j600, j600-101-060328 1.28.1.2 05/09/26 10:38:22";
    private static final DebugObject debug = new DebugObject("MessageConsumerImpl");
    private boolean active = true;
    private MessageQueue receiveQueue;
    private String messageSelector;
    protected SessionImpl parentSession;
    private MessageQueue sessionDispatchQueue;
    private MessageListener listener;
    private MessageListener sessionListener;
    protected MessageListener activeListener;
    protected MQTopic topic;
    protected boolean noLocalMessages;
    protected int subId = -1;
    protected SubscriptionInfoImpl subInfo;
    protected String appName = null;
    protected int m_subMode;
    public SessionImpl jmsSession;
    private int readers = 0;
    private int upreaders = 0;
    private Thread readThread = null;
    private Object readLockLock = new Object();

    int getSubId() {
        return this.subId;
    }

    String getSubName() {
        return this.appName;
    }

    SubscriptionInfoImpl getSubInfo() {
        return this.subInfo;
    }

    public MessageConsumerImpl(String string, SessionImpl sessionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageConsumerImpl", (Object)string, (Object)sessionImpl);
        }
        this.messageSelector = string;
        this.receiveQueue = new MessageQueue(sessionImpl.getConnection().sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        if (sessionImpl.getConnection().isStarted()) {
            this.receiveQueue.start();
        }
        this.parentSession = sessionImpl;
        sessionImpl.getConnection().addFreeSpaceHeapNode(sessionImpl.getConnection().sessionConfig.MAX_MESSAGE_QUEUE_SIZE, this.receiveQueue);
        this.sessionDispatchQueue = this.parentSession.getDispatchQueue();
        try {
            this.sessionListener = this.parentSession.getMessageListener();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "parentSession.getMessageListener() threw JMSException");
            }
            this.sessionListener = null;
        }
        this.activeListener = this.sessionListener;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageConsumerImpl");
        }
    }

    MessageConsumerImpl(MQTopic mQTopic, String string, String string2, boolean bl, int n, SessionImpl sessionImpl) throws JMSException {
        this(string, sessionImpl);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageConsumerImpl", (Object)mQTopic, (Object)string, (Object)new Boolean(bl), (Object)sessionImpl);
        }
        this.jmsSession = sessionImpl;
        this.noLocalMessages = bl;
        this.topic = mQTopic;
        ConnectionImpl connectionImpl = null;
        if (sessionImpl == null) {
            throw new JMSException("No session");
        }
        connectionImpl = sessionImpl.getConnection();
        this.subInfo = new SubscriptionInfoImpl();
        this.subInfo.topic = mQTopic.toString();
        this.subInfo.rawtopic = mQTopic;
        this.subInfo.selector = string;
        this.subInfo.subMode = n;
        this.subInfo.reconnId = null;
        this.subInfo.tsi = this;
        this.subInfo.isJMSdurable = n == 4;
        this.subInfo.appName = string2;
        int n2 = 0;
        n2 = mQTopic.getMulticast();
        if (n2 == -1) {
            n2 = this.getSession().getConnection().getMulticast();
        }
        if ((n2 & 1) > 0) {
            this.subInfo.multicastEnabled = true;
        }
        if ((n2 & 4) > 0) {
            this.subInfo.multicastReliable = true;
        }
        this.appName = string2;
        try {
            this.subId = connectionImpl.subscribeInternal(this.subInfo, false);
        }
        catch (IOException iOException) {
            if (iOException instanceof MinimalIOException) {
                int n3 = ((MinimalIOException)iOException).getErrorCode();
                if (n3 == -15) {
                    throw new InvalidDestinationException(iOException.toString());
                }
                if (n3 == -16) {
                    throw new InvalidSelectorException(iOException.toString());
                }
                if (n3 == -7 || n3 == -18) {
                    throw new JMSSecurityException(iOException.toString());
                }
            }
            throw new JMSException(iOException.getMessage());
        }
        catch (ArithmeticException arithmeticException) {
            throw new InvalidSelectorException(arithmeticException.toString());
        }
        if (n2 != 0 && (n2 & 2) == 0 && !this.isSubscriptionReliableMulticast()) {
            throw ConfigEnvironment.newException("MQJMS1102");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageConsumerImpl");
        }
    }

    public String getMessageSelector() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageSelector");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageSelector", (Object)this.messageSelector);
        }
        return this.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageListener");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageListener", (Object)this.listener);
        }
        return this.listener;
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setMessageListener", (Object)messageListener);
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        this.listener = messageListener;
        if (this.sessionListener == null) {
            this.setActiveListener(messageListener);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setMessageListener");
        }
    }

    synchronized void setSessionMessageListener(MessageListener messageListener) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setSessionMessageListener", (Object)messageListener);
        }
        MessageListener messageListener2 = this.sessionListener;
        this.sessionListener = messageListener;
        if (messageListener2 != messageListener) {
            if (messageListener != null) {
                this.setActiveListener(messageListener);
            } else {
                this.setActiveListener(this.listener);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setSessionMessageListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void setActiveListener(MessageListener messageListener) {
        MessageListener messageListener2;
        boolean bl;
        block15: {
            block16: {
                block13: {
                    block14: {
                        if (debug.debugIt(32)) {
                            debug.debug(-165922073994779L, (Object)"setActiveListener", (Object)messageListener);
                        }
                        SessionImpl sessionImpl = this.parentSession;
                        // MONITORENTER : sessionImpl
                        bl = this.parentSession.isStopped();
                        if (!bl) {
                            this.parentSession.stop();
                        }
                        this.acquireWriteLock();
                        try {
                            messageListener2 = this.activeListener;
                            this.activeListener = messageListener;
                            if (messageListener != null || messageListener2 != null) break block13;
                            if (debug.debugIt(64)) {
                                debug.debug(-142394261359015L, (Object)"setActiveListener");
                            }
                            this.releaseWriteLock();
                            if (bl) break block14;
                            this.parentSession.start();
                        }
                        catch (Throwable throwable) {
                            this.releaseWriteLock();
                            if (bl) throw throwable;
                            this.parentSession.start();
                            throw throwable;
                        }
                    }
                    // MONITOREXIT : sessionImpl
                    return;
                }
                if (messageListener == null || messageListener2 == null) break block15;
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"setActiveListener");
                }
                this.releaseWriteLock();
                if (bl) break block16;
                this.parentSession.start();
            }
            // MONITOREXIT : sessionImpl
            return;
        }
        if (messageListener != null && messageListener2 == null) {
            this.receiveQueue.moveTo(this.sessionDispatchQueue);
        }
        if (messageListener == null && messageListener2 != null) {
            this.sessionDispatchQueue.moveMessagesFor(this, this.receiveQueue);
        }
        this.releaseWriteLock();
        if (!bl) {
            this.parentSession.start();
        }
        if (!debug.debugIt(64)) return;
        debug.debug(-142394261359015L, (Object)"setActiveListener");
    }

    protected void preReceive() {
    }

    public Message receive() throws JMSListenerSetException, IllegalStateException, JMSWrappedException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
        }
        try {
            MessageImpl messageImpl = this.receiveQueue.dequeue();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)messageImpl);
            }
            return messageImpl;
        }
        catch (Exception exception) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1984288331, (Object[])new Object[]{exception}), exception);
        }
    }

    public Message receive(long l) throws JMSException, IllegalStateException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive", (Object)new Long(l));
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (l == 0L) {
            Message message = this.receive();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)message);
            }
            return message;
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
        }
        try {
            MessageImpl messageImpl = this.receiveQueue.dequeueWait(l);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)messageImpl);
            }
            return messageImpl;
        }
        catch (InterruptedException interruptedException) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1984288331, (Object[])new Object[]{interruptedException}), interruptedException);
        }
    }

    public Message receiveNoWait() throws JMSException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receiveNoWait");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
        }
        MessageImpl messageImpl = this.receiveQueue.dequeueNoWait();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"receiveNoWait", (Object)messageImpl);
        }
        return messageImpl;
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        SessionImpl sessionImpl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)exception, (Object)new Boolean(bl));
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"close");
            }
            return;
        }
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        if ((sessionImpl = this.getSession()) == null) {
            return;
        }
        sessionImpl.closed(this);
        ConnectionImpl connectionImpl = sessionImpl.getConnection();
        if (connectionImpl.isActive()) {
            try {
                if (this.subInfo.isJMSdurable) {
                    this.ackLatest(true);
                    connectionImpl.deactivate(this.subInfo.reconnId);
                } else {
                    connectionImpl.unsubscribe(this.subInfo.subid);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (this.active) {
            this.active = false;
            this.receiveQueue.close(exception, bl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        return !this.active;
    }

    public boolean newMessage(MessageImpl messageImpl) {
        return this.newMessage(messageImpl, true);
    }

    public boolean newMessage(MessageImpl messageImpl, boolean bl) {
        boolean bl2;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"newMessage", (Object)messageImpl);
        }
        if (messageImpl.getConsumer() != null) {
            messageImpl = messageImpl.duplicate();
        }
        messageImpl.setConsumer(this);
        messageImpl.setDisposable(bl);
        messageImpl.setSession(this.parentSession);
        this.acquireReadLock();
        try {
            bl2 = this.activeListener != null ? this.sessionDispatchQueue.enqueue(messageImpl) : this.receiveQueue.enqueue(messageImpl);
            if (!bl2) {
                this.active = false;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            this.releaseReadLock();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessage", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dispatch", (Object)messageImpl);
        }
        this.acquireUpReadLock();
        try {
            this.activeListener.onMessage((Message)messageImpl);
        }
        finally {
            this.releaseUpReadLock();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dispatch");
        }
    }

    SessionImpl getSession() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getSession");
        }
        SessionImpl sessionImpl = null;
        if (this.active) {
            sessionImpl = this.parentSession;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getSession", (Object)sessionImpl);
        }
        return sessionImpl;
    }

    MessageQueue getReceiveQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getReceiveQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getReceiveQueue", (Object)this.receiveQueue);
        }
        return this.receiveQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireWriteLock() {
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireWriteLock");
            }
            Thread thread = Thread.currentThread();
            while (this.readers > 0 || this.upreaders > 0 && thread != this.readThread) {
                try {
                    this.readLockLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireWriteLock");
            }
        }
    }

    void releaseWriteLock() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"releaseWriteLock");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"releaseWriteLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireReadLock() {
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireReadLock");
            }
            ++this.readers;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireReadLock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReadLock() {
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"releaseReadLock");
            }
            --this.readers;
            this.readLockLock.notifyAll();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"releaseReadLock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireUpReadLock() {
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireUpReadLock");
            }
            ++this.upreaders;
            this.readThread = Thread.currentThread();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireUpReadLock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseUpReadLock() {
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"releaseUpReadLock");
            }
            --this.upreaders;
            if (this.upreaders == 0) {
                this.readThread = null;
            }
            this.readLockLock.notifyAll();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"releaseUpReadLock");
            }
        }
    }

    void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.receiveQueue.stop();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
    }

    void start() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.receiveQueue.start();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
    }

    public boolean isSubscriptionMulticast() {
        return this.subInfo.multicastEnabled;
    }

    public boolean isSubscriptionReliableMulticast() {
        return this.subInfo.multicastReliable;
    }

    protected void ackLatest(boolean bl) throws JMSWrappedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ackLatest", (Object)new Boolean(bl));
        }
        try {
            if (!this.subInfo.isJMSdurable) {
                return;
            }
            MessageImpl messageImpl = (MessageImpl)this.subInfo.latest;
            if (this.parentSession.getAcknowledgeMode() == 1) {
                if (messageImpl != null) {
                    this.parentSession.getConnection().release(this.subInfo.reconnId, messageImpl.vc, true);
                    this.subInfo.acked = true;
                }
            } else if (this.parentSession.getAcknowledgeMode() == 3 && messageImpl != null) {
                this.parentSession.getConnection().release(this.subInfo.reconnId, messageImpl.vc, bl);
            }
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ackLatest");
        }
    }
}

