/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;

public class MQXAQueueConnectionFactory
extends MQQueueConnectionFactory
implements XAQueueConnectionFactory {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXAQueueConnectionFactory.java, jms, j600, j600-101-060328 1.20.1.1 05/05/25 15:57:16";
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAQueueConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAQueueConnectionFactoryFactory;

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        try {
            MQXAQueueConnection mQXAQueueConnection;
            if (Trace.isOn) {
                Trace.entry(this, "createXAQueueConnection");
            }
            if (2 == this.getTransportType()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
                throw jMSException;
            }
            MQXAQueueConnection mQXAQueueConnection2 = mQXAQueueConnection = new MQXAQueueConnection(this);
            return mQXAQueueConnection2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAQueueConnection");
            }
        }
    }

    public XAQueueConnection createXAQueueConnection(String string, String string2) throws JMSException {
        try {
            Object object;
            MQXAQueueConnection mQXAQueueConnection;
            if (Trace.isOn) {
                Trace.entry(this, "createXAQueueConnection");
                Trace.trace(this, "userName, password = " + string + ", " + string2);
            }
            if (MQEnvironment.runningInWS() && string != null && string.length() > 12) {
                if (Trace.isOn) {
                    Trace.trace(this, "Running in Websphere with userName longer than 12 chars");
                    Trace.trace(this, "UserName is " + string);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1092", string);
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 1: 
                case 3: {
                    mQXAQueueConnection = new MQXAQueueConnection(this, string, string2);
                    break;
                }
                case 0: {
                    object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("user.name");
                        }
                    });
                    if (!((String)object).equals(string)) {
                        String string3 = "MQJMS2013";
                        String string4 = ConfigEnvironment.getErrorMessage(string3);
                        throw new JMSSecurityException(string4, string3);
                    }
                    mQXAQueueConnection = new MQXAQueueConnection(this, string, string2);
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            object = mQXAQueueConnection;
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAQueueConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference = new Reference((class$com$ibm$mq$jms$MQXAQueueConnectionFactory == null ? (class$com$ibm$mq$jms$MQXAQueueConnectionFactory = MQXAQueueConnectionFactory.class$("com.ibm.mq.jms.MQXAQueueConnectionFactory")) : class$com$ibm$mq$jms$MQXAQueueConnectionFactory).getName(), (class$com$ibm$mq$jms$MQXAQueueConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQXAQueueConnectionFactoryFactory = MQXAQueueConnectionFactory.class$("com.ibm.mq.jms.MQXAQueueConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQXAQueueConnectionFactoryFactory).getName(), null);
            super.populateReference(reference);
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicConnection");
                Trace.trace(this, "userName  = " + string);
                if (string2 != null) {
                    Trace.trace(this, "password is non-null");
                }
            }
            XAQueueConnection xAQueueConnection = this.createXAQueueConnection(string, string2);
            return xAQueueConnection;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXAConnection");
            }
            XAQueueConnection xAQueueConnection = this.createXAQueueConnection();
            return xAQueueConnection;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public void setTransportType(int n) throws JMSException {
        if (n == 2) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
            throw jMSException;
        }
        super.setTransportType(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

